/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.oath.halodb.InMemoryIndexMetaData;
import com.oath.halodb.IndexFileEntry;

class Utils {
    Utils() {
    }

    static long roundUpToPowerOf2(long number) {
        return number > 1L ? Long.highestOneBit(number - 1L << 1) : 1L;
    }

    static int getValueOffset(int recordOffset, byte[] key) {
        return recordOffset + 18 + key.length;
    }

    static int getRecordSize(int keySize, int valueSize) {
        return keySize + valueSize + 18;
    }

    static int getValueSize(int recordSize, byte[] key) {
        return recordSize - 18 - key.length;
    }

    static InMemoryIndexMetaData getMetaData(IndexFileEntry entry, int fileId) {
        return new InMemoryIndexMetaData(fileId, Utils.getValueOffset(entry.getRecordOffset(), entry.getKey()), Utils.getValueSize(entry.getRecordSize(), entry.getKey()), entry.getSequenceNumber());
    }

    static long toUnsignedIntFromInt(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    static int toSignedIntFromLong(long value) {
        return (int)(value & 0xFFFFFFFFL);
    }

    static int toUnsignedByte(byte value) {
        return value & 0xFF;
    }
}

