/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.oath.halodb.Utils;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;

class TombstoneEntry {
    static final int TOMBSTONE_ENTRY_HEADER_SIZE = 14;
    static final int CHECKSUM_SIZE = 4;
    static final int CHECKSUM_OFFSET = 0;
    static final int VERSION_OFFSET = 4;
    static final int SEQUENCE_NUMBER_OFFSET = 5;
    static final int KEY_SIZE_OFFSET = 13;
    private final byte[] key;
    private final long sequenceNumber;
    private final long checkSum;
    private final int version;

    TombstoneEntry(byte[] key, long sequenceNumber, long checkSum, int version) {
        this.key = key;
        this.sequenceNumber = sequenceNumber;
        this.checkSum = checkSum;
        this.version = version;
    }

    byte[] getKey() {
        return this.key;
    }

    long getSequenceNumber() {
        return this.sequenceNumber;
    }

    int getVersion() {
        return this.version;
    }

    long getCheckSum() {
        return this.checkSum;
    }

    int size() {
        return 14 + this.key.length;
    }

    ByteBuffer[] serialize() {
        byte keySize = (byte)this.key.length;
        ByteBuffer header = ByteBuffer.allocate(14);
        header.put(4, (byte)this.version);
        header.putLong(5, this.sequenceNumber);
        header.put(13, keySize);
        long crc32 = this.computeCheckSum(header.array());
        header.putInt(0, Utils.toSignedIntFromLong(crc32));
        return new ByteBuffer[]{header, ByteBuffer.wrap(this.key)};
    }

    static TombstoneEntry deserialize(ByteBuffer buffer) {
        long crc32 = Utils.toUnsignedIntFromInt(buffer.getInt());
        int version = Utils.toUnsignedByte(buffer.get());
        long sequenceNumber = buffer.getLong();
        byte keySize = buffer.get();
        byte[] key = new byte[keySize];
        buffer.get(key);
        return new TombstoneEntry(key, sequenceNumber, crc32, version);
    }

    static TombstoneEntry deserializeIfNotCorrupted(ByteBuffer buffer) {
        if (buffer.remaining() < 14) {
            return null;
        }
        long crc32 = Utils.toUnsignedIntFromInt(buffer.getInt());
        int version = Utils.toUnsignedByte(buffer.get());
        long sequenceNumber = buffer.getLong();
        byte keySize = buffer.get();
        if (sequenceNumber < 0L || keySize <= 0 || version < 0 || version > 255 || buffer.remaining() < keySize) {
            return null;
        }
        byte[] key = new byte[keySize];
        buffer.get(key);
        TombstoneEntry entry = new TombstoneEntry(key, sequenceNumber, crc32, version);
        if (entry.computeCheckSum() != entry.checkSum) {
            return null;
        }
        return entry;
    }

    private long computeCheckSum(byte[] header) {
        CRC32 crc32 = new CRC32();
        crc32.update(header, 4, 10);
        crc32.update(this.key);
        return crc32.getValue();
    }

    long computeCheckSum() {
        ByteBuffer header = ByteBuffer.allocate(14);
        header.put(4, (byte)this.version);
        header.putLong(5, this.sequenceNumber);
        header.put(13, (byte)this.key.length);
        return this.computeCheckSum(header.array());
    }
}

