/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import com.oath.halodb.HashAlgorithm;
import com.oath.halodb.HashTableUtil;
import com.oath.halodb.HashTableValueSerializer;
import com.oath.halodb.Hasher;
import com.oath.halodb.KeyBuffer;
import com.oath.halodb.MemoryPoolAddress;
import com.oath.halodb.MemoryPoolChunk;
import com.oath.halodb.OffHeapHashTableBuilder;
import com.oath.halodb.Segment;
import com.oath.halodb.Uns;
import com.oath.halodb.histo.EstimatedHistogram;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SegmentWithMemoryPool<V>
extends Segment<V> {
    private static final Logger logger = LoggerFactory.getLogger(SegmentWithMemoryPool.class);
    private static final int MAX_TABLE_SIZE = 0x40000000;
    private long hitCount = 0L;
    private long size = 0L;
    private long missCount = 0L;
    private long putAddCount = 0L;
    private long putReplaceCount = 0L;
    private long removeCount = 0L;
    private long threshold = 0L;
    private final float loadFactor;
    private long rehashes = 0L;
    private final List<MemoryPoolChunk> chunks;
    private byte currentChunkIndex = (byte)-1;
    private final int chunkSize;
    private final MemoryPoolAddress emptyAddress;
    private MemoryPoolAddress freeListHead = this.emptyAddress = new MemoryPoolAddress(-1, -1);
    private long freeListSize = 0L;
    private final int fixedSlotSize;
    private final HashTableValueSerializer<V> valueSerializer;
    private Table table;
    private final ByteBuffer oldValueBuffer = ByteBuffer.allocate(this.fixedValueLength);
    private final ByteBuffer newValueBuffer = ByteBuffer.allocate(this.fixedValueLength);
    private final HashAlgorithm hashAlgorithm;

    SegmentWithMemoryPool(OffHeapHashTableBuilder<V> builder) {
        super(builder.getValueSerializer(), builder.getFixedValueSize(), builder.getFixedKeySize(), builder.getHasher());
        this.chunks = new ArrayList<MemoryPoolChunk>();
        this.chunkSize = builder.getMemoryPoolChunkSize();
        this.valueSerializer = builder.getValueSerializer();
        this.fixedSlotSize = 6 + this.fixedKeyLength + this.fixedValueLength;
        this.hashAlgorithm = builder.getHashAlgorighm();
        int hts = builder.getHashTableSize();
        if (hts <= 0) {
            hts = 8192;
        }
        if (hts < 256) {
            hts = 256;
        }
        int msz = Ints.checkedCast((long)HashTableUtil.roundUpToPowerOf2(hts, 0x40000000L));
        this.table = Table.create(msz);
        if (this.table == null) {
            throw new RuntimeException("unable to allocate off-heap memory for segment");
        }
        float lf = builder.getLoadFactor();
        if ((double)lf <= 0.0) {
            lf = 0.75f;
        }
        this.loadFactor = lf;
        this.threshold = (long)((double)this.table.size() * (double)this.loadFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getEntry(KeyBuffer key) {
        boolean wasFirst = this.lock();
        try {
            MemoryPoolAddress address = this.table.getFirst(key.hash());
            while (address.chunkIndex >= 0) {
                MemoryPoolChunk chunk = this.chunks.get(address.chunkIndex);
                if (chunk.compareKey(address.chunkOffset, key.buffer)) {
                    ++this.hitCount;
                    V v = this.valueSerializer.deserialize(chunk.readOnlyValueByteBuffer(address.chunkOffset));
                    return v;
                }
                address = this.getNext(address);
            }
            ++this.missCount;
            V v = null;
            return v;
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsEntry(KeyBuffer key) {
        boolean wasFirst = this.lock();
        try {
            MemoryPoolAddress address = this.table.getFirst(key.hash());
            while (address.chunkIndex >= 0) {
                MemoryPoolChunk chunk = this.chunks.get(address.chunkIndex);
                if (chunk.compareKey(address.chunkOffset, key.buffer)) {
                    ++this.hitCount;
                    boolean bl = true;
                    return bl;
                }
                address = this.getNext(address);
            }
            ++this.missCount;
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean putEntry(byte[] key, V value, long hash, boolean putIfAbsent, V oldValue) {
        boolean wasFirst = this.lock();
        try {
            MemoryPoolAddress first;
            if (oldValue != null) {
                this.oldValueBuffer.clear();
                this.valueSerializer.serialize(oldValue, this.oldValueBuffer);
            }
            this.newValueBuffer.clear();
            this.valueSerializer.serialize(value, this.newValueBuffer);
            MemoryPoolAddress address2 = first = this.table.getFirst(hash);
            while (address2.chunkIndex >= 0) {
                MemoryPoolChunk chunk = this.chunks.get(address2.chunkIndex);
                if (chunk.compareKey(address2.chunkOffset, key)) {
                    if (putIfAbsent) {
                        boolean bl = false;
                        return bl;
                    }
                    if (oldValue != null && !chunk.compareValue(address2.chunkOffset, this.oldValueBuffer.array())) {
                        boolean bl = false;
                        return bl;
                    }
                    chunk.setValue(this.newValueBuffer.array(), address2.chunkOffset);
                    ++this.putReplaceCount;
                    boolean bl = true;
                    return bl;
                }
                address2 = this.getNext(address2);
            }
            if (oldValue != null) {
                boolean address2 = false;
                return address2;
            }
            if (this.size >= this.threshold) {
                this.rehash();
                first = this.table.getFirst(hash);
            }
            MemoryPoolAddress nextSlot = this.writeToFreeSlot(key, this.newValueBuffer.array(), first);
            this.table.addAsHead(hash, nextSlot);
            ++this.size;
            ++this.putAddCount;
        }
        finally {
            this.unlock(wasFirst);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntry(KeyBuffer key) {
        boolean wasFirst = this.lock();
        try {
            MemoryPoolAddress previous = null;
            MemoryPoolAddress address = this.table.getFirst(key.hash());
            while (address.chunkIndex >= 0) {
                MemoryPoolChunk chunk = this.chunks.get(address.chunkIndex);
                if (chunk.compareKey(address.chunkOffset, key.buffer)) {
                    this.removeInternal(address, previous, key.hash());
                    ++this.removeCount;
                    --this.size;
                    boolean bl = true;
                    return bl;
                }
                previous = address;
                address = this.getNext(address);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    private MemoryPoolAddress getNext(MemoryPoolAddress address) {
        if (address.chunkIndex < 0 || address.chunkIndex >= this.chunks.size()) {
            throw new IllegalArgumentException("Invalid chunk index " + address.chunkIndex + ". Chunk size " + this.chunks.size());
        }
        MemoryPoolChunk chunk = this.chunks.get(address.chunkIndex);
        return chunk.getNextAddress(address.chunkOffset);
    }

    private MemoryPoolAddress writeToFreeSlot(byte[] key, byte[] value, MemoryPoolAddress nextAddress) {
        if (!this.freeListHead.equals(this.emptyAddress)) {
            MemoryPoolAddress temp = this.freeListHead;
            this.freeListHead = this.chunks.get(this.freeListHead.chunkIndex).getNextAddress(this.freeListHead.chunkOffset);
            this.chunks.get(temp.chunkIndex).fillSlot(temp.chunkOffset, key, value, nextAddress);
            --this.freeListSize;
            return temp;
        }
        if (this.currentChunkIndex == -1 || this.chunks.get(this.currentChunkIndex).remaining() < this.fixedSlotSize) {
            if (this.chunks.size() > 127) {
                logger.error("No more memory left. Each segment can have at most {} chunks.", (Object)128);
                throw new OutOfMemoryError("Each segment can have at most 128 chunks.");
            }
            this.chunks.add(MemoryPoolChunk.create(this.chunkSize, this.fixedKeyLength, this.fixedValueLength));
            this.currentChunkIndex = (byte)(this.currentChunkIndex + 1);
        }
        MemoryPoolChunk currentWriteChunk = this.chunks.get(this.currentChunkIndex);
        MemoryPoolAddress slotAddress = new MemoryPoolAddress(this.currentChunkIndex, currentWriteChunk.getWriteOffset());
        currentWriteChunk.fillNextSlot(key, value, nextAddress);
        return slotAddress;
    }

    private void removeInternal(MemoryPoolAddress address, MemoryPoolAddress previous, long hash) {
        MemoryPoolAddress next = this.chunks.get(address.chunkIndex).getNextAddress(address.chunkOffset);
        if (this.table.getFirst(hash).equals(address)) {
            this.table.addAsHead(hash, next);
        } else {
            if (previous == null) {
                throw new IllegalArgumentException("Removing entry which is not head but with previous null");
            }
            this.chunks.get(previous.chunkIndex).setNextAddress(previous.chunkOffset, next);
        }
        this.chunks.get(address.chunkIndex).setNextAddress(address.chunkOffset, this.freeListHead);
        this.freeListHead = address;
        ++this.freeListSize;
    }

    private void rehash() {
        long start = System.currentTimeMillis();
        Table currentTable = this.table;
        int tableSize = currentTable.size();
        if (tableSize > 0x40000000) {
            return;
        }
        Table newTable = Table.create(tableSize * 2);
        Hasher hasher = Hasher.create(this.hashAlgorithm);
        for (int i = 0; i < tableSize; ++i) {
            MemoryPoolAddress address = this.table.getFirst(i);
            while (address.chunkIndex >= 0) {
                long hash = this.chunks.get(address.chunkIndex).computeHash(address.chunkOffset, hasher);
                MemoryPoolAddress next = this.getNext(address);
                MemoryPoolAddress first = newTable.getFirst(hash);
                newTable.addAsHead(hash, address);
                this.chunks.get(address.chunkIndex).setNextAddress(address.chunkOffset, first);
                address = next;
            }
        }
        this.threshold = (long)((float)newTable.size() * this.loadFactor);
        this.table.release();
        this.table = newTable;
        ++this.rehashes;
        logger.info("Completed rehashing segment in {} ms.", (Object)(System.currentTimeMillis() - start));
    }

    @Override
    long size() {
        return this.size;
    }

    @Override
    void release() {
        boolean wasFirst = this.lock();
        try {
            this.chunks.forEach(MemoryPoolChunk::destroy);
            this.chunks.clear();
            this.currentChunkIndex = (byte)-1;
            this.size = 0L;
            this.table.release();
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    @Override
    void clear() {
        boolean wasFirst = this.lock();
        try {
            this.chunks.forEach(MemoryPoolChunk::destroy);
            this.chunks.clear();
            this.currentChunkIndex = (byte)-1;
            this.size = 0L;
            this.table.clear();
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    @Override
    long hitCount() {
        return this.hitCount;
    }

    @Override
    long missCount() {
        return this.missCount;
    }

    @Override
    long putAddCount() {
        return this.putAddCount;
    }

    @Override
    long putReplaceCount() {
        return this.putReplaceCount;
    }

    @Override
    long removeCount() {
        return this.removeCount;
    }

    @Override
    void resetStatistics() {
        this.rehashes = 0L;
        this.hitCount = 0L;
        this.missCount = 0L;
        this.putAddCount = 0L;
        this.putReplaceCount = 0L;
        this.removeCount = 0L;
    }

    @Override
    long numberOfChunks() {
        return this.chunks.size();
    }

    @Override
    long numberOfSlots() {
        return this.chunks.size() * this.chunkSize / this.fixedSlotSize;
    }

    @Override
    long freeListSize() {
        return this.freeListSize;
    }

    @Override
    long rehashes() {
        return this.rehashes;
    }

    @Override
    float loadFactor() {
        return this.loadFactor;
    }

    @Override
    int hashTableSize() {
        return this.table.size();
    }

    @Override
    void updateBucketHistogram(EstimatedHistogram hist) {
        boolean wasFirst = this.lock();
        try {
            this.table.updateBucketHistogram(hist, this.chunks);
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    @VisibleForTesting
    MemoryPoolAddress getFreeListHead() {
        return this.freeListHead;
    }

    @VisibleForTesting
    int getChunkWriteOffset(int index) {
        return this.chunks.get(index).getWriteOffset();
    }

    static final class Table {
        final int mask;
        final long address;
        private boolean released;

        static Table create(int hashTableSize) {
            int msz = Ints.checkedCast((long)(5L * (long)hashTableSize));
            long address = Uns.allocate(msz, true);
            return address != 0L ? new Table(address, hashTableSize) : null;
        }

        private Table(long address, int hashTableSize) {
            this.address = address;
            this.mask = hashTableSize - 1;
            this.clear();
        }

        void clear() {
            Uns.setMemory(this.address, 0L, 5L * (long)this.size(), (byte)-1);
        }

        void release() {
            Uns.free(this.address);
            this.released = true;
        }

        protected void finalize() throws Throwable {
            if (!this.released) {
                Uns.free(this.address);
            }
            super.finalize();
        }

        MemoryPoolAddress getFirst(long hash) {
            long bOffset = this.address + this.bucketOffset(hash);
            byte chunkIndex = Uns.getByte(bOffset, 0L);
            int chunkOffset = Uns.getInt(bOffset, 1L);
            return new MemoryPoolAddress(chunkIndex, chunkOffset);
        }

        void addAsHead(long hash, MemoryPoolAddress entryAddress) {
            long bOffset = this.address + this.bucketOffset(hash);
            Uns.putByte(bOffset, 0L, entryAddress.chunkIndex);
            Uns.putInt(bOffset, 1L, entryAddress.chunkOffset);
        }

        long bucketOffset(long hash) {
            return (long)this.bucketIndexForHash(hash) * 5L;
        }

        private int bucketIndexForHash(long hash) {
            return (int)(hash & (long)this.mask);
        }

        int size() {
            return this.mask + 1;
        }

        void updateBucketHistogram(EstimatedHistogram h, List<MemoryPoolChunk> chunks) {
            for (int i = 0; i < this.size(); ++i) {
                int len = 0;
                MemoryPoolAddress adr = this.getFirst(i);
                while (adr.chunkIndex >= 0) {
                    ++len;
                    adr = chunks.get(adr.chunkIndex).getNextAddress(adr.chunkOffset);
                }
                h.add(len + 1);
            }
        }
    }
}

