/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.google.common.primitives.Ints;
import com.oath.halodb.HashAlgorithm;
import com.oath.halodb.HashTableUtil;
import com.oath.halodb.Hasher;
import com.oath.halodb.KeyBuffer;
import com.oath.halodb.LongArrayList;
import com.oath.halodb.NonMemoryPoolHashEntries;
import com.oath.halodb.OffHeapHashTableBuilder;
import com.oath.halodb.Segment;
import com.oath.halodb.Uns;
import com.oath.halodb.histo.EstimatedHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SegmentNonMemoryPool<V>
extends Segment<V> {
    private static final Logger logger = LoggerFactory.getLogger(SegmentNonMemoryPool.class);
    private static final int MAX_TABLE_SIZE = 0x40000000;
    long size;
    Table table;
    private long hitCount;
    private long missCount;
    private long putAddCount;
    private long putReplaceCount;
    private long removeCount;
    private long threshold;
    private final float loadFactor;
    private long rehashes;
    long evictedEntries;
    private final HashAlgorithm hashAlgorithm;
    private static final boolean throwOOME = true;

    SegmentNonMemoryPool(OffHeapHashTableBuilder<V> builder) {
        super(builder.getValueSerializer(), builder.getFixedValueSize(), builder.getHasher());
        this.hashAlgorithm = builder.getHashAlgorighm();
        int hts = builder.getHashTableSize();
        if (hts <= 0) {
            hts = 8192;
        }
        if (hts < 256) {
            hts = 256;
        }
        int msz = Ints.checkedCast((long)HashTableUtil.roundUpToPowerOf2(hts, 0x40000000L));
        this.table = Table.create(msz, true);
        if (this.table == null) {
            throw new RuntimeException("unable to allocate off-heap memory for segment");
        }
        float lf = builder.getLoadFactor();
        if ((double)lf <= 0.0) {
            lf = 0.75f;
        }
        this.loadFactor = lf;
        this.threshold = (long)((double)this.table.size() * (double)this.loadFactor);
    }

    @Override
    void release() {
        boolean wasFirst = this.lock();
        try {
            this.table.release();
            this.table = null;
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    @Override
    long size() {
        return this.size;
    }

    @Override
    long hitCount() {
        return this.hitCount;
    }

    @Override
    long missCount() {
        return this.missCount;
    }

    @Override
    long putAddCount() {
        return this.putAddCount;
    }

    @Override
    long putReplaceCount() {
        return this.putReplaceCount;
    }

    @Override
    long removeCount() {
        return this.removeCount;
    }

    @Override
    void resetStatistics() {
        this.rehashes = 0L;
        this.evictedEntries = 0L;
        this.hitCount = 0L;
        this.missCount = 0L;
        this.putAddCount = 0L;
        this.putReplaceCount = 0L;
        this.removeCount = 0L;
    }

    @Override
    long rehashes() {
        return this.rehashes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    V getEntry(KeyBuffer key) {
        boolean wasFirst = this.lock();
        try {
            long hashEntryAdr = this.table.getFirst(key.hash());
            while (hashEntryAdr != 0L) {
                if (key.sameKey(hashEntryAdr)) {
                    ++this.hitCount;
                    Object t = this.valueSerializer.deserialize(Uns.readOnlyBuffer(hashEntryAdr, this.fixedValueLength, 9L + (long)NonMemoryPoolHashEntries.getKeyLen(hashEntryAdr)));
                    return (V)t;
                }
                hashEntryAdr = NonMemoryPoolHashEntries.getNext(hashEntryAdr);
            }
            ++this.missCount;
            V v = null;
            return v;
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean containsEntry(KeyBuffer key) {
        boolean wasFirst = this.lock();
        try {
            long hashEntryAdr = this.table.getFirst(key.hash());
            while (hashEntryAdr != 0L) {
                if (key.sameKey(hashEntryAdr)) {
                    ++this.hitCount;
                    boolean bl = true;
                    return bl;
                }
                hashEntryAdr = NonMemoryPoolHashEntries.getNext(hashEntryAdr);
            }
            ++this.missCount;
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean putEntry(byte[] key, V value, long hash, boolean ifAbsent, V oldValue) {
        long oldValueAdr = 0L;
        try {
            long hashEntryAdr;
            if (oldValue != null) {
                oldValueAdr = Uns.allocate(this.fixedValueLength, true);
                if (oldValueAdr == 0L) {
                    throw new RuntimeException("Unable to allocate " + this.fixedValueLength + " bytes in off-heap");
                }
                this.valueSerializer.serialize(oldValue, Uns.directBufferFor(oldValueAdr, 0L, this.fixedValueLength, false));
            }
            if ((hashEntryAdr = Uns.allocate(HashTableUtil.allocLen(key.length, this.fixedValueLength), true)) == 0L) {
                this.removeEntry(this.keySource(key));
                boolean bl = false;
                return bl;
            }
            NonMemoryPoolHashEntries.init(key.length, hashEntryAdr);
            this.serializeForPut(key, value, hashEntryAdr);
            if (this.putEntry(hashEntryAdr, hash, (long)key.length, ifAbsent, oldValueAdr)) {
                boolean bl = true;
                return bl;
            }
            Uns.free(hashEntryAdr);
            boolean bl = false;
            return bl;
        }
        finally {
            Uns.free(oldValueAdr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putEntry(long newHashEntryAdr, long hash, long keyLen, boolean putIfAbsent, long oldValueAddr) {
        long removeHashEntryAdr = 0L;
        boolean wasFirst = this.lock();
        try {
            long prevEntryAdr = 0L;
            long hashEntryAdr = this.table.getFirst(hash);
            while (hashEntryAdr != 0L) {
                if (!SegmentNonMemoryPool.notSameKey(newHashEntryAdr, hash, keyLen, hashEntryAdr)) {
                    if (putIfAbsent) {
                        boolean bl = false;
                        return bl;
                    }
                    if (oldValueAddr != 0L && !Uns.memoryCompare(hashEntryAdr, 9L + keyLen, oldValueAddr, 0L, this.fixedValueLength)) {
                        boolean bl = false;
                        return bl;
                    }
                    this.removeInternal(hashEntryAdr, prevEntryAdr, hash);
                    removeHashEntryAdr = hashEntryAdr;
                    break;
                }
                prevEntryAdr = hashEntryAdr;
                hashEntryAdr = NonMemoryPoolHashEntries.getNext(hashEntryAdr);
            }
            if (hashEntryAdr == 0L) {
                if (oldValueAddr != 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (this.size >= this.threshold) {
                    this.rehash();
                }
                ++this.size;
            }
            this.add(newHashEntryAdr, hash);
            if (hashEntryAdr == 0L) {
                ++this.putAddCount;
            } else {
                ++this.putReplaceCount;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock(wasFirst);
            if (removeHashEntryAdr != 0L) {
                Uns.free(removeHashEntryAdr);
            }
        }
    }

    private static boolean notSameKey(long newHashEntryAdr, long newHash, long newKeyLen, long hashEntryAdr) {
        long serKeyLen = NonMemoryPoolHashEntries.getKeyLen(hashEntryAdr);
        return serKeyLen != newKeyLen || !Uns.memoryCompare(hashEntryAdr, 9L, newHashEntryAdr, 9L, serKeyLen);
    }

    private void serializeForPut(byte[] key, V value, long hashEntryAdr) {
        try {
            Uns.buffer(hashEntryAdr, key.length, 9L).put(key);
            if (value != null) {
                this.valueSerializer.serialize(value, Uns.buffer(hashEntryAdr, this.fixedValueLength, 9L + (long)key.length));
            }
        }
        catch (Throwable e) {
            this.freeAndThrow(e, hashEntryAdr);
        }
    }

    private void freeAndThrow(Throwable e, long hashEntryAdr) {
        Uns.free(hashEntryAdr);
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void clear() {
        boolean wasFirst = this.lock();
        try {
            this.size = 0L;
            for (int p = 0; p < this.table.size(); ++p) {
                long hashEntryAdr = this.table.getFirst(p);
                while (hashEntryAdr != 0L) {
                    long next = NonMemoryPoolHashEntries.getNext(hashEntryAdr);
                    Uns.free(hashEntryAdr);
                    hashEntryAdr = next;
                }
            }
            this.table.clear();
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean removeEntry(KeyBuffer key) {
        long removeHashEntryAdr = 0L;
        boolean wasFirst = this.lock();
        try {
            long prevEntryAdr = 0L;
            long hashEntryAdr = this.table.getFirst(key.hash());
            while (hashEntryAdr != 0L) {
                if (key.sameKey(hashEntryAdr)) {
                    removeHashEntryAdr = hashEntryAdr;
                    this.removeInternal(hashEntryAdr, prevEntryAdr, key.hash());
                    --this.size;
                    ++this.removeCount;
                    boolean bl = true;
                    return bl;
                }
                prevEntryAdr = hashEntryAdr;
                hashEntryAdr = NonMemoryPoolHashEntries.getNext(hashEntryAdr);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock(wasFirst);
            if (removeHashEntryAdr != 0L) {
                Uns.free(removeHashEntryAdr);
            }
        }
    }

    private void rehash() {
        long start = System.currentTimeMillis();
        Table tab = this.table;
        int tableSize = tab.size();
        if (tableSize > 0x40000000) {
            return;
        }
        Table newTable = Table.create(tableSize * 2, true);
        if (newTable == null) {
            return;
        }
        Hasher hasher = Hasher.create(this.hashAlgorithm);
        for (int part = 0; part < tableSize; ++part) {
            long hashEntryAdr = tab.getFirst(part);
            while (hashEntryAdr != 0L) {
                long next = NonMemoryPoolHashEntries.getNext(hashEntryAdr);
                NonMemoryPoolHashEntries.setNext(hashEntryAdr, 0L);
                long hash = hasher.hash(hashEntryAdr, 9L, NonMemoryPoolHashEntries.getKeyLen(hashEntryAdr));
                newTable.addAsHead(hash, hashEntryAdr);
                hashEntryAdr = next;
            }
        }
        this.threshold = (long)((float)newTable.size() * this.loadFactor);
        this.table.release();
        this.table = newTable;
        ++this.rehashes;
        logger.info("Completed rehashing segment in {} ms.", (Object)(System.currentTimeMillis() - start));
    }

    @Override
    float loadFactor() {
        return this.loadFactor;
    }

    @Override
    int hashTableSize() {
        return this.table.size();
    }

    @Override
    void updateBucketHistogram(EstimatedHistogram hist) {
        boolean wasFirst = this.lock();
        try {
            this.table.updateBucketHistogram(hist);
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getEntryAddresses(int mapSegmentIndex, int nSegments, LongArrayList hashEntryAdrs) {
        boolean wasFirst = this.lock();
        try {
            while (nSegments-- > 0 && mapSegmentIndex < this.table.size()) {
                long hashEntryAdr = this.table.getFirst(mapSegmentIndex);
                while (hashEntryAdr != 0L) {
                    hashEntryAdrs.add(hashEntryAdr);
                    hashEntryAdr = NonMemoryPoolHashEntries.getNext(hashEntryAdr);
                }
                ++mapSegmentIndex;
            }
        }
        finally {
            this.unlock(wasFirst);
        }
    }

    private void removeInternal(long hashEntryAdr, long prevEntryAdr, long hash) {
        this.table.removeLink(hash, hashEntryAdr, prevEntryAdr);
    }

    private void add(long hashEntryAdr, long hash) {
        this.table.addAsHead(hash, hashEntryAdr);
    }

    public String toString() {
        return String.valueOf(this.size);
    }

    static final class Table {
        final int mask;
        final long address;
        private boolean released;

        static Table create(int hashTableSize, boolean throwOOME) {
            int msz = Ints.checkedCast((long)(8L * (long)hashTableSize));
            long address = Uns.allocate(msz, throwOOME);
            return address != 0L ? new Table(address, hashTableSize) : null;
        }

        private Table(long address, int hashTableSize) {
            this.address = address;
            this.mask = hashTableSize - 1;
            this.clear();
        }

        void clear() {
            Uns.setMemory(this.address, 0L, 8L * (long)this.size(), (byte)0);
        }

        void release() {
            Uns.free(this.address);
            this.released = true;
        }

        protected void finalize() throws Throwable {
            if (!this.released) {
                Uns.free(this.address);
            }
            super.finalize();
        }

        long getFirst(long hash) {
            return Uns.getLong(this.address, this.bucketOffset(hash));
        }

        void setFirst(long hash, long hashEntryAdr) {
            Uns.putLong(this.address, this.bucketOffset(hash), hashEntryAdr);
        }

        long bucketOffset(long hash) {
            return (long)this.bucketIndexForHash(hash) * 8L;
        }

        private int bucketIndexForHash(long hash) {
            return (int)(hash & (long)this.mask);
        }

        void removeLink(long hash, long hashEntryAdr, long prevEntryAdr) {
            long next = NonMemoryPoolHashEntries.getNext(hashEntryAdr);
            this.removeLinkInternal(hash, hashEntryAdr, prevEntryAdr, next);
        }

        void replaceSentinelLink(long hash, long hashEntryAdr, long prevEntryAdr, long newHashEntryAdr) {
            NonMemoryPoolHashEntries.setNext(newHashEntryAdr, NonMemoryPoolHashEntries.getNext(hashEntryAdr));
            this.removeLinkInternal(hash, hashEntryAdr, prevEntryAdr, newHashEntryAdr);
        }

        private void removeLinkInternal(long hash, long hashEntryAdr, long prevEntryAdr, long next) {
            long head = this.getFirst(hash);
            if (head == hashEntryAdr) {
                this.setFirst(hash, next);
            } else if (prevEntryAdr != 0L) {
                if (prevEntryAdr == -1L) {
                    long adr = head;
                    while (adr != 0L && adr != hashEntryAdr) {
                        prevEntryAdr = adr;
                        adr = NonMemoryPoolHashEntries.getNext(adr);
                    }
                }
                NonMemoryPoolHashEntries.setNext(prevEntryAdr, next);
            }
        }

        void addAsHead(long hash, long hashEntryAdr) {
            long head = this.getFirst(hash);
            NonMemoryPoolHashEntries.setNext(hashEntryAdr, head);
            this.setFirst(hash, hashEntryAdr);
        }

        int size() {
            return this.mask + 1;
        }

        void updateBucketHistogram(EstimatedHistogram h) {
            for (int i = 0; i < this.size(); ++i) {
                int len = 0;
                long adr = this.getFirst(i);
                while (adr != 0L) {
                    ++len;
                    adr = NonMemoryPoolHashEntries.getNext(adr);
                }
                h.add(len + 1);
            }
        }
    }
}

