/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.oath.halodb.HashTableValueSerializer;
import com.oath.halodb.Hasher;
import com.oath.halodb.KeyBuffer;
import com.oath.halodb.histo.EstimatedHistogram;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

abstract class Segment<V> {
    final HashTableValueSerializer<V> valueSerializer;
    final int fixedValueLength;
    final int fixedKeyLength;
    private final Hasher hasher;
    private volatile long lock;
    private static final AtomicLongFieldUpdater<Segment> lockFieldUpdater = AtomicLongFieldUpdater.newUpdater(Segment.class, "lock");

    Segment(HashTableValueSerializer<V> valueSerializer, int fixedValueLength, Hasher hasher) {
        this(valueSerializer, fixedValueLength, -1, hasher);
    }

    Segment(HashTableValueSerializer<V> valueSerializer, int fixedValueLength, int fixedKeyLength, Hasher hasher) {
        this.valueSerializer = valueSerializer;
        this.fixedValueLength = fixedValueLength;
        this.fixedKeyLength = fixedKeyLength;
        this.hasher = hasher;
    }

    boolean lock() {
        long t = Thread.currentThread().getId();
        if (t == lockFieldUpdater.get(this)) {
            return false;
        }
        while (!lockFieldUpdater.compareAndSet(this, 0L, t)) {
            Thread.yield();
        }
        return true;
    }

    void unlock(boolean wasFirst) {
        if (!wasFirst) {
            return;
        }
        long t = Thread.currentThread().getId();
        boolean r = lockFieldUpdater.compareAndSet(this, t, 0L);
        assert (r);
    }

    KeyBuffer keySource(byte[] key) {
        KeyBuffer keyBuffer = new KeyBuffer(key);
        return keyBuffer.finish(this.hasher);
    }

    abstract V getEntry(KeyBuffer var1);

    abstract boolean containsEntry(KeyBuffer var1);

    abstract boolean putEntry(byte[] var1, V var2, long var3, boolean var5, V var6);

    abstract boolean removeEntry(KeyBuffer var1);

    abstract long size();

    abstract void release();

    abstract void clear();

    abstract long hitCount();

    abstract long missCount();

    abstract long putAddCount();

    abstract long putReplaceCount();

    abstract long removeCount();

    abstract void resetStatistics();

    abstract long rehashes();

    abstract float loadFactor();

    abstract int hashTableSize();

    abstract void updateBucketHistogram(EstimatedHistogram var1);

    long numberOfChunks() {
        return -1L;
    }

    long numberOfSlots() {
        return -1L;
    }

    long freeListSize() {
        return -1L;
    }
}

