/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.oath.halodb.InMemoryIndexMetaData;
import com.oath.halodb.Utils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.CRC32;

public class Record {
    private final byte[] key;
    private final byte[] value;
    private InMemoryIndexMetaData recordMetaData;
    private Header header;

    public Record(byte[] key, byte[] value) {
        this.key = key;
        this.value = value;
        this.header = new Header(0L, 0, (byte)key.length, value.length, -1L);
    }

    ByteBuffer[] serialize() {
        ByteBuffer headerBuf = this.serializeHeaderAndComputeChecksum();
        return new ByteBuffer[]{headerBuf, ByteBuffer.wrap(this.key), ByteBuffer.wrap(this.value)};
    }

    static Record deserialize(ByteBuffer buffer, short keySize, int valueSize) {
        buffer.flip();
        byte[] key = new byte[keySize];
        byte[] value = new byte[valueSize];
        buffer.get(key);
        buffer.get(value);
        return new Record(key, value);
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    InMemoryIndexMetaData getRecordMetaData() {
        return this.recordMetaData;
    }

    void setRecordMetaData(InMemoryIndexMetaData recordMetaData) {
        this.recordMetaData = recordMetaData;
    }

    int getRecordSize() {
        return this.header.getRecordSize();
    }

    void setSequenceNumber(long sequenceNumber) {
        this.header.sequenceNumber = sequenceNumber;
    }

    long getSequenceNumber() {
        return this.header.getSequenceNumber();
    }

    void setVersion(int version) {
        if (version < 0 || version > 255) {
            throw new IllegalArgumentException("Got version " + version + ". Record version must be in range [0,255]");
        }
        this.header.version = version;
    }

    int getVersion() {
        return this.header.version;
    }

    Header getHeader() {
        return this.header;
    }

    void setHeader(Header header) {
        this.header = header;
    }

    private ByteBuffer serializeHeaderAndComputeChecksum() {
        ByteBuffer headerBuf = this.header.serialize();
        long checkSum = this.computeCheckSum(headerBuf.array());
        headerBuf.putInt(0, Utils.toSignedIntFromLong(checkSum));
        return headerBuf;
    }

    boolean verifyChecksum() {
        ByteBuffer headerBuf = this.header.serialize();
        long checkSum = this.computeCheckSum(headerBuf.array());
        return checkSum == this.header.getCheckSum();
    }

    private long computeCheckSum(byte[] header) {
        CRC32 crc32 = new CRC32();
        crc32.update(header, 4, 14);
        crc32.update(this.key);
        crc32.update(this.value);
        return crc32.getValue();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record record = (Record)obj;
        return Arrays.equals(this.getKey(), record.getKey()) && Arrays.equals(this.getValue(), record.getValue());
    }

    static class Header {
        static final int CHECKSUM_OFFSET = 0;
        static final int VERSION_OFFSET = 4;
        static final int KEY_SIZE_OFFSET = 5;
        static final int VALUE_SIZE_OFFSET = 6;
        static final int SEQUENCE_NUMBER_OFFSET = 10;
        static final int HEADER_SIZE = 18;
        static final int CHECKSUM_SIZE = 4;
        private long checkSum;
        private int version;
        private byte keySize;
        private int valueSize;
        private long sequenceNumber;
        private int recordSize;

        Header(long checkSum, int version, byte keySize, int valueSize, long sequenceNumber) {
            this.checkSum = checkSum;
            this.version = version;
            this.keySize = keySize;
            this.valueSize = valueSize;
            this.sequenceNumber = sequenceNumber;
            this.recordSize = keySize + valueSize + 18;
        }

        static Header deserialize(ByteBuffer buffer) {
            long checkSum = Utils.toUnsignedIntFromInt(buffer.getInt(0));
            int version = Utils.toUnsignedByte(buffer.get(4));
            byte keySize = buffer.get(5);
            int valueSize = buffer.getInt(6);
            long sequenceNumber = buffer.getLong(10);
            return new Header(checkSum, version, keySize, valueSize, sequenceNumber);
        }

        ByteBuffer serialize() {
            byte[] header = new byte[18];
            ByteBuffer headerBuffer = ByteBuffer.wrap(header);
            headerBuffer.put(4, (byte)this.version);
            headerBuffer.put(5, this.keySize);
            headerBuffer.putInt(6, this.valueSize);
            headerBuffer.putLong(10, this.sequenceNumber);
            return headerBuffer;
        }

        static boolean verifyHeader(Header header) {
            return header.version >= 0 && header.version < 256 && header.keySize > 0 && header.valueSize > 0 && header.recordSize > 0 && header.sequenceNumber > 0L;
        }

        byte getKeySize() {
            return this.keySize;
        }

        int getValueSize() {
            return this.valueSize;
        }

        int getRecordSize() {
            return this.recordSize;
        }

        long getSequenceNumber() {
            return this.sequenceNumber;
        }

        long getCheckSum() {
            return this.checkSum;
        }

        int getVersion() {
            return this.version;
        }
    }
}

