/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.google.common.base.Objects;
import com.oath.halodb.SegmentStats;

final class OffHeapHashTableStats {
    private final long hitCount;
    private final long missCount;
    private final long size;
    private final long rehashCount;
    private final long putAddCount;
    private final long putReplaceCount;
    private final long putFailCount;
    private final long removeCount;
    private final SegmentStats[] segmentStats;

    public OffHeapHashTableStats(long hitCount, long missCount, long size, long rehashCount, long putAddCount, long putReplaceCount, long putFailCount, long removeCount, SegmentStats[] segmentStats) {
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.size = size;
        this.rehashCount = rehashCount;
        this.putAddCount = putAddCount;
        this.putReplaceCount = putReplaceCount;
        this.putFailCount = putFailCount;
        this.removeCount = removeCount;
        this.segmentStats = segmentStats;
    }

    public long getRehashCount() {
        return this.rehashCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public long getSize() {
        return this.size;
    }

    public long getPutAddCount() {
        return this.putAddCount;
    }

    public long getPutReplaceCount() {
        return this.putReplaceCount;
    }

    public long getPutFailCount() {
        return this.putFailCount;
    }

    public long getRemoveCount() {
        return this.removeCount;
    }

    public SegmentStats[] getSegmentStats() {
        return this.segmentStats;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("hitCount", this.hitCount).add("missCount", this.missCount).add("size", this.size).add("rehashCount", this.rehashCount).add("put(add/replace/fail)", (Object)(Long.toString(this.putAddCount) + '/' + this.putReplaceCount + '/' + this.putFailCount)).add("removeCount", this.removeCount).toString();
    }

    private static long maxOf(long[] arr) {
        long r = 0L;
        for (long l : arr) {
            if (l <= r) continue;
            r = l;
        }
        return r;
    }

    private static long minOf(long[] arr) {
        long r = Long.MAX_VALUE;
        for (long l : arr) {
            if (l >= r) continue;
            r = l;
        }
        return r;
    }

    private static double avgOf(long[] arr) {
        double r = 0.0;
        for (long l : arr) {
            r += (double)l;
        }
        return r / (double)arr.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffHeapHashTableStats that = (OffHeapHashTableStats)o;
        if (this.hitCount != that.hitCount) {
            return false;
        }
        if (this.missCount != that.missCount) {
            return false;
        }
        if (this.putAddCount != that.putAddCount) {
            return false;
        }
        if (this.putFailCount != that.putFailCount) {
            return false;
        }
        if (this.putReplaceCount != that.putReplaceCount) {
            return false;
        }
        if (this.removeCount != that.removeCount) {
            return false;
        }
        return this.size == that.size;
    }

    public int hashCode() {
        int result = (int)(this.hitCount ^ this.hitCount >>> 32);
        result = 31 * result + (int)(this.missCount ^ this.missCount >>> 32);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.putAddCount ^ this.putAddCount >>> 32);
        result = 31 * result + (int)(this.putReplaceCount ^ this.putReplaceCount >>> 32);
        result = 31 * result + (int)(this.putFailCount ^ this.putFailCount >>> 32);
        result = 31 * result + (int)(this.removeCount ^ this.removeCount >>> 32);
        return result;
    }
}

