/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.oath.halodb.HashAlgorithm;
import com.oath.halodb.HashTableValueSerializer;
import com.oath.halodb.Hasher;
import com.oath.halodb.OffHeapHashTable;
import com.oath.halodb.OffHeapHashTableImpl;

class OffHeapHashTableBuilder<V> {
    private int segmentCount;
    private int hashTableSize = 8192;
    private int memoryPoolChunkSize = 0x200000;
    private HashTableValueSerializer<V> valueSerializer;
    private float loadFactor = 0.75f;
    private int fixedKeySize = -1;
    private int fixedValueSize = -1;
    private HashAlgorithm hashAlgorighm = HashAlgorithm.MURMUR3;
    private Hasher hasher;
    private boolean unlocked;
    private boolean useMemoryPool = false;
    static final String SYSTEM_PROPERTY_PREFIX = "org.caffinitas.ohc.";

    private OffHeapHashTableBuilder() {
        int cpus = Runtime.getRuntime().availableProcessors();
        this.segmentCount = OffHeapHashTableBuilder.roundUpToPowerOf2(cpus * 2, 0x40000000);
    }

    static int roundUpToPowerOf2(int number, int max) {
        return number >= max ? max : (number > 1 ? Integer.highestOneBit(number - 1 << 1) : 1);
    }

    static <V> OffHeapHashTableBuilder<V> newBuilder() {
        return new OffHeapHashTableBuilder<V>();
    }

    public OffHeapHashTable<V> build() {
        if (this.fixedValueSize == -1) {
            throw new IllegalArgumentException("Need to set fixedValueSize");
        }
        if (this.useMemoryPool && this.fixedKeySize == -1) {
            throw new IllegalArgumentException("Need to set fixedKeySize when using memory pool");
        }
        if (this.valueSerializer == null) {
            throw new IllegalArgumentException("Value serializer must be set.");
        }
        return new OffHeapHashTableImpl(this);
    }

    public int getHashTableSize() {
        return this.hashTableSize;
    }

    public OffHeapHashTableBuilder<V> hashTableSize(int hashTableSize) {
        if (hashTableSize < -1) {
            throw new IllegalArgumentException("hashTableSize:" + hashTableSize);
        }
        this.hashTableSize = hashTableSize;
        return this;
    }

    public int getMemoryPoolChunkSize() {
        return this.memoryPoolChunkSize;
    }

    public OffHeapHashTableBuilder<V> memoryPoolChunkSize(int chunkSize) {
        if (chunkSize < -1) {
            throw new IllegalArgumentException("memoryPoolChunkSize:" + chunkSize);
        }
        this.memoryPoolChunkSize = chunkSize;
        return this;
    }

    public HashTableValueSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public OffHeapHashTableBuilder<V> valueSerializer(HashTableValueSerializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
        return this;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    public OffHeapHashTableBuilder<V> segmentCount(int segmentCount) {
        if (segmentCount < -1) {
            throw new IllegalArgumentException("segmentCount:" + segmentCount);
        }
        this.segmentCount = segmentCount;
        return this;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public OffHeapHashTableBuilder<V> loadFactor(float loadFactor) {
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor:" + loadFactor);
        }
        this.loadFactor = loadFactor;
        return this;
    }

    public int getFixedKeySize() {
        return this.fixedKeySize;
    }

    public OffHeapHashTableBuilder<V> fixedKeySize(int fixedKeySize) {
        if (fixedKeySize <= 0) {
            throw new IllegalArgumentException("fixedValueSize:" + fixedKeySize);
        }
        this.fixedKeySize = fixedKeySize;
        return this;
    }

    public int getFixedValueSize() {
        return this.fixedValueSize;
    }

    public OffHeapHashTableBuilder<V> fixedValueSize(int fixedValueSize) {
        if (fixedValueSize <= 0) {
            throw new IllegalArgumentException("fixedValueSize:" + fixedValueSize);
        }
        this.fixedValueSize = fixedValueSize;
        return this;
    }

    public HashAlgorithm getHashAlgorighm() {
        return this.hashAlgorighm;
    }

    public Hasher getHasher() {
        return this.hasher;
    }

    public OffHeapHashTableBuilder<V> hashMode(HashAlgorithm hashMode) {
        if (hashMode == null) {
            throw new NullPointerException("hashMode");
        }
        this.hashAlgorighm = hashMode;
        this.hasher = Hasher.create(hashMode);
        return this;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public OffHeapHashTableBuilder<V> unlocked(boolean unlocked) {
        this.unlocked = unlocked;
        return this;
    }

    public boolean isUseMemoryPool() {
        return this.useMemoryPool;
    }

    public OffHeapHashTableBuilder<V> useMemoryPool(boolean useMemoryPool) {
        this.useMemoryPool = useMemoryPool;
        return this;
    }
}

