/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.oath.halodb.Uns;

final class NonMemoryPoolHashEntries {
    static final long ENTRY_OFF_NEXT = 0L;
    static final long ENTRY_OFF_KEY_LENGTH = 8L;
    static final long ENTRY_OFF_DATA = 9L;

    NonMemoryPoolHashEntries() {
    }

    static void init(int keyLen, long hashEntryAdr) {
        NonMemoryPoolHashEntries.setNext(hashEntryAdr, 0L);
        Uns.putByte(hashEntryAdr, 8L, (byte)keyLen);
    }

    static long getNext(long hashEntryAdr) {
        return hashEntryAdr != 0L ? Uns.getLong(hashEntryAdr, 0L) : 0L;
    }

    static void setNext(long hashEntryAdr, long nextAdr) {
        if (hashEntryAdr == nextAdr) {
            throw new IllegalArgumentException();
        }
        if (hashEntryAdr != 0L) {
            Uns.putLong(hashEntryAdr, 0L, nextAdr);
        }
    }

    static int getKeyLen(long hashEntryAdr) {
        return Uns.getByte(hashEntryAdr, 8L);
    }
}

