/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.oath.halodb.Hasher;
import com.oath.halodb.MemoryPoolAddress;
import com.oath.halodb.Uns;
import java.nio.ByteBuffer;

class MemoryPoolChunk {
    private final long address;
    private final int chunkSize;
    private final int fixedKeyLength;
    private final int fixedValueLength;
    private final int fixedSlotSize;
    private int writeOffset = 0;

    private MemoryPoolChunk(long address, int chunkSize, int fixedKeyLength, int fixedValueLength) {
        this.address = address;
        this.chunkSize = chunkSize;
        this.fixedKeyLength = fixedKeyLength;
        this.fixedValueLength = fixedValueLength;
        this.fixedSlotSize = 6 + fixedKeyLength + fixedValueLength;
    }

    static MemoryPoolChunk create(int chunkSize, int fixedKeyLength, int fixedValueLength) {
        int fixedSlotSize = 6 + fixedKeyLength + fixedValueLength;
        if (fixedSlotSize > chunkSize) {
            throw new IllegalArgumentException("fixedSlotSize " + fixedSlotSize + " must be smaller than chunkSize " + chunkSize);
        }
        long address = Uns.allocate(chunkSize, true);
        return new MemoryPoolChunk(address, chunkSize, fixedKeyLength, fixedValueLength);
    }

    void destroy() {
        Uns.free(this.address);
    }

    MemoryPoolAddress getNextAddress(int slotOffset) {
        byte chunkIndex = Uns.getByte(this.address, slotOffset + 0);
        int chunkOffset = Uns.getInt(this.address, slotOffset + 1);
        return new MemoryPoolAddress(chunkIndex, chunkOffset);
    }

    void setNextAddress(int slotOffset, MemoryPoolAddress next) {
        Uns.putByte(this.address, slotOffset + 0, next.chunkIndex);
        Uns.putInt(this.address, slotOffset + 1, next.chunkOffset);
    }

    void fillNextSlot(byte[] key, byte[] value, MemoryPoolAddress nextAddress) {
        this.fillSlot(this.writeOffset, key, value, nextAddress);
        this.writeOffset += this.fixedSlotSize;
    }

    void fillSlot(int slotOffset, byte[] key, byte[] value, MemoryPoolAddress nextAddress) {
        if (key.length > this.fixedKeyLength || value.length != this.fixedValueLength) {
            throw new IllegalArgumentException(String.format("Invalid request. Key length %d. fixed key length %d. Value length %d", key.length, this.fixedKeyLength, value.length));
        }
        if (this.chunkSize - slotOffset < this.fixedSlotSize) {
            throw new IllegalArgumentException(String.format("Invalid offset %d. Chunk size %d. fixed slot size %d", slotOffset, this.chunkSize, this.fixedSlotSize));
        }
        this.setNextAddress(slotOffset, nextAddress);
        Uns.putByte(this.address, slotOffset + 5, (byte)key.length);
        Uns.copyMemory(key, 0, this.address, (long)(slotOffset + 6), (long)key.length);
        this.setValue(value, slotOffset);
    }

    void setValue(byte[] value, int slotOffset) {
        if (value.length != this.fixedValueLength) {
            throw new IllegalArgumentException(String.format("Invalid value length. fixedValueLength %d, value length %d", this.fixedValueLength, value.length));
        }
        Uns.copyMemory(value, 0, this.address, (long)(slotOffset + 6 + this.fixedKeyLength), (long)value.length);
    }

    int getWriteOffset() {
        return this.writeOffset;
    }

    int remaining() {
        return this.chunkSize - this.writeOffset;
    }

    ByteBuffer readOnlyValueByteBuffer(int offset) {
        return Uns.directBufferFor(this.address, offset + 6 + this.fixedKeyLength, this.fixedValueLength, true);
    }

    ByteBuffer readOnlyKeyByteBuffer(int offset) {
        return Uns.directBufferFor(this.address, offset + 6, this.getKeyLength(offset), true);
    }

    long computeHash(int slotOffset, Hasher hasher) {
        return hasher.hash(this.address, slotOffset + 6, this.getKeyLength(slotOffset));
    }

    boolean compareKey(int slotOffset, byte[] key) {
        if (key.length > this.fixedKeyLength || slotOffset + this.fixedSlotSize > this.chunkSize) {
            throw new IllegalArgumentException("Invalid request. slotOffset - " + slotOffset + " key.length - " + key.length);
        }
        return this.getKeyLength(slotOffset) == key.length && this.compare(slotOffset + 6, key);
    }

    boolean compareValue(int slotOffset, byte[] value) {
        if (value.length != this.fixedValueLength || slotOffset + this.fixedSlotSize > this.chunkSize) {
            throw new IllegalArgumentException("Invalid request. slotOffset - " + slotOffset + " value.length - " + value.length);
        }
        return this.compare(slotOffset + 6 + this.fixedKeyLength, value);
    }

    private boolean compare(int offset, byte[] array) {
        int p = 0;
        int length = array.length;
        while (length - p >= 8) {
            if (Uns.getLong(this.address, offset + p) != Uns.getLongFromByteArray(array, p)) {
                return false;
            }
            p += 8;
        }
        while (length - p >= 4) {
            if (Uns.getInt(this.address, offset + p) != Uns.getIntFromByteArray(array, p)) {
                return false;
            }
            p += 4;
        }
        while (length - p >= 2) {
            if (Uns.getShort(this.address, offset + p) != Uns.getShortFromByteArray(array, p)) {
                return false;
            }
            p += 2;
        }
        while (length - p >= 1) {
            if (Uns.getByte(this.address, offset + p) != array[p]) {
                return false;
            }
            ++p;
        }
        return true;
    }

    private byte getKeyLength(int slotOffset) {
        return Uns.getByte(this.address, slotOffset + 5);
    }
}

