/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.oath.halodb.Hasher;
import com.oath.halodb.NonMemoryPoolHashEntries;
import com.oath.halodb.Uns;
import java.util.Arrays;

final class KeyBuffer {
    final byte[] buffer;
    private long hash;

    KeyBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    long hash() {
        return this.hash;
    }

    KeyBuffer finish(Hasher hasher) {
        this.hash = hasher.hash(this.buffer);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyBuffer keyBuffer = (KeyBuffer)o;
        return this.buffer.length == keyBuffer.buffer.length && Arrays.equals(keyBuffer.buffer, this.buffer);
    }

    public int size() {
        return this.buffer.length;
    }

    public int hashCode() {
        return (int)this.hash;
    }

    private static String pad(int val) {
        String str = Integer.toHexString(val & 0xFF);
        while (str.length() == 1) {
            str = '0' + str;
        }
        return str;
    }

    public String toString() {
        byte[] b = this.buffer;
        StringBuilder sb = new StringBuilder(b.length * 3);
        for (int ii = 0; ii < b.length; ++ii) {
            if (ii % 8 == 0 && ii != 0) {
                sb.append('\n');
            }
            sb.append(KeyBuffer.pad(b[ii]));
            sb.append(' ');
        }
        return sb.toString();
    }

    boolean sameKey(long hashEntryAdr) {
        long serKeyLen = NonMemoryPoolHashEntries.getKeyLen(hashEntryAdr);
        return serKeyLen == (long)this.buffer.length && this.compareKey(hashEntryAdr);
    }

    private boolean compareKey(long hashEntryAdr) {
        int blkOff = 9;
        int p = 0;
        int endIdx = this.buffer.length;
        while (endIdx - p >= 8) {
            if (Uns.getLong(hashEntryAdr, blkOff + p) != Uns.getLongFromByteArray(this.buffer, p)) {
                return false;
            }
            p += 8;
        }
        while (endIdx - p >= 4) {
            if (Uns.getInt(hashEntryAdr, blkOff + p) != Uns.getIntFromByteArray(this.buffer, p)) {
                return false;
            }
            p += 4;
        }
        while (endIdx - p >= 2) {
            if (Uns.getShort(hashEntryAdr, blkOff + p) != Uns.getShortFromByteArray(this.buffer, p)) {
                return false;
            }
            p += 2;
        }
        while (endIdx - p >= 1) {
            if (Uns.getByte(hashEntryAdr, blkOff + p) != this.buffer[p]) {
                return false;
            }
            ++p;
        }
        return true;
    }
}

