/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.oath.halodb.Utils;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;

class IndexFileEntry {
    static final int INDEX_FILE_HEADER_SIZE = 22;
    static final int CHECKSUM_SIZE = 4;
    static final int CHECKSUM_OFFSET = 0;
    static final int VERSION_OFFSET = 4;
    static final int KEY_SIZE_OFFSET = 5;
    static final int RECORD_SIZE_OFFSET = 6;
    static final int RECORD_OFFSET = 10;
    static final int SEQUENCE_NUMBER_OFFSET = 14;
    private final byte[] key;
    private final int recordSize;
    private final int recordOffset;
    private final byte keySize;
    private final int version;
    private final long sequenceNumber;
    private final long checkSum;

    IndexFileEntry(byte[] key, int recordSize, int recordOffset, long sequenceNumber, int version, long checkSum) {
        this.key = key;
        this.recordSize = recordSize;
        this.recordOffset = recordOffset;
        this.sequenceNumber = sequenceNumber;
        this.version = version;
        this.checkSum = checkSum;
        this.keySize = (byte)key.length;
    }

    ByteBuffer[] serialize() {
        byte[] header = new byte[22];
        ByteBuffer h = ByteBuffer.wrap(header);
        h.put(4, (byte)this.version);
        h.put(5, this.keySize);
        h.putInt(6, this.recordSize);
        h.putInt(10, this.recordOffset);
        h.putLong(14, this.sequenceNumber);
        long crc32 = this.computeCheckSum(h.array());
        h.putInt(0, Utils.toSignedIntFromLong(crc32));
        return new ByteBuffer[]{h, ByteBuffer.wrap(this.key)};
    }

    static IndexFileEntry deserialize(ByteBuffer buffer) {
        long crc32 = Utils.toUnsignedIntFromInt(buffer.getInt());
        int version = Utils.toUnsignedByte(buffer.get());
        byte keySize = buffer.get();
        int recordSize = buffer.getInt();
        int offset = buffer.getInt();
        long sequenceNumber = buffer.getLong();
        byte[] key = new byte[keySize];
        buffer.get(key);
        return new IndexFileEntry(key, recordSize, offset, sequenceNumber, version, crc32);
    }

    static IndexFileEntry deserializeIfNotCorrupted(ByteBuffer buffer) {
        if (buffer.remaining() < 22) {
            return null;
        }
        long crc32 = Utils.toUnsignedIntFromInt(buffer.getInt());
        int version = Utils.toUnsignedByte(buffer.get());
        byte keySize = buffer.get();
        int recordSize = buffer.getInt();
        int offset = buffer.getInt();
        long sequenceNumber = buffer.getLong();
        if (sequenceNumber < 0L || keySize <= 0 || version < 0 || version > 255 || recordSize <= 0 || offset < 0 || buffer.remaining() < keySize) {
            return null;
        }
        byte[] key = new byte[keySize];
        buffer.get(key);
        IndexFileEntry entry = new IndexFileEntry(key, recordSize, offset, sequenceNumber, version, crc32);
        if (entry.computeCheckSum() != entry.checkSum) {
            return null;
        }
        return entry;
    }

    private long computeCheckSum(byte[] header) {
        CRC32 crc32 = new CRC32();
        crc32.update(header, 4, 18);
        crc32.update(this.key);
        return crc32.getValue();
    }

    long computeCheckSum() {
        ByteBuffer header = ByteBuffer.allocate(22);
        header.put(4, (byte)this.version);
        header.put(5, this.keySize);
        header.putInt(6, this.recordSize);
        header.putInt(10, this.recordOffset);
        header.putLong(14, this.sequenceNumber);
        return this.computeCheckSum(header.array());
    }

    byte[] getKey() {
        return this.key;
    }

    int getRecordSize() {
        return this.recordSize;
    }

    int getRecordOffset() {
        return this.recordOffset;
    }

    long getSequenceNumber() {
        return this.sequenceNumber;
    }

    int getVersion() {
        return this.version;
    }

    long getCheckSum() {
        return this.checkSum;
    }
}

