/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import java.nio.ByteBuffer;

class InMemoryIndexMetaData {
    private final int fileId;
    private final int valueOffset;
    private final int valueSize;
    private final long sequenceNumber;
    static final int SERIALIZED_SIZE = 20;

    InMemoryIndexMetaData(int fileId, int valueOffset, int valueSize, long sequenceNumber) {
        this.fileId = fileId;
        this.valueOffset = valueOffset;
        this.valueSize = valueSize;
        this.sequenceNumber = sequenceNumber;
    }

    void serialize(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.getFileId());
        byteBuffer.putInt(this.getValueOffset());
        byteBuffer.putInt(this.getValueSize());
        byteBuffer.putLong(this.getSequenceNumber());
        byteBuffer.flip();
    }

    static InMemoryIndexMetaData deserialize(ByteBuffer byteBuffer) {
        int fileId = byteBuffer.getInt();
        int offset = byteBuffer.getInt();
        int size = byteBuffer.getInt();
        long sequenceNumber = byteBuffer.getLong();
        return new InMemoryIndexMetaData(fileId, offset, size, sequenceNumber);
    }

    int getFileId() {
        return this.fileId;
    }

    int getValueOffset() {
        return this.valueOffset;
    }

    int getValueSize() {
        return this.valueSize;
    }

    long getSequenceNumber() {
        return this.sequenceNumber;
    }
}

