/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.google.common.primitives.Ints;
import com.oath.halodb.InMemoryIndexMetaData;
import com.oath.halodb.InMemoryIndexMetaDataSerializer;
import com.oath.halodb.OffHeapHashTable;
import com.oath.halodb.OffHeapHashTableBuilder;
import com.oath.halodb.OffHeapHashTableStats;
import com.oath.halodb.Utils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InMemoryIndex {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryIndex.class);
    private final OffHeapHashTable<InMemoryIndexMetaData> offHeapHashTable;
    private final int noOfSegments = Ints.checkedCast((long)Utils.roundUpToPowerOf2(Runtime.getRuntime().availableProcessors() * 2));
    private final int maxSizeOfEachSegment;

    InMemoryIndex(int numberOfKeys, boolean useMemoryPool, int fixedKeySize, int memoryPoolChunkSize) {
        this.maxSizeOfEachSegment = Ints.checkedCast((long)Utils.roundUpToPowerOf2(numberOfKeys / this.noOfSegments));
        long start = System.currentTimeMillis();
        OffHeapHashTableBuilder<InMemoryIndexMetaData> builder = OffHeapHashTableBuilder.newBuilder().valueSerializer(new InMemoryIndexMetaDataSerializer()).segmentCount(this.noOfSegments).hashTableSize(this.maxSizeOfEachSegment).fixedValueSize(20).loadFactor(1.0f);
        if (useMemoryPool) {
            builder.useMemoryPool(true).fixedKeySize(fixedKeySize).memoryPoolChunkSize(memoryPoolChunkSize);
        }
        this.offHeapHashTable = builder.build();
        logger.debug("Allocated memory for the index in {}", (Object)(System.currentTimeMillis() - start));
    }

    boolean put(byte[] key, InMemoryIndexMetaData metaData) {
        return this.offHeapHashTable.put(key, metaData);
    }

    boolean putIfAbsent(byte[] key, InMemoryIndexMetaData metaData) {
        return this.offHeapHashTable.putIfAbsent(key, metaData);
    }

    boolean remove(byte[] key) {
        return this.offHeapHashTable.remove(key);
    }

    boolean replace(byte[] key, InMemoryIndexMetaData oldValue, InMemoryIndexMetaData newValue) {
        return this.offHeapHashTable.addOrReplace(key, oldValue, newValue);
    }

    InMemoryIndexMetaData get(byte[] key) {
        return this.offHeapHashTable.get(key);
    }

    boolean containsKey(byte[] key) {
        return this.offHeapHashTable.containsKey(key);
    }

    void close() {
        try {
            this.offHeapHashTable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    long size() {
        return this.offHeapHashTable.size();
    }

    public OffHeapHashTableStats stats() {
        return this.offHeapHashTable.stats();
    }

    void resetStats() {
        this.offHeapHashTable.resetStatistics();
    }

    int getNoOfSegments() {
        return this.noOfSegments;
    }

    int getMaxSizeOfEachSegment() {
        return this.maxSizeOfEachSegment;
    }
}

