/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.google.common.base.MoreObjects;
import com.oath.halodb.HaloDBOptions;
import com.oath.halodb.SegmentStats;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class HaloDBStats {
    private final long statsResetTime;
    private final long size;
    private final int numberOfFilesPendingCompaction;
    private final Map<Integer, Double> staleDataPercentPerFile;
    private final long rehashCount;
    private final long numberOfSegments;
    private final long maxSizePerSegment;
    private final SegmentStats[] segmentStats;
    private final long numberOfTombstonesFoundDuringOpen;
    private final long numberOfTombstonesCleanedUpDuringOpen;
    private final int numberOfDataFiles;
    private final int numberOfTombstoneFiles;
    private final long numberOfRecordsCopied;
    private final long numberOfRecordsReplaced;
    private final long numberOfRecordsScanned;
    private final long sizeOfRecordsCopied;
    private final long sizeOfFilesDeleted;
    private final long sizeReclaimed;
    private final long compactionRateInInternal;
    private final long compactionRateSinceBeginning;
    private final boolean isCompactionRunning;
    private final HaloDBOptions options;
    private static final String gbRateUnit = " GB/second";
    private static final String mbRateUnit = " MB/second";
    private static final String kbRateUnit = " KB/second";
    private static final long GB = 0x40000000L;
    private static final long MB = 0x100000L;
    private static final long KB = 1024L;

    public HaloDBStats(long statsResetTime, long size, boolean isCompactionRunning, int numberOfFilesPendingCompaction, Map<Integer, Double> staleDataPercentPerFile, long rehashCount, long numberOfSegments, long maxSizePerSegment, SegmentStats[] segmentStats, int numberOfDataFiles, int numberOfTombstoneFiles, long numberOfTombstonesFoundDuringOpen, long numberOfTombstonesCleanedUpDuringOpen, long numberOfRecordsCopied, long numberOfRecordsReplaced, long numberOfRecordsScanned, long sizeOfRecordsCopied, long sizeOfFilesDeleted, long sizeReclaimed, long compactionRateSinceBeginning, HaloDBOptions options) {
        this.statsResetTime = statsResetTime;
        this.size = size;
        this.numberOfFilesPendingCompaction = numberOfFilesPendingCompaction;
        this.staleDataPercentPerFile = staleDataPercentPerFile;
        this.rehashCount = rehashCount;
        this.numberOfSegments = numberOfSegments;
        this.maxSizePerSegment = maxSizePerSegment;
        this.segmentStats = segmentStats;
        this.numberOfDataFiles = numberOfDataFiles;
        this.numberOfTombstoneFiles = numberOfTombstoneFiles;
        this.numberOfTombstonesFoundDuringOpen = numberOfTombstonesFoundDuringOpen;
        this.numberOfTombstonesCleanedUpDuringOpen = numberOfTombstonesCleanedUpDuringOpen;
        this.numberOfRecordsCopied = numberOfRecordsCopied;
        this.numberOfRecordsReplaced = numberOfRecordsReplaced;
        this.numberOfRecordsScanned = numberOfRecordsScanned;
        this.sizeOfRecordsCopied = sizeOfRecordsCopied;
        this.sizeOfFilesDeleted = sizeOfFilesDeleted;
        this.sizeReclaimed = sizeReclaimed;
        this.compactionRateSinceBeginning = compactionRateSinceBeginning;
        this.isCompactionRunning = isCompactionRunning;
        long intervalTimeInSeconds = (System.currentTimeMillis() - statsResetTime) / 1000L;
        this.compactionRateInInternal = intervalTimeInSeconds > 0L ? sizeOfRecordsCopied / intervalTimeInSeconds : 0L;
        this.options = options;
    }

    public long getSize() {
        return this.size;
    }

    public int getNumberOfFilesPendingCompaction() {
        return this.numberOfFilesPendingCompaction;
    }

    public Map<Integer, Double> getStaleDataPercentPerFile() {
        return this.staleDataPercentPerFile;
    }

    public long getRehashCount() {
        return this.rehashCount;
    }

    public long getNumberOfSegments() {
        return this.numberOfSegments;
    }

    public long getMaxSizePerSegment() {
        return this.maxSizePerSegment;
    }

    public long getNumberOfRecordsCopied() {
        return this.numberOfRecordsCopied;
    }

    public long getNumberOfRecordsReplaced() {
        return this.numberOfRecordsReplaced;
    }

    public long getNumberOfRecordsScanned() {
        return this.numberOfRecordsScanned;
    }

    public long getSizeOfRecordsCopied() {
        return this.sizeOfRecordsCopied;
    }

    public long getSizeOfFilesDeleted() {
        return this.sizeOfFilesDeleted;
    }

    public long getSizeReclaimed() {
        return this.sizeReclaimed;
    }

    public HaloDBOptions getOptions() {
        return this.options;
    }

    public int getNumberOfDataFiles() {
        return this.numberOfDataFiles;
    }

    public int getNumberOfTombstoneFiles() {
        return this.numberOfTombstoneFiles;
    }

    public long getNumberOfTombstonesFoundDuringOpen() {
        return this.numberOfTombstonesFoundDuringOpen;
    }

    public long getNumberOfTombstonesCleanedUpDuringOpen() {
        return this.numberOfTombstonesCleanedUpDuringOpen;
    }

    public SegmentStats[] getSegmentStats() {
        return this.segmentStats;
    }

    public long getCompactionRateInInternal() {
        return this.compactionRateInInternal;
    }

    public long getCompactionRateSinceBeginning() {
        return this.compactionRateSinceBeginning;
    }

    public boolean isCompactionRunning() {
        return this.isCompactionRunning;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("statsResetTime", this.statsResetTime).add("size", this.size).add("Options", (Object)this.options).add("isCompactionRunning", this.isCompactionRunning).add("CompactionJobRateInInterval", (Object)this.getUnit(this.compactionRateInInternal)).add("CompactionJobRateSinceBeginning", (Object)this.getUnit(this.compactionRateSinceBeginning)).add("numberOfFilesPendingCompaction", this.numberOfFilesPendingCompaction).add("numberOfRecordsCopied", this.numberOfRecordsCopied).add("numberOfRecordsReplaced", this.numberOfRecordsReplaced).add("numberOfRecordsScanned", this.numberOfRecordsScanned).add("sizeOfRecordsCopied", this.sizeOfRecordsCopied).add("sizeOfFilesDeleted", this.sizeOfFilesDeleted).add("sizeReclaimed", this.sizeReclaimed).add("rehashCount", this.rehashCount).add("maxSizePerSegment", this.maxSizePerSegment).add("numberOfDataFiles", this.numberOfDataFiles).add("numberOfTombstoneFiles", this.numberOfTombstoneFiles).add("numberOfTombstonesFoundDuringOpen", this.numberOfTombstonesFoundDuringOpen).add("numberOfTombstonesCleanedUpDuringOpen", this.numberOfTombstonesCleanedUpDuringOpen).add("segmentStats", (Object)Arrays.toString(this.segmentStats)).add("numberOfSegments", this.numberOfSegments).add("staleDataPercentPerFile", (Object)this.staleDataMapToString()).toString();
    }

    public Map<String, String> toStringMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("statsResetTime", String.valueOf(this.statsResetTime));
        map.put("size", String.valueOf(this.size));
        map.put("Options", String.valueOf(this.options));
        map.put("isCompactionRunning", String.valueOf(this.isCompactionRunning));
        map.put("CompactionJobRateInInterval", String.valueOf(this.getUnit(this.compactionRateInInternal)));
        map.put("CompactionJobRateSinceBeginning", String.valueOf(this.getUnit(this.compactionRateSinceBeginning)));
        map.put("numberOfFilesPendingCompaction", String.valueOf(this.numberOfFilesPendingCompaction));
        map.put("numberOfRecordsCopied", String.valueOf(this.numberOfRecordsCopied));
        map.put("numberOfRecordsReplaced", String.valueOf(this.numberOfRecordsReplaced));
        map.put("numberOfRecordsScanned", String.valueOf(this.numberOfRecordsScanned));
        map.put("sizeOfRecordsCopied", String.valueOf(this.sizeOfRecordsCopied));
        map.put("sizeOfFilesDeleted", String.valueOf(this.sizeOfFilesDeleted));
        map.put("sizeReclaimed", String.valueOf(this.sizeReclaimed));
        map.put("rehashCount", String.valueOf(this.rehashCount));
        map.put("maxSizePerSegment", String.valueOf(this.maxSizePerSegment));
        map.put("numberOfDataFiles", String.valueOf(this.numberOfDataFiles));
        map.put("numberOfTombstoneFiles", String.valueOf(this.numberOfTombstoneFiles));
        map.put("numberOfTombstonesFoundDuringOpen", String.valueOf(this.numberOfTombstonesFoundDuringOpen));
        map.put("numberOfTombstonesCleanedUpDuringOpen", String.valueOf(this.numberOfTombstonesCleanedUpDuringOpen));
        map.put("segmentStats", String.valueOf(Arrays.toString(this.segmentStats)));
        map.put("numberOfSegments", String.valueOf(this.numberOfSegments));
        map.put("staleDataPercentPerFile", String.valueOf(this.staleDataMapToString()));
        return map;
    }

    private String staleDataMapToString() {
        StringBuilder builder = new StringBuilder("[");
        boolean isFirst = true;
        for (Map.Entry<Integer, Double> e : this.staleDataPercentPerFile.entrySet()) {
            if (!isFirst) {
                builder.append(", ");
            }
            isFirst = false;
            builder.append("{");
            builder.append(e.getKey());
            builder.append("=");
            builder.append(String.format("%.1f", e.getValue()));
            builder.append("}");
        }
        builder.append("]");
        return builder.toString();
    }

    private String getUnit(long value) {
        long temp = value / 0x40000000L;
        if (temp >= 1L) {
            return temp + gbRateUnit;
        }
        temp = value / 0x100000L;
        if (temp >= 1L) {
            return temp + mbRateUnit;
        }
        temp = value / 1024L;
        return temp + kbRateUnit;
    }
}

