/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.google.common.base.MoreObjects;

public class HaloDBOptions
implements Cloneable {
    private double compactionThresholdPerFile = 0.75;
    private int maxFileSize = 0x100000;
    private int maxTombstoneFileSize = 0;
    private long flushDataSizeBytes = -1L;
    private boolean syncWrite = false;
    private int numberOfRecords = 1000000;
    private int compactionJobRate = 0x40000000;
    private boolean cleanUpInMemoryIndexOnClose = false;
    private boolean cleanUpTombstonesDuringOpen = false;
    private boolean useMemoryPool = false;
    private int fixedKeySize = 127;
    private int memoryPoolChunkSize = 0x1000000;
    private int buildIndexThreads = 1;
    private boolean isCompactionDisabled = false;

    public HaloDBOptions clone() {
        try {
            return (HaloDBOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("compactionThresholdPerFile", this.compactionThresholdPerFile).add("maxFileSize", this.maxFileSize).add("maxTombstoneFileSize", this.getMaxTombstoneFileSize()).add("flushDataSizeBytes", this.flushDataSizeBytes).add("syncWrite", this.syncWrite).add("numberOfRecords", this.numberOfRecords).add("compactionJobRate", this.compactionJobRate).add("cleanUpInMemoryIndexOnClose", this.cleanUpInMemoryIndexOnClose).add("cleanUpTombstonesDuringOpen", this.cleanUpTombstonesDuringOpen).add("useMemoryPool", this.useMemoryPool).add("fixedKeySize", this.fixedKeySize).add("memoryPoolChunkSize", this.memoryPoolChunkSize).add("buildIndexThreads", this.buildIndexThreads).toString();
    }

    public void setCompactionThresholdPerFile(double compactionThresholdPerFile) {
        this.compactionThresholdPerFile = compactionThresholdPerFile;
    }

    public void setMaxFileSize(int maxFileSize) {
        if (maxFileSize <= 0) {
            throw new IllegalArgumentException("maxFileSize should be > 0");
        }
        this.maxFileSize = maxFileSize;
    }

    public void setMaxTombstoneFileSize(int maxFileSize) {
        if (maxFileSize <= 0) {
            throw new IllegalArgumentException("maxFileSize should be > 0");
        }
        this.maxTombstoneFileSize = maxFileSize;
    }

    public void setFlushDataSizeBytes(long flushDataSizeBytes) {
        this.flushDataSizeBytes = flushDataSizeBytes;
    }

    public void setNumberOfRecords(int numberOfRecords) {
        this.numberOfRecords = numberOfRecords;
    }

    public void setCompactionJobRate(int compactionJobRate) {
        this.compactionJobRate = compactionJobRate;
    }

    public void setCleanUpInMemoryIndexOnClose(boolean cleanUpInMemoryIndexOnClose) {
        this.cleanUpInMemoryIndexOnClose = cleanUpInMemoryIndexOnClose;
    }

    public double getCompactionThresholdPerFile() {
        return this.compactionThresholdPerFile;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public int getMaxTombstoneFileSize() {
        return this.maxTombstoneFileSize > 0 ? this.maxTombstoneFileSize : this.maxFileSize;
    }

    public long getFlushDataSizeBytes() {
        return this.flushDataSizeBytes;
    }

    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    public int getCompactionJobRate() {
        return this.compactionJobRate;
    }

    public boolean isCleanUpInMemoryIndexOnClose() {
        return this.cleanUpInMemoryIndexOnClose;
    }

    public boolean isCleanUpTombstonesDuringOpen() {
        return this.cleanUpTombstonesDuringOpen;
    }

    public void setCleanUpTombstonesDuringOpen(boolean cleanUpTombstonesDuringOpen) {
        this.cleanUpTombstonesDuringOpen = cleanUpTombstonesDuringOpen;
    }

    public boolean isUseMemoryPool() {
        return this.useMemoryPool;
    }

    public void setUseMemoryPool(boolean useMemoryPool) {
        this.useMemoryPool = useMemoryPool;
    }

    public int getFixedKeySize() {
        return this.fixedKeySize;
    }

    public void setFixedKeySize(int fixedKeySize) {
        this.fixedKeySize = fixedKeySize;
    }

    public int getMemoryPoolChunkSize() {
        return this.memoryPoolChunkSize;
    }

    public void setMemoryPoolChunkSize(int memoryPoolChunkSize) {
        this.memoryPoolChunkSize = memoryPoolChunkSize;
    }

    public boolean isSyncWrite() {
        return this.syncWrite;
    }

    public void enableSyncWrites(boolean syncWrites) {
        this.syncWrite = syncWrites;
    }

    public int getBuildIndexThreads() {
        return this.buildIndexThreads;
    }

    public void setBuildIndexThreads(int buildIndexThreads) {
        int numOfProcessors = Runtime.getRuntime().availableProcessors();
        if (buildIndexThreads <= 0 || buildIndexThreads > numOfProcessors) {
            throw new IllegalArgumentException("buildIndexThreads should be > 0 and <= " + numOfProcessors);
        }
        this.buildIndexThreads = buildIndexThreads;
    }

    void setCompactionDisabled(boolean compactionDisabled) {
        this.isCompactionDisabled = compactionDisabled;
    }

    boolean isCompactionDisabled() {
        return this.isCompactionDisabled;
    }
}

