/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.oath.halodb.HaloDBFile;
import com.oath.halodb.HaloDBInternal;
import com.oath.halodb.HaloDBIterator;
import com.oath.halodb.InMemoryIndexMetaData;
import com.oath.halodb.IndexFileEntry;
import com.oath.halodb.RecordKey;
import com.oath.halodb.Utils;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaloDBKeyIterator
implements Iterator<RecordKey> {
    private static final Logger logger = LoggerFactory.getLogger(HaloDBIterator.class);
    private Iterator<Integer> outer;
    private Iterator<IndexFileEntry> inner;
    private HaloDBFile currentFile;
    private RecordKey next;
    private final HaloDBInternal dbInternal;

    HaloDBKeyIterator(HaloDBInternal dbInternal) {
        this.dbInternal = dbInternal;
        this.outer = dbInternal.listDataFileIds().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        try {
            if (this.inner == null && !this.moveToNextFile()) {
                return false;
            }
            do {
                if (!this.readNextRecord()) continue;
                return true;
            } while (this.moveToNextFile());
            return false;
        }
        catch (IOException e) {
            logger.error("Error in Iterator", (Throwable)e);
            return false;
        }
    }

    @Override
    public RecordKey next() {
        if (this.hasNext()) {
            RecordKey key = this.next;
            this.next = null;
            return key;
        }
        throw new NoSuchElementException();
    }

    private boolean moveToNextFile() throws IOException {
        while (this.outer.hasNext()) {
            int fileId = this.outer.next();
            this.currentFile = this.dbInternal.getHaloDBFile(fileId);
            if (this.currentFile != null) {
                try {
                    this.inner = this.currentFile.getIndexFile().newIterator();
                    return true;
                }
                catch (ClosedChannelException e) {
                    if (this.dbInternal.isClosing()) {
                        throw new RuntimeException("DB is closing");
                    }
                    logger.debug("Index file {} closed, probably by compaction thread. Skipping to next one", (Object)fileId);
                }
            }
            logger.debug("Data file {} deleted, probably by compaction thread. Skipping to next one", (Object)fileId);
        }
        return false;
    }

    private boolean readNextRecord() {
        while (this.inner.hasNext()) {
            IndexFileEntry entry = this.inner.next();
            try {
                try {
                    this.next = this.readValidRecordKey(entry);
                    if (this.next == null) continue;
                    return true;
                }
                catch (ClosedChannelException e) {
                    if (this.dbInternal.isClosing()) {
                        throw new RuntimeException("DB is closing");
                    }
                    logger.debug("Data file {} closed, probably by compaction thread. Skipping to next one", (Object)this.currentFile.getFileId());
                }
            }
            catch (IOException e) {
                logger.info("Error in iterator", (Throwable)e);
            }
            break;
        }
        return false;
    }

    private RecordKey readValidRecordKey(IndexFileEntry entry) throws IOException {
        InMemoryIndexMetaData meta = Utils.getMetaData(entry, this.currentFile.getFileId());
        RecordKey key = null;
        if (this.dbInternal.isRecordFresh(entry.getKey(), meta)) {
            key = new RecordKey(entry.getKey());
        }
        return key;
    }
}

