/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.oath.halodb.HaloDBFile;
import com.oath.halodb.HaloDBInternal;
import com.oath.halodb.InMemoryIndexMetaData;
import com.oath.halodb.IndexFileEntry;
import com.oath.halodb.Record;
import com.oath.halodb.Utils;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaloDBIterator
implements Iterator<Record> {
    private static final Logger logger = LoggerFactory.getLogger(HaloDBIterator.class);
    private Iterator<Integer> outer;
    private Iterator<IndexFileEntry> inner;
    private HaloDBFile currentFile;
    private Record next;
    private final HaloDBInternal dbInternal;

    HaloDBIterator(HaloDBInternal dbInternal) {
        this.dbInternal = dbInternal;
        this.outer = dbInternal.listDataFileIds().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        try {
            if (this.inner == null && !this.moveToNextFile()) {
                return false;
            }
            do {
                if (!this.readNextRecord()) continue;
                return true;
            } while (this.moveToNextFile());
            return false;
        }
        catch (IOException e) {
            logger.error("Error in Iterator", (Throwable)e);
            return false;
        }
    }

    @Override
    public Record next() {
        if (this.hasNext()) {
            Record record = this.next;
            this.next = null;
            return record;
        }
        throw new NoSuchElementException();
    }

    private boolean moveToNextFile() throws IOException {
        while (this.outer.hasNext()) {
            int fileId = this.outer.next();
            this.currentFile = this.dbInternal.getHaloDBFile(fileId);
            if (this.currentFile != null) {
                try {
                    this.inner = this.currentFile.getIndexFile().newIterator();
                    return true;
                }
                catch (ClosedChannelException e) {
                    if (this.dbInternal.isClosing()) {
                        throw new RuntimeException("DB is closing");
                    }
                    logger.debug("Index file {} closed, probably by compaction thread. Skipping to next one", (Object)fileId);
                }
            }
            logger.debug("Data file {} deleted, probably by compaction thread. Skipping to next one", (Object)fileId);
        }
        return false;
    }

    private boolean readNextRecord() {
        while (this.inner.hasNext()) {
            IndexFileEntry entry = this.inner.next();
            try {
                try {
                    this.next = this.readRecordFromDataFile(entry);
                    if (this.next == null) continue;
                    return true;
                }
                catch (ClosedChannelException e) {
                    if (this.dbInternal.isClosing()) {
                        throw new RuntimeException("DB is closing");
                    }
                    logger.debug("Data file {} closed, probably by compaction thread. Skipping to next one", (Object)this.currentFile.getFileId());
                }
            }
            catch (IOException e) {
                logger.info("Error in iterator", (Throwable)e);
            }
            break;
        }
        return false;
    }

    private Record readRecordFromDataFile(IndexFileEntry entry) throws IOException {
        InMemoryIndexMetaData meta = Utils.getMetaData(entry, this.currentFile.getFileId());
        Record record = null;
        if (this.dbInternal.isRecordFresh(entry.getKey(), meta)) {
            byte[] value = this.currentFile.readFromFile(Utils.getValueOffset(entry.getRecordOffset(), entry.getKey()), Utils.getValueSize(entry.getRecordSize(), entry.getKey()));
            record = new Record(entry.getKey(), value);
            record.setRecordMetaData(meta);
        }
        return record;
    }
}

