/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.google.common.annotations.VisibleForTesting;
import com.oath.halodb.HaloDBException;
import com.oath.halodb.HaloDBInternal;
import com.oath.halodb.HaloDBIterator;
import com.oath.halodb.HaloDBKeyIterator;
import com.oath.halodb.HaloDBOptions;
import com.oath.halodb.HaloDBStats;
import java.io.File;
import java.io.IOException;

public final class HaloDB {
    private HaloDBInternal dbInternal;
    private File directory;

    public static HaloDB open(File dirname, HaloDBOptions opts) throws HaloDBException {
        HaloDB db = new HaloDB();
        try {
            db.dbInternal = HaloDBInternal.open(dirname, opts);
            db.directory = dirname;
        }
        catch (IOException e) {
            throw new HaloDBException("Failed to open db " + dirname.getName(), e);
        }
        return db;
    }

    public static HaloDB open(String directory, HaloDBOptions opts) throws HaloDBException {
        return HaloDB.open(new File(directory), opts);
    }

    public byte[] get(byte[] key) throws HaloDBException {
        try {
            return this.dbInternal.get(key, 1);
        }
        catch (IOException e) {
            throw new HaloDBException("Lookup failed.", e);
        }
    }

    public boolean put(byte[] key, byte[] value) throws HaloDBException {
        try {
            return this.dbInternal.put(key, value);
        }
        catch (IOException e) {
            throw new HaloDBException("Store to db failed.", e);
        }
    }

    public void delete(byte[] key) throws HaloDBException {
        try {
            this.dbInternal.delete(key);
        }
        catch (IOException e) {
            throw new HaloDBException("Delete operation failed.", e);
        }
    }

    public void close() throws HaloDBException {
        try {
            this.dbInternal.close();
        }
        catch (IOException e) {
            throw new HaloDBException("Error while closing " + this.directory.getName(), e);
        }
    }

    public long size() {
        return this.dbInternal.size();
    }

    public HaloDBStats stats() {
        return this.dbInternal.stats();
    }

    public void resetStats() {
        this.dbInternal.resetStats();
    }

    public HaloDBIterator newIterator() throws HaloDBException {
        return new HaloDBIterator(this.dbInternal);
    }

    public HaloDBKeyIterator newKeyIterator() {
        return new HaloDBKeyIterator(this.dbInternal);
    }

    public void pauseCompaction() throws HaloDBException {
        try {
            this.dbInternal.pauseCompaction();
        }
        catch (IOException e) {
            throw new HaloDBException("Error while trying to pause compaction thread", e);
        }
    }

    public boolean snapshot() {
        return this.dbInternal.takeSnapshot();
    }

    public boolean clearSnapshot() {
        return this.dbInternal.clearSnapshot();
    }

    public File getSnapshotDirectory() {
        return this.dbInternal.getSnapshotDirectory();
    }

    public void resumeCompaction() {
        this.dbInternal.resumeCompaction();
    }

    @VisibleForTesting
    boolean isCompactionComplete() {
        return this.dbInternal.isCompactionComplete();
    }

    @VisibleForTesting
    boolean isTombstoneFilesMerging() {
        return this.dbInternal.isTombstoneFilesMerging();
    }
}

