/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.oath.halodb.Constants;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class FileUtils {
    FileUtils() {
    }

    static void createDirectoryIfNotExists(File directory) throws IOException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IOException(directory.getName() + " is not a directory.");
            }
            return;
        }
        if (!directory.mkdirs()) {
            throw new IOException("Cannot create directory " + directory.getName());
        }
    }

    static void deleteDirectory(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory(file);
                    continue;
                }
                Files.delete(file.toPath());
            }
        }
        Files.deleteIfExists(dir.toPath());
    }

    static List<Integer> listIndexFiles(File directory) {
        File[] files = directory.listFiles(file -> Constants.INDEX_FILE_PATTERN.matcher(file.getName()).matches());
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).sorted(Comparator.comparingInt(f -> FileUtils.getFileId(f, Constants.INDEX_FILE_PATTERN))).map(f -> FileUtils.getFileId(f, Constants.INDEX_FILE_PATTERN)).collect(Collectors.toList());
    }

    static File[] listTombstoneFiles(File directory) {
        File[] files = directory.listFiles(file -> Constants.TOMBSTONE_FILE_PATTERN.matcher(file.getName()).matches());
        if (files == null) {
            return new File[0];
        }
        Comparator<File> comparator = Comparator.comparingInt(f -> FileUtils.getFileId(f, Constants.TOMBSTONE_FILE_PATTERN));
        Arrays.sort(files, comparator);
        return files;
    }

    static File[] listDataFiles(File directory) {
        return directory.listFiles(file -> Constants.DATA_FILE_PATTERN.matcher(file.getName()).matches());
    }

    private static int getFileId(File file, Pattern pattern) {
        Matcher matcher = pattern.matcher(file.getName());
        if (matcher.find()) {
            return Integer.valueOf(matcher.group(1));
        }
        throw new IllegalArgumentException("Cannot extract file id for file " + file.getPath());
    }
}

