/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.oath.halodb.DBDirectory;
import com.oath.halodb.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.zip.CRC32;

class DBMetaData {
    private static final int META_DATA_SIZE = 19;
    private static final int CHECK_SUM_SIZE = 4;
    private static final int CHECK_SUM_OFFSET = 0;
    private long checkSum = 0L;
    private int version = 0;
    private boolean open = false;
    private long sequenceNumber = 0L;
    private boolean ioError = false;
    private int maxFileSize = 0;
    private final DBDirectory dbDirectory;
    static final String METADATA_FILE_NAME = "META";
    private static final Object lock = new Object();

    DBMetaData(DBDirectory dbDirectory) {
        this.dbDirectory = dbDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFromFileIfExists() throws IOException {
        Object object = lock;
        synchronized (object) {
            Path metaFile = this.dbDirectory.getPath().resolve(METADATA_FILE_NAME);
            if (Files.exists(metaFile, new LinkOption[0])) {
                try (SeekableByteChannel channel = Files.newByteChannel(metaFile, new OpenOption[0]);){
                    ByteBuffer buff = ByteBuffer.allocate(19);
                    channel.read(buff);
                    buff.flip();
                    this.checkSum = Utils.toUnsignedIntFromInt(buff.getInt());
                    this.version = Utils.toUnsignedByte(buff.get());
                    this.open = buff.get() != 0;
                    this.sequenceNumber = buff.getLong();
                    this.ioError = buff.get() != 0;
                    this.maxFileSize = buff.getInt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeToFile() throws IOException {
        Object object = lock;
        synchronized (object) {
            String tempFileName = "META.temp";
            Path tempFile = this.dbDirectory.getPath().resolve(tempFileName);
            Files.deleteIfExists(tempFile);
            try (FileChannel channel = FileChannel.open(tempFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.SYNC);){
                ByteBuffer buff = ByteBuffer.allocate(19);
                buff.position(4);
                buff.put((byte)this.version);
                buff.put((byte)(this.open ? 255 : 0));
                buff.putLong(this.sequenceNumber);
                buff.put((byte)(this.ioError ? 255 : 0));
                buff.putInt(this.maxFileSize);
                long crc32 = this.computeCheckSum(buff.array());
                buff.putInt(0, (int)crc32);
                buff.flip();
                channel.write(buff);
                Files.move(tempFile, this.dbDirectory.getPath().resolve(METADATA_FILE_NAME), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                this.dbDirectory.syncMetaData();
            }
        }
    }

    private long computeCheckSum(byte[] header) {
        CRC32 crc32 = new CRC32();
        crc32.update(header, 4, 15);
        return crc32.getValue();
    }

    boolean isValid() {
        ByteBuffer buff = ByteBuffer.allocate(19);
        buff.position(4);
        buff.put((byte)this.version);
        buff.put((byte)(this.open ? 255 : 0));
        buff.putLong(this.sequenceNumber);
        buff.put((byte)(this.ioError ? 255 : 0));
        buff.putInt(this.maxFileSize);
        return this.computeCheckSum(buff.array()) == this.checkSum;
    }

    boolean isOpen() {
        return this.open;
    }

    void setOpen(boolean open) {
        this.open = open;
    }

    long getSequenceNumber() {
        return this.sequenceNumber;
    }

    void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    boolean isIOError() {
        return this.ioError;
    }

    void setIOError(boolean ioError) {
        this.ioError = ioError;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
    }
}

