/*
 * Decompiled with CFR 0.152.
 */
package com.oath.halodb;

import com.oath.halodb.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Locale;

class DBDirectory {
    private final File dbDirectory;
    private final FileChannel directoryChannel;

    private DBDirectory(File dbDirectory, FileChannel directoryChannel) {
        this.dbDirectory = dbDirectory;
        this.directoryChannel = directoryChannel;
    }

    static DBDirectory open(File directory) throws IOException {
        FileChannel channel;
        block2: {
            FileUtils.createDirectoryIfNotExists(directory);
            channel = null;
            try {
                channel = DBDirectory.openReadOnlyChannel(directory);
            }
            catch (IOException e) {
                if (DBDirectory.isWindows()) break block2;
                throw e;
            }
        }
        return new DBDirectory(directory, channel);
    }

    void close() throws IOException {
        if (this.directoryChannel != null) {
            this.directoryChannel.close();
        }
    }

    Path getPath() {
        return this.dbDirectory.toPath();
    }

    File[] listDataFiles() {
        return FileUtils.listDataFiles(this.dbDirectory);
    }

    List<Integer> listIndexFiles() {
        return FileUtils.listIndexFiles(this.dbDirectory);
    }

    File[] listTombstoneFiles() {
        return FileUtils.listTombstoneFiles(this.dbDirectory);
    }

    void syncMetaData() throws IOException {
        if (this.directoryChannel != null) {
            this.directoryChannel.force(true);
        }
    }

    private static FileChannel openReadOnlyChannel(File dbDirectory) throws IOException {
        return FileChannel.open(dbDirectory.toPath(), StandardOpenOption.READ);
    }

    private static boolean isWindows() {
        return System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH).indexOf("win") != -1;
    }
}

