/*
 * Decompiled with CFR 0.152.
 */
package com.xycoding.richtext.typeface;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.style.ImageSpan;
import java.lang.ref.WeakReference;

public class CenteredImageSpan
extends ImageSpan {
    private WeakReference<Drawable> mDrawableRef;

    public CenteredImageSpan(Drawable drawable) {
        super(drawable);
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        Drawable drawable = this.getCachedDrawable();
        canvas.save();
        int drawableCenter = drawable.getIntrinsicHeight() / 2;
        int fontTop = paint.getFontMetricsInt().top;
        int fontBottom = paint.getFontMetricsInt().bottom;
        int transY = bottom - drawable.getBounds().bottom - ((fontBottom - fontTop) / 2 - drawableCenter);
        canvas.translate(x, (float)transY);
        drawable.draw(canvas);
        canvas.restore();
    }

    private Drawable getCachedDrawable() {
        WeakReference<Drawable> drawableRef = this.mDrawableRef;
        Drawable drawable = null;
        if (drawableRef != null) {
            drawable = (Drawable)drawableRef.get();
        }
        if (drawable == null) {
            drawable = this.getDrawable();
            this.mDrawableRef = new WeakReference<Drawable>(drawable);
        }
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        drawable.setBounds(0, 0, width > 0 ? width : 0, height > 0 ? height : 0);
        return drawable;
    }
}

