/*
 * Decompiled with CFR 0.152.
 */
package com.xycoding.richtext;

import android.text.Spanned;
import android.widget.TextView;
import com.xycoding.richtext.ImageSpanGetter;
import com.xycoding.richtext.LinkTouchMovementMethod;
import com.xycoding.richtext.TagParser;
import com.xycoding.richtext.style.BaseTagStyle;
import com.xycoding.richtext.style.BlockTagStyle;
import com.xycoding.richtext.style.ImageTagStyle;
import com.xycoding.richtext.style.LinkTagStyle;
import com.xycoding.richtext.typeface.IStyleSpan;
import com.xycoding.richtext.typeface.LinkClickSpan;

public class RichText {
    private final TagParser mTagParser;

    private RichText(TagParser parser) {
        this.mTagParser = parser;
    }

    public void with(TextView textView) {
        textView.setMovementMethod(LinkTouchMovementMethod.getInstance());
    }

    public Spanned parse(String tagString) {
        return this.mTagParser.parse("<inject/>" + tagString);
    }

    public static class Builder {
        private TagParser mParser = new TagParser();

        public Builder addBlockTypeSpan(IStyleSpan span, String ... tags) {
            this.mParser.addTypefaceStyle(new BlockTagStyle(span, tags));
            return this;
        }

        public Builder addLinkTypeSpan(LinkClickSpan span) {
            this.mParser.addTypefaceStyle(new LinkTagStyle(span));
            return this;
        }

        public Builder addTypeSpan(BaseTagStyle style) {
            this.mParser.addTypefaceStyle(style);
            return this;
        }

        public Builder addImageSpan(ImageSpanGetter getter) {
            this.mParser.addTypefaceStyle(new ImageTagStyle(getter));
            return this;
        }

        public RichText build() {
            return new RichText(this.mParser);
        }
    }
}

