/*
 * Decompiled with CFR 0.152.
 */
package com.ethanhua.skeleton;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.ColorRes;
import androidx.annotation.IntRange;
import androidx.annotation.LayoutRes;
import androidx.core.content.ContextCompat;
import com.ethanhua.skeleton.R;
import com.ethanhua.skeleton.SkeletonScreen;
import com.ethanhua.skeleton.ViewReplacer;
import io.supercharge.shimmerlayout.ShimmerLayout;

public class ViewSkeletonScreen
implements SkeletonScreen {
    private static final String TAG = ViewSkeletonScreen.class.getName();
    private final ViewReplacer mViewReplacer;
    private final View mActualView;
    private final int mSkeletonResID;
    private final int mShimmerColor;
    private final boolean mShimmer;
    private final int mShimmerDuration;
    private final int mShimmerAngle;

    private ViewSkeletonScreen(Builder builder) {
        this.mActualView = builder.mView;
        this.mSkeletonResID = builder.mSkeletonLayoutResID;
        this.mShimmer = builder.mShimmer;
        this.mShimmerDuration = builder.mShimmerDuration;
        this.mShimmerAngle = builder.mShimmerAngle;
        this.mShimmerColor = builder.mShimmerColor;
        this.mViewReplacer = new ViewReplacer(builder.mView);
    }

    private ShimmerLayout generateShimmerContainerLayout(ViewGroup parentView) {
        final ShimmerLayout shimmerLayout = (ShimmerLayout)LayoutInflater.from((Context)this.mActualView.getContext()).inflate(R.layout.layout_shimmer, parentView, false);
        shimmerLayout.setShimmerColor(this.mShimmerColor);
        shimmerLayout.setShimmerAngle(this.mShimmerAngle);
        shimmerLayout.setShimmerAnimationDuration(this.mShimmerDuration);
        View innerView = LayoutInflater.from((Context)this.mActualView.getContext()).inflate(this.mSkeletonResID, (ViewGroup)shimmerLayout, false);
        ViewGroup.LayoutParams lp = innerView.getLayoutParams();
        if (lp != null) {
            shimmerLayout.setLayoutParams(lp);
        }
        shimmerLayout.addView(innerView);
        shimmerLayout.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                shimmerLayout.startShimmerAnimation();
            }

            public void onViewDetachedFromWindow(View v) {
                shimmerLayout.stopShimmerAnimation();
            }
        });
        shimmerLayout.startShimmerAnimation();
        return shimmerLayout;
    }

    private View generateSkeletonLoadingView() {
        ViewParent viewParent = this.mActualView.getParent();
        if (viewParent == null) {
            Log.e((String)TAG, (String)"the source view have not attach to any view");
            return null;
        }
        ViewGroup parentView = (ViewGroup)viewParent;
        if (this.mShimmer) {
            return this.generateShimmerContainerLayout(parentView);
        }
        return LayoutInflater.from((Context)this.mActualView.getContext()).inflate(this.mSkeletonResID, parentView, false);
    }

    @Override
    public void show() {
        View skeletonLoadingView = this.generateSkeletonLoadingView();
        if (skeletonLoadingView != null) {
            this.mViewReplacer.replace(skeletonLoadingView);
        }
    }

    @Override
    public void hide() {
        if (this.mViewReplacer.getTargetView() instanceof ShimmerLayout) {
            ((ShimmerLayout)this.mViewReplacer.getTargetView()).stopShimmerAnimation();
        }
        this.mViewReplacer.restore();
    }

    public static class Builder {
        private final View mView;
        private int mSkeletonLayoutResID;
        private boolean mShimmer = true;
        private int mShimmerColor;
        private int mShimmerDuration = 1000;
        private int mShimmerAngle = 20;

        public Builder(View view) {
            this.mView = view;
            this.mShimmerColor = ContextCompat.getColor((Context)this.mView.getContext(), (int)R.color.shimmer_color);
        }

        public Builder load(@LayoutRes int skeletonLayoutResID) {
            this.mSkeletonLayoutResID = skeletonLayoutResID;
            return this;
        }

        public Builder color(@ColorRes int shimmerColor) {
            this.mShimmerColor = ContextCompat.getColor((Context)this.mView.getContext(), (int)shimmerColor);
            return this;
        }

        public Builder shimmer(boolean shimmer) {
            this.mShimmer = shimmer;
            return this;
        }

        public Builder duration(int shimmerDuration) {
            this.mShimmerDuration = shimmerDuration;
            return this;
        }

        public Builder angle(@IntRange(from=0L, to=30L) int shimmerAngle) {
            this.mShimmerAngle = shimmerAngle;
            return this;
        }

        public ViewSkeletonScreen show() {
            ViewSkeletonScreen skeletonScreen = new ViewSkeletonScreen(this);
            skeletonScreen.show();
            return skeletonScreen;
        }
    }
}

