/*
 * Decompiled with CFR 0.152.
 */
package com.noober.menu;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.MotionEvent;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.noober.menu.Display;
import com.noober.menu.MenuItem;
import com.noober.menu.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FloatMenu
extends PopupWindow {
    private static final String XML_MENU = "menu";
    private static final String XML_GROUP = "group";
    private static final String XML_ITEM = "item";
    private static final int ANCHORED_GRAVITY = 0x800033;
    private final int DEFAULT_MENU_WIDTH;
    private final int VERTICAL_OFFSET;
    private Context context;
    private List<MenuItem> menuItemList;
    private View view;
    private Point screenPoint;
    private int clickX;
    private int clickY;
    private int menuWidth;
    private int menuHeight;
    private LinearLayout menuLayout;
    private OnItemClickListener onItemClickListener;

    public FloatMenu(Activity activity) {
        this((Context)activity, activity.findViewById(0x1020002));
    }

    public FloatMenu(Context context, View view) {
        super(context);
        this.setOutsideTouchable(true);
        this.setFocusable(true);
        this.setBackgroundDrawable((Drawable)new BitmapDrawable());
        view.setOnTouchListener((View.OnTouchListener)new MenuTouchListener());
        this.context = context;
        this.view = view;
        this.VERTICAL_OFFSET = Display.dip2px(context, 10.0f);
        this.DEFAULT_MENU_WIDTH = Display.dip2px(context, 180.0f);
        this.screenPoint = Display.getScreenMetrics(context);
        this.menuItemList = new ArrayList<MenuItem>();
    }

    public void inflate(int menuRes) {
        this.inflate(menuRes, this.DEFAULT_MENU_WIDTH);
    }

    public void inflate(int menuRes, int itemWidth) {
        try (XmlResourceParser parser = null;){
            parser = this.context.getResources().getLayout(menuRes);
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            this.parseMenu((XmlPullParser)parser, attrs);
        }
        this.generateLayout(itemWidth);
    }

    public void items(String ... items) {
        this.items(this.DEFAULT_MENU_WIDTH, items);
    }

    public void items(int itemWidth, String ... items) {
        this.menuItemList.clear();
        for (int i = 0; i < items.length; ++i) {
            MenuItem menuModel = new MenuItem();
            menuModel.setItem(items[i]);
            this.menuItemList.add(menuModel);
        }
        this.generateLayout(itemWidth);
    }

    public <T extends MenuItem> void items(List<T> itemList) {
        this.menuItemList.clear();
        this.menuItemList.addAll(itemList);
        this.generateLayout(this.DEFAULT_MENU_WIDTH);
    }

    public <T extends MenuItem> void items(List<T> itemList, int itemWidth) {
        this.menuItemList.clear();
        this.menuItemList.addAll(itemList);
        this.generateLayout(itemWidth);
    }

    private void generateLayout(int itemWidth) {
        this.menuLayout = new LinearLayout(this.context);
        this.menuLayout.setBackgroundDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.bg_shadow));
        this.menuLayout.setOrientation(1);
        int padding = Display.dip2px(this.context, 12.0f);
        for (int i = 0; i < this.menuItemList.size(); ++i) {
            TextView textView = new TextView(this.context);
            textView.setClickable(true);
            textView.setBackgroundDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.selector_item));
            textView.setPadding(padding, padding, padding, padding);
            textView.setWidth(itemWidth);
            textView.setGravity(8388627);
            textView.setTextSize(15.0f);
            textView.setTextColor(-16777216);
            MenuItem menuModel = this.menuItemList.get(i);
            if (menuModel.getItemResId() != -1) {
                Drawable drawable2 = ContextCompat.getDrawable((Context)this.context, (int)menuModel.getItemResId());
                drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
                textView.setCompoundDrawablePadding(Display.dip2px(this.context, 12.0f));
                textView.setCompoundDrawables(drawable2, null, null, null);
            }
            textView.setText((CharSequence)menuModel.getItem());
            if (this.onItemClickListener != null) {
                textView.setOnClickListener((View.OnClickListener)new ItemOnClickListener(i));
            }
            this.menuLayout.addView((View)textView);
        }
        int width = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int height = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.menuLayout.measure(width, height);
        this.menuWidth = this.menuLayout.getMeasuredWidth();
        this.menuHeight = this.menuLayout.getMeasuredHeight();
        this.setContentView((View)this.menuLayout);
        this.setWidth(this.menuWidth);
        this.setHeight(this.menuHeight);
    }

    private void parseMenu(XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        String tagName;
        int eventType = parser.getEventType();
        boolean lookingForEndOfUnknownTag = false;
        String unknownTagName = null;
        do {
            if (eventType != 2) continue;
            tagName = parser.getName();
            if (tagName.equals(XML_MENU)) {
                eventType = parser.next();
                break;
            }
            throw new RuntimeException("Expecting menu, got " + tagName);
        } while ((eventType = parser.next()) != 1);
        boolean reachedEndOfMenu = false;
        while (!reachedEndOfMenu) {
            switch (eventType) {
                case 2: {
                    if (lookingForEndOfUnknownTag) break;
                    tagName = parser.getName();
                    if (tagName.equals(XML_GROUP)) {
                        parser.next();
                        break;
                    }
                    if (tagName.equals(XML_ITEM)) {
                        this.readItem(attrs);
                        break;
                    }
                    if (tagName.equals(XML_MENU)) {
                        parser.next();
                        break;
                    }
                    lookingForEndOfUnknownTag = true;
                    unknownTagName = tagName;
                    break;
                }
                case 3: {
                    tagName = parser.getName();
                    if (lookingForEndOfUnknownTag && tagName.equals(unknownTagName)) {
                        lookingForEndOfUnknownTag = false;
                        unknownTagName = null;
                        break;
                    }
                    if (tagName.equals(XML_GROUP) || tagName.equals(XML_ITEM) || !tagName.equals(XML_MENU)) break;
                    reachedEndOfMenu = true;
                    break;
                }
                case 1: {
                    throw new RuntimeException("Unexpected end of document");
                }
            }
            eventType = parser.next();
        }
    }

    private void readItem(AttributeSet attrs) {
        TypedArray a = this.context.obtainStyledAttributes(attrs, R.styleable.MenuItem);
        CharSequence itemTitle = a.getText(R.styleable.MenuItem_menu_title);
        int itemIconResId = a.getResourceId(R.styleable.MenuItem_icon, -1);
        MenuItem menu = new MenuItem();
        menu.setItem(String.valueOf(itemTitle));
        if (itemIconResId != -1) {
            menu.setItemResId(itemIconResId);
        }
        this.menuItemList.add(menu);
        a.recycle();
    }

    private void readGroup(AttributeSet attrs) {
        TypedArray a = this.context.obtainStyledAttributes(attrs, R.styleable.MenuItem);
        CharSequence itemTitle = a.getText(R.styleable.MenuItem_menu_title);
        a.recycle();
    }

    public void show(Point point) {
        this.clickX = point.x;
        this.clickY = point.y;
        this.show();
    }

    public void show() {
        if (this.isShowing()) {
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            this.setBackgroundDrawable((Drawable)new BitmapDrawable());
        }
        if (this.clickX <= this.screenPoint.x / 2) {
            if (this.clickY + this.menuHeight < this.screenPoint.y) {
                this.setAnimationStyle(R.style.Animation_top_left);
                this.showAtLocation(this.view, 0x800033, this.clickX, this.clickY + this.VERTICAL_OFFSET);
            } else {
                this.setAnimationStyle(R.style.Animation_bottom_left);
                this.showAtLocation(this.view, 0x800033, this.clickX, this.clickY - this.menuHeight - this.VERTICAL_OFFSET);
            }
        } else if (this.clickY + this.menuHeight < this.screenPoint.y) {
            this.setAnimationStyle(R.style.Animation_top_right);
            this.showAtLocation(this.view, 0x800033, this.clickX - this.menuWidth, this.clickY + this.VERTICAL_OFFSET);
        } else {
            this.setAnimationStyle(R.style.Animation_bottom_right);
            this.showAtLocation(this.view, 0x800033, this.clickX - this.menuWidth, this.clickY - this.menuHeight - this.VERTICAL_OFFSET);
        }
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        super.setOnDismissListener(onDismissListener);
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
        if (onItemClickListener != null) {
            for (int i = 0; i < this.menuLayout.getChildCount(); ++i) {
                View view = this.menuLayout.getChildAt(i);
                view.setOnClickListener((View.OnClickListener)new ItemOnClickListener(i));
            }
        }
    }

    class ItemOnClickListener
    implements View.OnClickListener {
        int position;

        public ItemOnClickListener(int position) {
            this.position = position;
        }

        public void onClick(View v) {
            FloatMenu.this.dismiss();
            if (FloatMenu.this.onItemClickListener != null) {
                FloatMenu.this.onItemClickListener.onClick(v, this.position);
            }
        }
    }

    class MenuTouchListener
    implements View.OnTouchListener {
        MenuTouchListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                FloatMenu.this.clickX = (int)event.getRawX();
                FloatMenu.this.clickY = (int)event.getRawY();
            }
            return false;
        }
    }

    public static interface OnItemClickListener {
        public void onClick(View var1, int var2);
    }
}

