/*
 * Decompiled with CFR 0.152.
 */
package me.gujun.android.taggroup;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.ArrowKeyMovementMethod;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.collect.R;
import java.util.ArrayList;
import java.util.List;
import me.gujun.android.taggroup.TagKV;

public class TagGroup
extends ViewGroup {
    private final int default_border_color = Color.rgb((int)73, (int)193, (int)32);
    private final int default_text_color = Color.rgb((int)73, (int)193, (int)32);
    private final int default_background_color = -1;
    private final int default_dash_border_color = Color.rgb((int)170, (int)170, (int)170);
    private final int default_input_hint_color = Color.argb((int)128, (int)0, (int)0, (int)0);
    private final int default_input_text_color = Color.argb((int)222, (int)0, (int)0, (int)0);
    private final int default_checked_border_color = Color.rgb((int)73, (int)193, (int)32);
    private final int default_checked_text_color = -1;
    private final int default_checked_marker_color = -1;
    private final int default_checked_background_color = Color.rgb((int)73, (int)193, (int)32);
    private final int default_pressed_background_color = Color.rgb((int)237, (int)237, (int)237);
    private final float default_border_stroke_width;
    private final float default_text_size;
    private final float default_horizontal_spacing;
    private final float default_vertical_spacing;
    private final float default_horizontal_padding;
    private final float default_vertical_padding;
    private boolean isAppendMode;
    private CharSequence inputHint;
    private int borderColor;
    private int textColor;
    private int backgroundColor;
    private int dashBorderColor;
    private int inputHintColor;
    private int inputTextColor;
    private int checkedBorderColor;
    private int checkedTextColor;
    private int checkedMarkerColor;
    private int checkedBackgroundColor;
    private int pressedBackgroundColor;
    private float borderStrokeWidth;
    private float textSize;
    private int horizontalSpacing;
    private int verticalSpacing;
    private int horizontalPadding;
    private int verticalPadding;
    private OnTagChangeListener mOnTagChangeListener;
    private OnTagClickListener mOnTagClickListener;
    private InternalTagClickListener mInternalTagClickListener = new InternalTagClickListener();

    public TagGroup(Context context) {
        this(context, null);
    }

    public TagGroup(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.tagGroupStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.default_border_stroke_width = this.dp2px(0.5f);
        this.default_text_size = this.sp2px(13.0f);
        this.default_horizontal_spacing = this.dp2px(8.0f);
        this.default_vertical_spacing = this.dp2px(4.0f);
        this.default_horizontal_padding = this.dp2px(12.0f);
        this.default_vertical_padding = this.dp2px(3.0f);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TagGroup, defStyleAttr, R.style.TagGroup);
        try {
            this.isAppendMode = a.getBoolean(R.styleable.TagGroup_atg_isAppendMode, false);
            this.inputHint = a.getText(R.styleable.TagGroup_atg_inputHint);
            this.borderColor = a.getColor(R.styleable.TagGroup_atg_borderColor, this.default_border_color);
            this.textColor = a.getColor(R.styleable.TagGroup_atg_textColor, this.default_text_color);
            this.backgroundColor = a.getColor(R.styleable.TagGroup_atg_backgroundColor, -1);
            this.dashBorderColor = a.getColor(R.styleable.TagGroup_atg_dashBorderColor, this.default_dash_border_color);
            this.inputHintColor = a.getColor(R.styleable.TagGroup_atg_inputHintColor, this.default_input_hint_color);
            this.inputTextColor = a.getColor(R.styleable.TagGroup_atg_inputTextColor, this.default_input_text_color);
            this.checkedBorderColor = a.getColor(R.styleable.TagGroup_atg_checkedBorderColor, this.default_checked_border_color);
            this.checkedTextColor = a.getColor(R.styleable.TagGroup_atg_checkedTextColor, -1);
            this.checkedMarkerColor = a.getColor(R.styleable.TagGroup_atg_checkedMarkerColor, -1);
            this.checkedBackgroundColor = a.getColor(R.styleable.TagGroup_atg_checkedBackgroundColor, this.default_checked_background_color);
            this.pressedBackgroundColor = a.getColor(R.styleable.TagGroup_atg_pressedBackgroundColor, this.default_pressed_background_color);
            this.borderStrokeWidth = a.getDimension(R.styleable.TagGroup_atg_borderStrokeWidth, this.default_border_stroke_width);
            this.textSize = a.getDimension(R.styleable.TagGroup_atg_textSize, this.default_text_size);
            this.horizontalSpacing = (int)a.getDimension(R.styleable.TagGroup_atg_horizontalSpacing, this.default_horizontal_spacing);
            this.verticalSpacing = (int)a.getDimension(R.styleable.TagGroup_atg_verticalSpacing, this.default_vertical_spacing);
            this.horizontalPadding = (int)a.getDimension(R.styleable.TagGroup_atg_horizontalPadding, this.default_horizontal_padding);
            this.verticalPadding = (int)a.getDimension(R.styleable.TagGroup_atg_verticalPadding, this.default_vertical_padding);
        }
        finally {
            a.recycle();
        }
        if (this.isAppendMode) {
            this.appendInputTag();
            this.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TagGroup.this.submitTag();
                }
            });
        }
    }

    public void submitTag() {
        TagView inputTag = this.getInputTag();
        if (inputTag != null && inputTag.isInputAvailable()) {
            inputTag.endInput();
            if (this.mOnTagChangeListener != null) {
                this.mOnTagChangeListener.onAppend(this, inputTag.getText().toString());
            }
            this.appendInputTag();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int width = 0;
        int height = 0;
        int row = 0;
        int rowWidth = 0;
        int rowMaxHeight = 0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (child.getVisibility() == 8) continue;
            if ((rowWidth += childWidth) > widthSize) {
                rowWidth = childWidth;
                height += rowMaxHeight + this.verticalSpacing;
                rowMaxHeight = childHeight;
                ++row;
            } else {
                rowMaxHeight = Math.max(rowMaxHeight, childHeight);
            }
            rowWidth += this.horizontalSpacing;
        }
        height += rowMaxHeight;
        height += this.getPaddingTop() + this.getPaddingBottom();
        if (row == 0) {
            width = rowWidth;
            width += this.getPaddingLeft() + this.getPaddingRight();
        } else {
            width = widthSize;
        }
        this.setMeasuredDimension(widthMode == 0x40000000 ? widthSize : width, heightMode == 0x40000000 ? heightSize : height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int parentLeft = this.getPaddingLeft();
        int parentRight = r - l - this.getPaddingRight();
        int parentTop = this.getPaddingTop();
        int parentBottom = b - t - this.getPaddingBottom();
        int childLeft = parentLeft;
        int childTop = parentTop;
        int rowMaxHeight = 0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            if (child.getVisibility() == 8) continue;
            if (childLeft + width > parentRight) {
                childLeft = parentLeft;
                childTop += rowMaxHeight + this.verticalSpacing;
                rowMaxHeight = height;
            } else {
                rowMaxHeight = Math.max(rowMaxHeight, height);
            }
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
            childLeft += width + this.horizontalSpacing;
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setTags(ss.tags);
        TagView checkedTagView = this.getTagAt(ss.checkedPosition);
        if (checkedTagView != null) {
            checkedTagView.setChecked(true);
        }
        if (this.getInputTag() != null) {
            this.getInputTag().setText(ss.input);
        }
    }

    protected TagView getInputTag() {
        if (this.isAppendMode) {
            int inputTagIndex = this.getChildCount() - 1;
            TagView inputTag = this.getTagAt(inputTagIndex);
            if (inputTag != null && inputTag.mState == 2) {
                return inputTag;
            }
            return null;
        }
        return null;
    }

    public String getInputTagText() {
        TagView inputTagView = this.getInputTag();
        if (inputTagView != null) {
            return inputTagView.getText().toString();
        }
        return null;
    }

    protected TagView getLastNormalTagView() {
        int lastNormalTagIndex = this.isAppendMode ? this.getChildCount() - 2 : this.getChildCount() - 1;
        TagView lastNormalTagView = this.getTagAt(lastNormalTagIndex);
        return lastNormalTagView;
    }

    public String[] getTags() {
        int count = this.getChildCount();
        ArrayList<String> tagList = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            TagView tagView = this.getTagAt(i);
            if (tagView.mState != 1) continue;
            tagList.add(tagView.getText().toString());
        }
        return tagList.toArray(new String[tagList.size()]);
    }

    public void setTags(List<String> tagList) {
        this.setTags(tagList.toArray(new String[tagList.size()]));
    }

    public void setTags(String ... tags) {
        this.removeAllViews();
        for (String tag : tags) {
            this.appendTag(tag);
        }
        if (this.isAppendMode) {
            this.appendInputTag();
        }
    }

    public void setTagsKV(List<TagKV> tagKv) {
        this.removeAllViews();
        for (TagKV kv : tagKv) {
            this.appendTag(kv);
        }
        if (this.isAppendMode) {
            this.appendInputTag();
        }
    }

    protected TagView getTagAt(int index) {
        return (TagView)this.getChildAt(index);
    }

    protected TagView getCheckedTag() {
        int checkedTagIndex = this.getCheckedTagIndex();
        if (checkedTagIndex != -1) {
            return this.getTagAt(checkedTagIndex);
        }
        return null;
    }

    protected int getCheckedTagIndex() {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            TagView tag = this.getTagAt(i);
            if (!tag.isChecked) continue;
            return i;
        }
        return -1;
    }

    public void setOnTagChangeListener(OnTagChangeListener l) {
        this.mOnTagChangeListener = l;
    }

    protected void appendInputTag() {
        this.appendInputTag(null);
    }

    protected void appendInputTag(String tag) {
        TagView previousInputTag = this.getInputTag();
        if (previousInputTag != null) {
            throw new IllegalStateException("Already has a INPUT tag in group.");
        }
        TagView newInputTag = new TagView(this.getContext(), 2, tag);
        newInputTag.setOnClickListener(this.mInternalTagClickListener);
        this.addView((View)newInputTag);
    }

    protected void appendTag(CharSequence tag) {
        TagView newTag = new TagView(this.getContext(), 1, tag);
        newTag.setOnClickListener(this.mInternalTagClickListener);
        this.addView((View)newTag);
    }

    protected void appendTag(TagKV kv) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.item_tagkv, null);
        LinearLayout llTagKvs = (LinearLayout)view.findViewById(R.id.ll_tagkv);
        TextView tvKey = (TextView)view.findViewById(R.id.tvKey);
        TextView tvValue = (TextView)view.findViewById(R.id.tvValue);
        tvKey.setText((CharSequence)kv.key);
        tvValue.setText((CharSequence)kv.value);
        this.addView((View)llTagKvs);
    }

    public float dp2px(float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public float sp2px(float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public void setOnTagClickListener(OnTagClickListener l) {
        this.mOnTagClickListener = l;
    }

    protected void deleteTag(TagView tagView) {
        this.removeView((View)tagView);
        if (this.mOnTagChangeListener != null) {
            this.mOnTagChangeListener.onDelete(this, tagView.getText().toString());
        }
    }

    @SuppressLint(value={"AppCompatCustomView"})
    class TagView
    extends TextView {
        public static final int STATE_NORMAL = 1;
        public static final int STATE_INPUT = 2;
        private static final int CHECKED_MARKER_OFFSET = 3;
        private static final int CHECKED_MARKER_STROKE_WIDTH = 4;
        private int mState;
        private boolean isChecked;
        private boolean isPressed;
        private Paint mBorderPaint;
        private Paint mBackgroundPaint;
        private Paint mCheckedMarkerPaint;
        private RectF mLeftCornerRectF;
        private RectF mRightCornerRectF;
        private RectF mHorizontalBlankFillRectF;
        private RectF mVerticalBlankFillRectF;
        private RectF mCheckedMarkerBound;
        private Rect mOutRect;
        private Path mBorderPath;
        private PathEffect mPathEffect;

        public TagView(Context context, final int state, CharSequence text) {
            super(context);
            this.isChecked = false;
            this.isPressed = false;
            this.mBorderPaint = new Paint(1);
            this.mBackgroundPaint = new Paint(1);
            this.mCheckedMarkerPaint = new Paint(1);
            this.mLeftCornerRectF = new RectF();
            this.mRightCornerRectF = new RectF();
            this.mHorizontalBlankFillRectF = new RectF();
            this.mVerticalBlankFillRectF = new RectF();
            this.mCheckedMarkerBound = new RectF();
            this.mOutRect = new Rect();
            this.mBorderPath = new Path();
            this.mPathEffect = new DashPathEffect(new float[]{10.0f, 5.0f}, 0.0f);
            this.mBorderPaint.setStyle(Paint.Style.STROKE);
            this.mBorderPaint.setStrokeWidth(TagGroup.this.borderStrokeWidth);
            this.mBackgroundPaint.setStyle(Paint.Style.FILL);
            this.mCheckedMarkerPaint.setStyle(Paint.Style.FILL);
            this.mCheckedMarkerPaint.setStrokeWidth(4.0f);
            this.mCheckedMarkerPaint.setColor(TagGroup.this.checkedMarkerColor);
            this.setPadding(TagGroup.this.horizontalPadding, TagGroup.this.verticalPadding, TagGroup.this.horizontalPadding, TagGroup.this.verticalPadding);
            this.setLayoutParams(new LayoutParams(-2, -2));
            this.setGravity(17);
            this.setText(text);
            this.setTextSize(0, TagGroup.this.textSize);
            this.mState = state;
            this.setClickable(TagGroup.this.isAppendMode);
            this.setFocusable(state == 2);
            this.setFocusableInTouchMode(state == 2);
            this.setHint(state == 2 ? TagGroup.this.inputHint : null);
            this.setMovementMethod((MovementMethod)(state == 2 ? ArrowKeyMovementMethod.getInstance() : null));
            this.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return state != 2;
                }
            });
            if (state == 2) {
                this.requestFocus();
                this.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                        if (actionId == 0 && event != null && event.getKeyCode() == 66 && event.getAction() == 0) {
                            if (TagView.this.isInputAvailable()) {
                                TagView.this.endInput();
                                if (TagGroup.this.mOnTagChangeListener != null) {
                                    TagGroup.this.mOnTagChangeListener.onAppend(TagGroup.this, TagView.this.getText().toString());
                                }
                                TagGroup.this.appendInputTag();
                            }
                            return true;
                        }
                        return false;
                    }
                });
                this.setOnKeyListener(new View.OnKeyListener(){

                    public boolean onKey(View v, int keyCode, KeyEvent event) {
                        TagView lastNormalTagView;
                        if (keyCode == 67 && event.getAction() == 0 && TextUtils.isEmpty((CharSequence)TagView.this.getText().toString()) && (lastNormalTagView = TagGroup.this.getLastNormalTagView()) != null) {
                            if (lastNormalTagView.isChecked) {
                                TagGroup.this.removeView((View)lastNormalTagView);
                                if (TagGroup.this.mOnTagChangeListener != null) {
                                    TagGroup.this.mOnTagChangeListener.onDelete(TagGroup.this, lastNormalTagView.getText().toString());
                                }
                            } else {
                                TagView checkedTagView = TagGroup.this.getCheckedTag();
                                if (checkedTagView != null) {
                                    checkedTagView.setChecked(false);
                                }
                                lastNormalTagView.setChecked(true);
                            }
                            return true;
                        }
                        return false;
                    }
                });
                this.addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                        TagView checkedTagView = TagGroup.this.getCheckedTag();
                        if (checkedTagView != null) {
                            checkedTagView.setChecked(false);
                        }
                    }

                    public void onTextChanged(CharSequence s, int start, int before, int count) {
                    }

                    public void afterTextChanged(Editable s) {
                    }
                });
            }
            this.invalidatePaint();
        }

        public void setChecked(boolean checked) {
            this.isChecked = checked;
            this.setPadding(TagGroup.this.horizontalPadding, TagGroup.this.verticalPadding, this.isChecked ? (int)((float)TagGroup.this.horizontalPadding + (float)this.getHeight() / 2.5f + 3.0f) : TagGroup.this.horizontalPadding, TagGroup.this.verticalPadding);
            this.invalidatePaint();
        }

        public void endInput() {
            this.setFocusable(false);
            this.setFocusableInTouchMode(false);
            this.setHint(null);
            this.setMovementMethod(null);
            this.mState = 1;
            this.invalidatePaint();
            this.requestLayout();
        }

        protected boolean getDefaultEditable() {
            return true;
        }

        public boolean isInputAvailable() {
            return this.getText() != null && this.getText().length() > 0;
        }

        private void invalidatePaint() {
            if (TagGroup.this.isAppendMode) {
                if (this.mState == 2) {
                    this.mBorderPaint.setColor(TagGroup.this.dashBorderColor);
                    this.mBorderPaint.setPathEffect(this.mPathEffect);
                    this.mBackgroundPaint.setColor(TagGroup.this.backgroundColor);
                    this.setHintTextColor(TagGroup.this.inputHintColor);
                    this.setTextColor(TagGroup.this.inputTextColor);
                } else {
                    this.mBorderPaint.setPathEffect(null);
                    if (this.isChecked) {
                        this.mBorderPaint.setColor(TagGroup.this.checkedBorderColor);
                        this.mBackgroundPaint.setColor(TagGroup.this.checkedBackgroundColor);
                        this.setTextColor(TagGroup.this.checkedTextColor);
                    } else {
                        this.mBorderPaint.setColor(TagGroup.this.borderColor);
                        this.mBackgroundPaint.setColor(TagGroup.this.backgroundColor);
                        this.setTextColor(TagGroup.this.textColor);
                    }
                }
            } else {
                this.mBorderPaint.setColor(TagGroup.this.borderColor);
                this.mBackgroundPaint.setColor(TagGroup.this.backgroundColor);
                this.setTextColor(TagGroup.this.textColor);
            }
            if (this.isPressed) {
                this.mBackgroundPaint.setColor(TagGroup.this.pressedBackgroundColor);
            }
        }

        protected void onDraw(Canvas canvas) {
            canvas.drawArc(this.mLeftCornerRectF, -180.0f, 90.0f, true, this.mBackgroundPaint);
            canvas.drawArc(this.mLeftCornerRectF, -270.0f, 90.0f, true, this.mBackgroundPaint);
            canvas.drawArc(this.mRightCornerRectF, -90.0f, 90.0f, true, this.mBackgroundPaint);
            canvas.drawArc(this.mRightCornerRectF, 0.0f, 90.0f, true, this.mBackgroundPaint);
            canvas.drawRect(this.mHorizontalBlankFillRectF, this.mBackgroundPaint);
            canvas.drawRect(this.mVerticalBlankFillRectF, this.mBackgroundPaint);
            if (this.isChecked) {
                canvas.save();
                canvas.rotate(45.0f, this.mCheckedMarkerBound.centerX(), this.mCheckedMarkerBound.centerY());
                canvas.drawLine(this.mCheckedMarkerBound.left, this.mCheckedMarkerBound.centerY(), this.mCheckedMarkerBound.right, this.mCheckedMarkerBound.centerY(), this.mCheckedMarkerPaint);
                canvas.drawLine(this.mCheckedMarkerBound.centerX(), this.mCheckedMarkerBound.top, this.mCheckedMarkerBound.centerX(), this.mCheckedMarkerBound.bottom, this.mCheckedMarkerPaint);
                canvas.restore();
            }
            canvas.drawPath(this.mBorderPath, this.mBorderPaint);
            super.onDraw(canvas);
        }

        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            super.onSizeChanged(w, h, oldw, oldh);
            int left = (int)TagGroup.this.borderStrokeWidth;
            int top = (int)TagGroup.this.borderStrokeWidth;
            int right = (int)((float)(left + w) - TagGroup.this.borderStrokeWidth * 2.0f);
            int bottom = (int)((float)(top + h) - TagGroup.this.borderStrokeWidth * 2.0f);
            int d = bottom - top;
            this.mLeftCornerRectF.set((float)left, (float)top, (float)(left + d), (float)(top + d));
            this.mRightCornerRectF.set((float)(right - d), (float)top, (float)right, (float)(top + d));
            this.mBorderPath.reset();
            this.mBorderPath.addArc(this.mLeftCornerRectF, -180.0f, 90.0f);
            this.mBorderPath.addArc(this.mLeftCornerRectF, -270.0f, 90.0f);
            this.mBorderPath.addArc(this.mRightCornerRectF, -90.0f, 90.0f);
            this.mBorderPath.addArc(this.mRightCornerRectF, 0.0f, 90.0f);
            int l = (int)((float)d / 2.0f);
            this.mBorderPath.moveTo((float)(left + l), (float)top);
            this.mBorderPath.lineTo((float)(right - l), (float)top);
            this.mBorderPath.moveTo((float)(left + l), (float)bottom);
            this.mBorderPath.lineTo((float)(right - l), (float)bottom);
            this.mBorderPath.moveTo((float)left, (float)(top + l));
            this.mBorderPath.lineTo((float)left, (float)(bottom - l));
            this.mBorderPath.moveTo((float)right, (float)(top + l));
            this.mBorderPath.lineTo((float)right, (float)(bottom - l));
            this.mHorizontalBlankFillRectF.set((float)left, (float)(top + l), (float)right, (float)(bottom - l));
            this.mVerticalBlankFillRectF.set((float)(left + l), (float)top, (float)(right - l), (float)bottom);
            int m = (int)((float)h / 2.5f);
            h = bottom - top;
            this.mCheckedMarkerBound.set((float)(right - m - TagGroup.this.horizontalPadding + 3), (float)(top + h / 2 - m / 2), (float)(right - TagGroup.this.horizontalPadding + 3), (float)(bottom - h / 2 + m / 2));
            if (this.isChecked) {
                this.setPadding(TagGroup.this.horizontalPadding, TagGroup.this.verticalPadding, (int)((float)TagGroup.this.horizontalPadding + (float)h / 2.5f + 3.0f), TagGroup.this.verticalPadding);
            }
        }

        public boolean onTouchEvent(MotionEvent event) {
            if (this.mState == 2) {
                return super.onTouchEvent(event);
            }
            switch (event.getAction()) {
                case 0: {
                    this.getDrawingRect(this.mOutRect);
                    this.isPressed = true;
                    this.invalidatePaint();
                    this.invalidate();
                    break;
                }
                case 2: {
                    if (this.mOutRect.contains((int)event.getX(), (int)event.getY())) break;
                    this.isPressed = false;
                    this.invalidatePaint();
                    this.invalidate();
                    break;
                }
                case 1: {
                    this.isPressed = false;
                    this.invalidatePaint();
                    this.invalidate();
                }
            }
            return super.onTouchEvent(event);
        }

        public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
            return new ZanyInputConnection(super.onCreateInputConnection(outAttrs), true);
        }

        private class ZanyInputConnection
        extends InputConnectionWrapper {
            public ZanyInputConnection(InputConnection target, boolean mutable) {
                super(target, mutable);
            }

            public boolean deleteSurroundingText(int beforeLength, int afterLength) {
                if (beforeLength == 1 && afterLength == 0) {
                    return this.sendKeyEvent(new KeyEvent(0, 67)) && this.sendKeyEvent(new KeyEvent(1, 67));
                }
                return super.deleteSurroundingText(beforeLength, afterLength);
            }
        }
    }

    class InternalTagClickListener
    implements View.OnClickListener {
        InternalTagClickListener() {
        }

        public void onClick(View v) {
            TagView tag = (TagView)v;
            if (TagGroup.this.isAppendMode) {
                if (tag.mState == 2) {
                    TagView checkedTag = TagGroup.this.getCheckedTag();
                    if (checkedTag != null) {
                        checkedTag.setChecked(false);
                    }
                } else if (tag.isChecked) {
                    TagGroup.this.deleteTag(tag);
                } else {
                    TagView checkedTag = TagGroup.this.getCheckedTag();
                    if (checkedTag != null) {
                        checkedTag.setChecked(false);
                    }
                    tag.setChecked(true);
                }
            } else if (TagGroup.this.mOnTagClickListener != null) {
                TagGroup.this.mOnTagClickListener.onTagClick(tag.getText().toString());
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        int tagCount;
        String[] tags;
        int checkedPosition;
        String input;

        public SavedState(Parcel source) {
            super(source);
            this.tagCount = source.readInt();
            this.tags = new String[this.tagCount];
            source.readStringArray(this.tags);
            this.checkedPosition = source.readInt();
            this.input = source.readString();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            this.tagCount = this.tags.length;
            dest.writeInt(this.tagCount);
            dest.writeStringArray(this.tags);
            dest.writeInt(this.checkedPosition);
            dest.writeString(this.input);
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }
    }

    public static interface OnTagClickListener {
        public void onTagClick(String var1);
    }

    public static interface OnTagChangeListener {
        public void onAppend(TagGroup var1, String var2);

        public void onDelete(TagGroup var1, String var2);
    }
}

