/*
 * Decompiled with CFR 0.152.
 */
package com.collects.pkg.widget.customview;

import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import com.collect.R;

public final class ShapedDelegate {
    private int mSolidColor;
    private int mStrokeWidth;
    private int mStrokeColor;
    private float mCornerRadius;
    private float mCornerBottomStart;
    private float mCornerBottomEnd;
    private float mCornerTopStart;
    private float mCornerTopEnd;
    private int mGradientStartColor;
    private int mGradientCenterColor;
    private int mGradientEndColor;
    private int mGradientType;
    private int mGradientOrientation;
    private float mGradientCenterX;
    private float mGradientCenterY;
    private float mGradientRadius;
    private boolean mGradientUseLevel;
    private Drawable mAndroidDrawable;
    private View mTarget;

    public static ShapedDelegate obtain(View target, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        return new ShapedDelegate(target, attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShapedDelegate(View view, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = null;
        try {
            a = view.getContext().obtainStyledAttributes(attrs, R.styleable.ShapeView, defStyleAttr, defStyleRes);
            this.mCornerRadius = a.getDimension(R.styleable.ShapeView_corner_radius, 0.0f);
            this.mSolidColor = a.getColor(R.styleable.ShapeView_solid_color, 0);
            this.mStrokeWidth = a.getDimensionPixelSize(R.styleable.ShapeView_stroke_width, 0);
            this.mStrokeColor = a.getColor(R.styleable.ShapeView_stroke_color, 0);
            this.mCornerBottomStart = a.getDimension(R.styleable.ShapeView_corner_bottom_start, this.mCornerRadius);
            this.mCornerBottomEnd = a.getDimension(R.styleable.ShapeView_corner_bottom_end, this.mCornerRadius);
            this.mCornerTopStart = a.getDimension(R.styleable.ShapeView_corner_top_start, this.mCornerRadius);
            this.mCornerTopEnd = a.getDimension(R.styleable.ShapeView_corner_top_end, this.mCornerRadius);
            this.mGradientStartColor = a.getColor(R.styleable.ShapeView_gradient_start_color, 0);
            this.mGradientCenterColor = a.getColor(R.styleable.ShapeView_gradient_center_color, 0);
            this.mGradientEndColor = a.getColor(R.styleable.ShapeView_gradient_end_color, 0);
            this.mGradientType = a.getInteger(R.styleable.ShapeView_gradient_type, -1);
            this.mGradientOrientation = a.getInteger(R.styleable.ShapeView_gradient_orientation, -1);
            this.mGradientCenterX = a.getDimension(R.styleable.ShapeView_gradient_center_x, -1.0f);
            this.mGradientCenterY = a.getDimension(R.styleable.ShapeView_gradient_center_y, -1.0f);
            this.mGradientRadius = a.getDimension(R.styleable.ShapeView_gradient_radius, -1.0f);
            this.mGradientUseLevel = a.getBoolean(R.styleable.ShapeView_gradient_use_level, false);
            this.mAndroidDrawable = a.getDrawable(R.styleable.ShapeView_android_background);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
        this.mTarget = view;
        if (this.mAndroidDrawable == null || this.mAndroidDrawable instanceof ColorDrawable) {
            this.setShapeBackground();
        }
    }

    private void setShapeBackground() {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setShape(0);
        if (this.mSolidColor != 0) {
            gradientDrawable.setColor(this.mSolidColor);
        }
        if (this.mCornerRadius > 0.0f) {
            gradientDrawable.setCornerRadius(this.mCornerRadius);
        } else if (this.mCornerTopStart != 0.0f || this.mCornerTopEnd != 0.0f || this.mCornerBottomEnd != 0.0f || this.mCornerBottomStart != 0.0f) {
            gradientDrawable.setCornerRadii(new float[]{this.mCornerTopStart, this.mCornerTopStart, this.mCornerTopEnd, this.mCornerTopEnd, this.mCornerBottomEnd, this.mCornerBottomEnd, this.mCornerBottomStart, this.mCornerBottomStart});
        }
        if (this.mStrokeWidth > 0 && this.mStrokeColor != 0) {
            gradientDrawable.setStroke(this.mStrokeWidth, this.mStrokeColor);
        }
        gradientDrawable.setUseLevel(this.mGradientUseLevel);
        if (this.mGradientRadius != -1.0f) {
            gradientDrawable.setGradientRadius(this.mGradientRadius);
        }
        if (this.mGradientCenterX != -1.0f && this.mGradientCenterY != -1.0f) {
            gradientDrawable.setGradientCenter(this.mGradientCenterX, this.mGradientCenterY);
        }
        if (this.mGradientOrientation != -1) {
            gradientDrawable.setOrientation(this.getGradientOrientation(this.mGradientOrientation));
        }
        if (this.mGradientType != -1) {
            gradientDrawable.setGradientType(this.mGradientType);
        }
        if (this.mGradientStartColor != 0 && this.mGradientEndColor != 0) {
            if (this.mGradientCenterColor != 0) {
                gradientDrawable.setColors(new int[]{this.mGradientStartColor, this.mGradientCenterColor, this.mGradientEndColor});
            } else {
                gradientDrawable.setColors(new int[]{this.mGradientStartColor, this.mGradientEndColor});
            }
        }
        this.mTarget.setBackground((Drawable)gradientDrawable);
    }

    private GradientDrawable.Orientation getGradientOrientation(int orientation) {
        GradientDrawable.Orientation mOrientation;
        switch (orientation) {
            case 0: {
                mOrientation = GradientDrawable.Orientation.TOP_BOTTOM;
                break;
            }
            case 1: {
                mOrientation = GradientDrawable.Orientation.TR_BL;
                break;
            }
            case 2: {
                mOrientation = GradientDrawable.Orientation.RIGHT_LEFT;
                break;
            }
            case 3: {
                mOrientation = GradientDrawable.Orientation.BR_TL;
                break;
            }
            case 4: {
                mOrientation = GradientDrawable.Orientation.BOTTOM_TOP;
                break;
            }
            case 5: {
                mOrientation = GradientDrawable.Orientation.BL_TR;
                break;
            }
            case 6: {
                mOrientation = GradientDrawable.Orientation.LEFT_RIGHT;
                break;
            }
            case 7: {
                mOrientation = GradientDrawable.Orientation.TL_BR;
                break;
            }
            default: {
                mOrientation = GradientDrawable.Orientation.TOP_BOTTOM;
            }
        }
        return mOrientation;
    }

    public void setColors(@ColorInt int[] colors) {
        if (colors.length < 2) {
            throw new RuntimeException("colors length < 2");
        }
        this.mGradientStartColor = colors[0];
        if (colors.length == 2) {
            this.mGradientEndColor = colors[1];
        } else {
            this.mGradientCenterColor = colors[1];
            this.mGradientEndColor = colors[2];
        }
        this.mSolidColor = 0;
        if (this.mTarget.getBackground() instanceof GradientDrawable) {
            ((GradientDrawable)this.mTarget.getBackground()).setColor(0);
            ((GradientDrawable)this.mTarget.getBackground()).setColors(colors);
        } else {
            this.setShapeBackground();
        }
    }

    public void setColor(@ColorInt int argb) {
        this.mSolidColor = argb;
        this.mGradientStartColor = 0;
        this.mGradientCenterColor = 0;
        this.mGradientEndColor = 0;
        if (this.mTarget.getBackground() instanceof GradientDrawable) {
            ((GradientDrawable)this.mTarget.getBackground()).setColor(this.mSolidColor);
        } else {
            this.setShapeBackground();
        }
    }

    public void setStrokeColor(@ColorInt int argb) {
        this.mStrokeColor = argb;
        if (this.mTarget.getBackground() instanceof GradientDrawable) {
            ((GradientDrawable)this.mTarget.getBackground()).setStroke(this.mStrokeWidth, argb);
        } else {
            this.setShapeBackground();
        }
    }

    public void setStroke(int strokeWidth, @ColorInt int argb) {
        this.mStrokeColor = argb;
        this.mStrokeWidth = strokeWidth;
        if (this.mTarget.getBackground() instanceof GradientDrawable) {
            ((GradientDrawable)this.mTarget.getBackground()).setStroke(this.mStrokeWidth, this.mStrokeColor);
        } else {
            this.setShapeBackground();
        }
    }

    public void setCornerRadii(int ... cornerRadii) {
        this.mCornerTopStart = cornerRadii.length > 0 ? (float)cornerRadii[0] : this.mCornerTopStart;
        this.mCornerTopEnd = cornerRadii.length > 1 ? (float)cornerRadii[1] : this.mCornerTopEnd;
        this.mCornerBottomEnd = cornerRadii.length > 2 ? (float)cornerRadii[2] : this.mCornerBottomEnd;
        float f = this.mCornerBottomStart = cornerRadii.length > 3 ? (float)cornerRadii[3] : this.mCornerBottomStart;
        if (this.mTarget.getBackground() instanceof GradientDrawable) {
            ((GradientDrawable)this.mTarget.getBackground()).setCornerRadii(new float[]{this.mCornerTopStart, this.mCornerTopStart, this.mCornerTopEnd, this.mCornerTopEnd, this.mCornerBottomEnd, this.mCornerBottomEnd, this.mCornerBottomStart, this.mCornerBottomStart});
        } else {
            this.setShapeBackground();
        }
    }

    public void setCornerRadiis(int cornerRadii) {
        this.setCornerRadii(cornerRadii, cornerRadii, cornerRadii, cornerRadii);
    }

    public void setGradientOrientation(GradientDrawable.Orientation orientation) {
        switch (orientation) {
            case BL_TR: {
                this.mGradientOrientation = 5;
                break;
            }
            case BR_TL: {
                this.mGradientOrientation = 3;
                break;
            }
            case TL_BR: {
                this.mGradientOrientation = 7;
                break;
            }
            case TR_BL: {
                this.mGradientOrientation = 1;
                break;
            }
            case BOTTOM_TOP: {
                this.mGradientOrientation = 4;
                break;
            }
            case LEFT_RIGHT: {
                this.mGradientOrientation = 6;
                break;
            }
            case RIGHT_LEFT: {
                this.mGradientOrientation = 2;
                break;
            }
            case TOP_BOTTOM: {
                this.mGradientOrientation = 0;
                break;
            }
            default: {
                this.mGradientOrientation = 0;
            }
        }
        if (this.mTarget.getBackground() instanceof GradientDrawable) {
            ((GradientDrawable)this.mTarget.getBackground()).setOrientation(orientation);
        } else {
            this.setShapeBackground();
        }
    }
}

