/*
 * Decompiled with CFR 0.152.
 */
package com.collects.pkg.widget.customview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.GradientDrawable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.appcompat.widget.AppCompatTextView;
import com.collect.R;
import com.collects.pkg.widget.customview.ShapedDelegate;
import com.collects.pkg.widget.span.CenteredImageSpan;

public class ShapeTextView
extends AppCompatTextView {
    private ShapedDelegate mDelegate;
    private int mIconMargin;
    private int mIconResId;

    public ShapeTextView(Context context) {
        this(context, null);
    }

    public ShapeTextView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShapeTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mDelegate = ShapedDelegate.obtain((View)this, attrs, defStyleAttr, 0);
        TypedArray a = null;
        try {
            a = context.obtainStyledAttributes(attrs, R.styleable.ShapeTextView);
            this.mIconMargin = a.getDimensionPixelSize(R.styleable.ShapeTextView_icon_margin, 0);
            this.mIconResId = a.getResourceId(R.styleable.ShapeTextView_button_icon, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
        if (this.mIconMargin < 0) {
            this.mIconMargin = 0;
        }
        if (this.mIconResId > 0) {
            this.setButtonIcon(this.getText());
        }
    }

    private void setButtonIcon(CharSequence text) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            CenteredImageSpan imageSpan = new CenteredImageSpan(this.getContext(), this.mIconResId);
            SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)" ");
            builder.setSpan((Object)imageSpan, 0, 1, 33);
            if (this.mIconMargin > 0) {
                Bitmap placeholder = Bitmap.createBitmap((int)this.mIconMargin, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                ImageSpan span = new ImageSpan(this.getContext(), placeholder, 1);
                int start = builder.length();
                builder.append((CharSequence)" ");
                builder.setSpan((Object)span, start, builder.length(), 33);
            }
            builder.append(text);
            this.setText((CharSequence)builder);
        }
    }

    public void setButtonText(String text) {
        this.setButtonIcon(text);
    }

    public void setButtonText(@StringRes int stringRes) {
        this.setButtonText(this.getResources().getString(stringRes));
    }

    public void setColor(@ColorInt int argb) {
        this.mDelegate.setColor(argb);
    }

    public void setStrokeColor(@ColorInt int argb) {
        this.mDelegate.setStrokeColor(argb);
    }

    public void setStroke(int strokeWidth, @ColorInt int argb) {
        this.mDelegate.setStroke(strokeWidth, argb);
    }

    public void setColors(@ColorInt int[] colors) {
        this.mDelegate.setColors(colors);
    }

    public void setGradientOrientation(GradientDrawable.Orientation orientation) {
        this.mDelegate.setGradientOrientation(orientation);
    }

    public void setCornerRadii(int ... cornerRadii) {
        this.mDelegate.setCornerRadii(cornerRadii);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
    }
}

