/*
 * Decompiled with CFR 0.152.
 */
package com.github.lzyzsd.circleprogresskt;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0004\u00a8\u0006\u0012"}, d2={"Lcom/github/lzyzsd/circleprogresskt/Utils;", "", "()V", "dp2px", "", "resources", "Landroid/content/res/Resources;", "dp", "getBitmap", "Landroid/graphics/Bitmap;", "context", "Landroid/content/Context;", "drawableId", "", "drawable", "Landroid/graphics/drawable/Drawable;", "sp2px", "sp", "library_release"})
public final class Utils {
    public static final Utils INSTANCE;

    public final float dp2px(@NotNull Resources resources, float dp) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        float scale = resources.getDisplayMetrics().density;
        return dp * scale + 0.5f;
    }

    public final float sp2px(@NotNull Resources resources, float sp) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        float scale = resources.getDisplayMetrics().scaledDensity;
        return sp * scale;
    }

    @NotNull
    public final Bitmap getBitmap(@Nullable Context context, int drawableId) {
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        Drawable drawable = AppCompatResources.getDrawable((Context)context2, (int)drawableId);
        return this.getBitmap(drawable);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap getBitmap(@Nullable Drawable drawable) {
        Bitmap bitmap;
        if (drawable instanceof BitmapDrawable) {
            Bitmap bitmap2 = ((BitmapDrawable)drawable).getBitmap();
            bitmap = bitmap2;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"drawable.bitmap");
        } else {
            void var2_2;
            if (!(drawable instanceof VectorDrawableCompat) && !(drawable instanceof VectorDrawable)) {
                throw (Throwable)new IllegalArgumentException("unsupported drawable type");
            }
            Bitmap bitmap3 = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap3);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            void v2 = var2_2;
            bitmap = v2;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"if (drawable is VectorDr\u2026drawable type\")\n        }");
        }
        return bitmap;
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

