/*
 * Decompiled with CFR 0.152.
 */
package com.github.lzyzsd.circleprogresskt;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.github.lzyzsd.circleprogresskt.R;
import com.github.lzyzsd.circleprogresskt.Utils;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b2\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 y2\u00020\u0001:\u0001yB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010B\u001a\u00020\u0007J\u0006\u0010C\u001a\u00020\u0007J\u0006\u0010D\u001a\u00020\u0012J\u0006\u0010E\u001a\u00020\u0007J\b\u0010F\u001a\u0004\u0018\u00010!J\u0006\u0010G\u001a\u00020\u0007J\u0006\u0010H\u001a\u00020\u0012J\u0006\u0010I\u001a\u00020\u0007J\u0006\u0010J\u001a\u00020!J\u0006\u0010K\u001a\u00020\u0012J\u0006\u0010L\u001a\u00020\u0007J\u0006\u0010M\u001a\u00020!J\b\u0010N\u001a\u0004\u0018\u00010!J\u0006\u0010O\u001a\u00020\u0007J\u0006\u0010P\u001a\u00020\u0012J\u0006\u0010Q\u001a\u00020\u0007J\u0006\u0010R\u001a\u00020\u0012J\u0010\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VH\u0004J\u0014\u0010W\u001a\u00020T2\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0004J\b\u0010X\u001a\u00020TH\u0004J\b\u0010Y\u001a\u00020TH\u0016J\u0010\u0010Z\u001a\u00020\u00072\u0006\u0010[\u001a\u00020\u0007H\u0002J\u0010\u0010\\\u001a\u00020T2\u0006\u0010]\u001a\u00020^H\u0014J\u0018\u0010_\u001a\u00020T2\u0006\u0010`\u001a\u00020\u00072\u0006\u0010a\u001a\u00020\u0007H\u0014J\u0010\u0010b\u001a\u00020T2\u0006\u0010c\u001a\u00020dH\u0014J\b\u0010e\u001a\u00020dH\u0014J\u000e\u0010f\u001a\u00020T2\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010g\u001a\u00020T2\u0006\u0010h\u001a\u00020!J\u000e\u0010i\u001a\u00020T2\u0006\u0010\u001d\u001a\u00020\u0007J\u000e\u0010j\u001a\u00020T2\u0006\u0010\u001e\u001a\u00020\u0012J\u000e\u0010k\u001a\u00020T2\u0006\u0010\u001f\u001a\u00020\u0007J\u0010\u0010l\u001a\u00020T2\b\u0010 \u001a\u0004\u0018\u00010!J\u000e\u0010m\u001a\u00020T2\u0006\u0010\"\u001a\u00020\u0007J\u000e\u0010n\u001a\u00020T2\u0006\u0010)\u001a\u00020\u0012J\u000e\u0010o\u001a\u00020T2\u0006\u0010/\u001a\u00020\u0007J\u000e\u0010p\u001a\u00020T2\u0006\u00101\u001a\u00020!J\u000e\u0010q\u001a\u00020T2\u0006\u00102\u001a\u00020\u0012J\u000e\u0010r\u001a\u00020T2\u0006\u00106\u001a\u00020\u0007J\u000e\u0010s\u001a\u00020T2\u0006\u00107\u001a\u00020!J\u0010\u0010t\u001a\u00020T2\b\u00108\u001a\u0004\u0018\u00010!J\u000e\u0010u\u001a\u00020T2\u0006\u00109\u001a\u00020\u0007J\u000e\u0010v\u001a\u00020T2\u0006\u0010=\u001a\u00020\u0012J\u000e\u0010w\u001a\u00020T2\u0006\u0010@\u001a\u00020\u0007J\u000e\u0010x\u001a\u00020T2\u0006\u0010A\u001a\u00020\u0012R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0004\u0018\u00010\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010:\u001a\u0004\u0018\u00010\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010&\"\u0004\b<\u0010(R\u000e\u0010=\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006z"}, d2={"Lcom/github/lzyzsd/circleprogresskt/DonutProgress;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "attributeResourceId", "bitmap", "Landroid/graphics/Bitmap;", "clockWise", "", "default_finished_color", "default_inner_background_color", "default_inner_bottom_text_color", "default_inner_bottom_text_size", "", "default_max", "default_startingDegree", "default_stroke_width", "default_text_color", "default_text_size", "default_unfinished_color", "finishedOuterRect", "Landroid/graphics/RectF;", "finishedPaint", "Landroid/graphics/Paint;", "finishedStrokeColor", "finishedStrokeWidth", "innerBackgroundColor", "innerBottomText", "", "innerBottomTextColor", "innerBottomTextHeight", "innerBottomTextPaint", "getInnerBottomTextPaint", "()Landroid/graphics/Paint;", "setInnerBottomTextPaint", "(Landroid/graphics/Paint;)V", "innerBottomTextSize", "innerCirclePaint", "isShowText", "()Z", "setShowText", "(Z)V", "max", "min_size", "prefixText", "progress", "progressAngle", "getProgressAngle", "()F", "startingDegree", "suffixText", "text", "textColor", "textPaint", "getTextPaint", "setTextPaint", "textSize", "unfinishedOuterRect", "unfinishedPaint", "unfinishedStrokeColor", "unfinishedStrokeWidth", "getAttributeResourceId", "getFinishedStrokeColor", "getFinishedStrokeWidth", "getInnerBackgroundColor", "getInnerBottomText", "getInnerBottomTextColor", "getInnerBottomTextSize", "getMax", "getPrefixText", "getProgress", "getStartingDegree", "getSuffixText", "getText", "getTextColor", "getTextSize", "getUnfinishedStrokeColor", "getUnfinishedStrokeWidth", "initByAttributes", "", "attributes", "Landroid/content/res/TypedArray;", "initInnerBitmap", "initPainters", "invalidate", "measure", "measureSpec", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "setAttributeResourceId", "setDonut_progress", "percent", "setFinishedStrokeColor", "setFinishedStrokeWidth", "setInnerBackgroundColor", "setInnerBottomText", "setInnerBottomTextColor", "setInnerBottomTextSize", "setMax", "setPrefixText", "setProgress", "setStartingDegree", "setSuffixText", "setText", "setTextColor", "setTextSize", "setUnfinishedStrokeColor", "setUnfinishedStrokeWidth", "Companion", "library_release"})
public final class DonutProgress
extends View {
    private Paint finishedPaint;
    private Paint unfinishedPaint;
    private Paint innerCirclePaint;
    @Nullable
    private Paint textPaint;
    @Nullable
    private Paint innerBottomTextPaint;
    private final RectF finishedOuterRect;
    private final RectF unfinishedOuterRect;
    private int attributeResourceId;
    private Bitmap bitmap;
    private boolean isShowText;
    private float textSize;
    private int textColor;
    private int innerBottomTextColor;
    private float progress;
    private int max;
    private int finishedStrokeColor;
    private int unfinishedStrokeColor;
    private int startingDegree;
    private float finishedStrokeWidth;
    private float unfinishedStrokeWidth;
    private int innerBackgroundColor;
    private String prefixText;
    private String suffixText;
    private String text;
    private float innerBottomTextSize;
    private String innerBottomText;
    private float innerBottomTextHeight;
    private final float default_stroke_width;
    private final int default_finished_color;
    private final int default_unfinished_color;
    private final int default_text_color;
    private final int default_inner_bottom_text_color;
    private final int default_inner_background_color;
    private final int default_max;
    private final int default_startingDegree;
    private final float default_text_size;
    private final float default_inner_bottom_text_size;
    private final int min_size;
    private final boolean clockWise;
    private static final String INSTANCE_STATE = "saved_instance";
    private static final String INSTANCE_TEXT_COLOR = "text_color";
    private static final String INSTANCE_TEXT_SIZE = "text_size";
    private static final String INSTANCE_TEXT = "text";
    private static final String INSTANCE_INNER_BOTTOM_TEXT_SIZE = "inner_bottom_text_size";
    private static final String INSTANCE_INNER_BOTTOM_TEXT = "inner_bottom_text";
    private static final String INSTANCE_INNER_BOTTOM_TEXT_COLOR = "inner_bottom_text_color";
    private static final String INSTANCE_FINISHED_STROKE_COLOR = "finished_stroke_color";
    private static final String INSTANCE_UNFINISHED_STROKE_COLOR = "unfinished_stroke_color";
    private static final String INSTANCE_MAX = "max";
    private static final String INSTANCE_PROGRESS = "progress";
    private static final String INSTANCE_SUFFIX = "suffix";
    private static final String INSTANCE_PREFIX = "prefix";
    private static final String INSTANCE_FINISHED_STROKE_WIDTH = "finished_stroke_width";
    private static final String INSTANCE_UNFINISHED_STROKE_WIDTH = "unfinished_stroke_width";
    private static final String INSTANCE_BACKGROUND_COLOR = "inner_background_color";
    private static final String INSTANCE_STARTING_DEGREE = "starting_degree";
    private static final String INSTANCE_INNER_DRAWABLE = "inner_drawable";
    public static final Companion Companion = new Companion(null);

    @Nullable
    protected final Paint getTextPaint() {
        return this.textPaint;
    }

    protected final void setTextPaint(@Nullable Paint paint) {
        this.textPaint = paint;
    }

    @Nullable
    protected final Paint getInnerBottomTextPaint() {
        return this.innerBottomTextPaint;
    }

    protected final void setInnerBottomTextPaint(@Nullable Paint paint) {
        this.innerBottomTextPaint = paint;
    }

    public final boolean isShowText() {
        return this.isShowText;
    }

    public final void setShowText(boolean bl) {
        this.isShowText = bl;
    }

    protected final void initPainters() {
        if (this.isShowText) {
            Paint paint = this.textPaint = (Paint)new TextPaint();
            if (paint != null) {
                ((TextPaint)paint).setColor(this.textColor);
            }
            Paint paint2 = this.textPaint;
            if (paint2 != null) {
                ((TextPaint)paint2).setTextSize(this.textSize);
            }
            Paint paint3 = this.textPaint;
            if (paint3 != null) {
                ((TextPaint)paint3).setAntiAlias(true);
            }
            Paint paint4 = this.innerBottomTextPaint = (Paint)new TextPaint();
            if (paint4 != null) {
                ((TextPaint)paint4).setColor(this.innerBottomTextColor);
            }
            Paint paint5 = this.innerBottomTextPaint;
            if (paint5 != null) {
                ((TextPaint)paint5).setTextSize(this.innerBottomTextSize);
            }
            Paint paint6 = this.innerBottomTextPaint;
            if (paint6 != null) {
                ((TextPaint)paint6).setAntiAlias(true);
            }
        }
        Paint paint = this.finishedPaint = new Paint();
        Intrinsics.checkNotNull((Object)paint);
        paint.setColor(this.finishedStrokeColor);
        Paint paint7 = this.finishedPaint;
        Intrinsics.checkNotNull((Object)paint7);
        paint7.setStyle(Paint.Style.STROKE);
        Paint paint8 = this.finishedPaint;
        Intrinsics.checkNotNull((Object)paint8);
        paint8.setAntiAlias(true);
        Paint paint9 = this.finishedPaint;
        Intrinsics.checkNotNull((Object)paint9);
        paint9.setStrokeWidth(this.finishedStrokeWidth);
        Paint paint10 = this.unfinishedPaint = new Paint();
        Intrinsics.checkNotNull((Object)paint10);
        paint10.setColor(this.unfinishedStrokeColor);
        Paint paint11 = this.unfinishedPaint;
        Intrinsics.checkNotNull((Object)paint11);
        paint11.setStyle(Paint.Style.STROKE);
        Paint paint12 = this.unfinishedPaint;
        Intrinsics.checkNotNull((Object)paint12);
        paint12.setAntiAlias(true);
        Paint paint13 = this.unfinishedPaint;
        Intrinsics.checkNotNull((Object)paint13);
        paint13.setStrokeWidth(this.unfinishedStrokeWidth);
        Paint paint14 = this.innerCirclePaint = new Paint();
        Intrinsics.checkNotNull((Object)paint14);
        paint14.setColor(this.innerBackgroundColor);
        Paint paint15 = this.innerCirclePaint;
        Intrinsics.checkNotNull((Object)paint15);
        paint15.setAntiAlias(true);
    }

    protected final void initByAttributes(@NotNull TypedArray attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.finishedStrokeColor = attributes.getColor(R.styleable.DonutProgress_donut_finished_color, this.default_finished_color);
        this.unfinishedStrokeColor = attributes.getColor(R.styleable.DonutProgress_donut_unfinished_color, this.default_unfinished_color);
        this.isShowText = attributes.getBoolean(R.styleable.DonutProgress_donut_show_text, true);
        this.attributeResourceId = attributes.getResourceId(R.styleable.DonutProgress_donut_inner_drawable, 0);
        this.setMax(attributes.getInt(R.styleable.DonutProgress_donut_max, this.default_max));
        this.setProgress(attributes.getFloat(R.styleable.DonutProgress_donut_progress, 0.0f));
        this.finishedStrokeWidth = attributes.getDimension(R.styleable.DonutProgress_donut_finished_stroke_width, this.default_stroke_width);
        this.unfinishedStrokeWidth = attributes.getDimension(R.styleable.DonutProgress_donut_unfinished_stroke_width, this.default_stroke_width);
        if (this.isShowText) {
            if (attributes.getString(R.styleable.DonutProgress_donut_prefix_text) != null) {
                this.prefixText = String.valueOf(attributes.getString(R.styleable.DonutProgress_donut_prefix_text));
            }
            if (attributes.getString(R.styleable.DonutProgress_donut_suffix_text) != null) {
                this.suffixText = String.valueOf(attributes.getString(R.styleable.DonutProgress_donut_suffix_text));
            }
            if (attributes.getString(R.styleable.DonutProgress_donut_text) != null) {
                this.text = attributes.getString(R.styleable.DonutProgress_donut_text);
            }
            this.textColor = attributes.getColor(R.styleable.DonutProgress_donut_text_color, this.default_text_color);
            this.textSize = attributes.getDimension(R.styleable.DonutProgress_donut_text_size, this.default_text_size);
            this.innerBottomTextSize = attributes.getDimension(R.styleable.DonutProgress_donut_inner_bottom_text_size, this.default_inner_bottom_text_size);
            this.innerBottomTextColor = attributes.getColor(R.styleable.DonutProgress_donut_inner_bottom_text_color, this.default_inner_bottom_text_color);
            this.innerBottomText = attributes.getString(R.styleable.DonutProgress_donut_inner_bottom_text);
        }
        this.innerBottomTextSize = attributes.getDimension(R.styleable.DonutProgress_donut_inner_bottom_text_size, this.default_inner_bottom_text_size);
        this.innerBottomTextColor = attributes.getColor(R.styleable.DonutProgress_donut_inner_bottom_text_color, this.default_inner_bottom_text_color);
        this.innerBottomText = attributes.getString(R.styleable.DonutProgress_donut_inner_bottom_text);
        this.startingDegree = attributes.getInt(R.styleable.DonutProgress_donut_circle_starting_degree, this.default_startingDegree);
        this.innerBackgroundColor = attributes.getColor(R.styleable.DonutProgress_donut_background_color, this.default_inner_background_color);
    }

    protected final void initInnerBitmap(@Nullable Context context) {
        if (this.attributeResourceId != 0) {
            this.bitmap = Utils.INSTANCE.getBitmap(context, this.attributeResourceId);
        }
    }

    public static /* synthetic */ void initInnerBitmap$default(DonutProgress donutProgress, Context context, int n, Object object) {
        if ((n & 1) != 0) {
            context = donutProgress.getContext();
        }
        donutProgress.initInnerBitmap(context);
    }

    public void invalidate() {
        this.initPainters();
        super.invalidate();
    }

    public final float getFinishedStrokeWidth() {
        return this.finishedStrokeWidth;
    }

    public final void setFinishedStrokeWidth(float finishedStrokeWidth) {
        this.finishedStrokeWidth = finishedStrokeWidth;
        this.invalidate();
    }

    public final float getUnfinishedStrokeWidth() {
        return this.unfinishedStrokeWidth;
    }

    public final void setUnfinishedStrokeWidth(float unfinishedStrokeWidth) {
        this.unfinishedStrokeWidth = unfinishedStrokeWidth;
        this.invalidate();
    }

    private final float getProgressAngle() {
        return this.getProgress() / (float)this.max * 360.0f;
    }

    public final float getProgress() {
        return this.progress;
    }

    public final void setProgress(float progress) {
        this.progress = progress;
        if (this.progress > (float)this.getMax()) {
            this.progress %= (float)this.getMax();
        }
        this.invalidate();
    }

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int max) {
        if (max > 0) {
            this.max = max;
            this.invalidate();
        }
    }

    public final float getTextSize() {
        return this.textSize;
    }

    public final void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public final int getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(int textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    public final int getFinishedStrokeColor() {
        return this.finishedStrokeColor;
    }

    public final void setFinishedStrokeColor(int finishedStrokeColor) {
        this.finishedStrokeColor = finishedStrokeColor;
        this.invalidate();
    }

    public final int getUnfinishedStrokeColor() {
        return this.unfinishedStrokeColor;
    }

    public final void setUnfinishedStrokeColor(int unfinishedStrokeColor) {
        this.unfinishedStrokeColor = unfinishedStrokeColor;
        this.invalidate();
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String text) {
        this.text = text;
        this.invalidate();
    }

    @NotNull
    public final String getSuffixText() {
        return this.suffixText;
    }

    public final void setSuffixText(@NotNull String suffixText) {
        Intrinsics.checkNotNullParameter((Object)suffixText, (String)"suffixText");
        this.suffixText = suffixText;
        this.invalidate();
    }

    @NotNull
    public final String getPrefixText() {
        return this.prefixText;
    }

    public final void setPrefixText(@NotNull String prefixText) {
        Intrinsics.checkNotNullParameter((Object)prefixText, (String)"prefixText");
        this.prefixText = prefixText;
        this.invalidate();
    }

    public final int getInnerBackgroundColor() {
        return this.innerBackgroundColor;
    }

    public final void setInnerBackgroundColor(int innerBackgroundColor) {
        this.innerBackgroundColor = innerBackgroundColor;
        this.invalidate();
    }

    @Nullable
    public final String getInnerBottomText() {
        return this.innerBottomText;
    }

    public final void setInnerBottomText(@Nullable String innerBottomText) {
        this.innerBottomText = innerBottomText;
        this.invalidate();
    }

    public final float getInnerBottomTextSize() {
        return this.innerBottomTextSize;
    }

    public final void setInnerBottomTextSize(float innerBottomTextSize) {
        this.innerBottomTextSize = innerBottomTextSize;
        this.invalidate();
    }

    public final int getInnerBottomTextColor() {
        return this.innerBottomTextColor;
    }

    public final void setInnerBottomTextColor(int innerBottomTextColor) {
        this.innerBottomTextColor = innerBottomTextColor;
        this.invalidate();
    }

    public final int getStartingDegree() {
        return this.startingDegree;
    }

    public final void setStartingDegree(int startingDegree) {
        this.startingDegree = startingDegree;
        this.invalidate();
    }

    public final int getAttributeResourceId() {
        return this.attributeResourceId;
    }

    public final void setAttributeResourceId(int attributeResourceId) {
        this.attributeResourceId = attributeResourceId;
        DonutProgress.initInnerBitmap$default(this, null, 1, null);
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measure(widthMeasureSpec), this.measure(heightMeasureSpec));
        this.innerBottomTextHeight = this.getHeight() - this.getHeight() * 3 / 4;
    }

    private final int measure(int measureSpec) {
        int result = 0;
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int size = View.MeasureSpec.getSize((int)measureSpec);
        if (mode == 0x40000000) {
            result = size;
        } else {
            result = this.min_size;
            if (mode == Integer.MIN_VALUE) {
                result = Math.min(result, size);
            }
        }
        return result;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        float delta = Math.max(this.finishedStrokeWidth, this.unfinishedStrokeWidth);
        this.finishedOuterRect.set(delta, delta, (float)this.getWidth() - delta, (float)this.getHeight() - delta);
        this.unfinishedOuterRect.set(delta, delta, (float)this.getWidth() - delta, (float)this.getHeight() - delta);
        float innerCircleRadius = ((float)this.getWidth() - Math.min(this.finishedStrokeWidth, this.unfinishedStrokeWidth) + Math.abs(this.finishedStrokeWidth - this.unfinishedStrokeWidth)) / 2.0f;
        Paint paint = this.innerCirclePaint;
        if (paint != null) {
            Paint paint2 = paint;
            boolean bl = false;
            boolean bl2 = false;
            Paint it = paint2;
            boolean bl3 = false;
            canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, innerCircleRadius, it);
        }
        float f = this.getStartingDegree();
        float f2 = this.getProgressAngle();
        Paint paint3 = this.finishedPaint;
        Intrinsics.checkNotNull((Object)paint3);
        canvas.drawArc(this.finishedOuterRect, f, f2, false, paint3);
        float f3 = (float)this.getStartingDegree() + this.getProgressAngle();
        float f4 = (float)360 - this.getProgressAngle();
        Paint paint4 = this.unfinishedPaint;
        Intrinsics.checkNotNull((Object)paint4);
        canvas.drawArc(this.unfinishedOuterRect, f3, f4, false, paint4);
        if (this.isShowText) {
            String text;
            String string = text = this.text != null ? this.text : this.prefixText + (int)this.progress + this.suffixText;
            if (!TextUtils.isEmpty((CharSequence)text)) {
                Paint paint5 = this.textPaint;
                Intrinsics.checkNotNull((Object)paint5);
                float f5 = paint5.descent();
                Paint paint6 = this.textPaint;
                Intrinsics.checkNotNull((Object)paint6);
                float textHeight = f5 + paint6.ascent();
                if (text != null) {
                    float f6 = this.getWidth();
                    Paint paint7 = this.textPaint;
                    Intrinsics.checkNotNull((Object)paint7);
                    float f7 = (f6 - paint7.measureText(text)) / 2.0f;
                    float f8 = ((float)this.getWidth() - textHeight) / 2.0f;
                    Paint paint8 = this.textPaint;
                    Intrinsics.checkNotNull((Object)paint8);
                    canvas.drawText(text, f7, f8, paint8);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)this.getInnerBottomText())) {
                Paint paint9 = this.innerBottomTextPaint;
                Intrinsics.checkNotNull((Object)paint9);
                paint9.setTextSize(this.innerBottomTextSize);
                float f9 = (float)this.getHeight() - this.innerBottomTextHeight;
                Paint paint10 = this.textPaint;
                Intrinsics.checkNotNull((Object)paint10);
                float f10 = paint10.descent();
                Paint paint11 = this.textPaint;
                Intrinsics.checkNotNull((Object)paint11);
                float bottomTextBaseline = f9 - (f10 + paint11.ascent()) / (float)2;
                String string2 = this.getInnerBottomText();
                if (string2 != null) {
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl4 = false;
                    String it = string3;
                    boolean bl5 = false;
                    float f11 = this.getWidth();
                    Paint paint12 = this.innerBottomTextPaint;
                    Intrinsics.checkNotNull((Object)paint12);
                    float f12 = (f11 - paint12.measureText(this.getInnerBottomText())) / 2.0f;
                    Paint paint13 = this.innerBottomTextPaint;
                    Intrinsics.checkNotNull((Object)paint13);
                    canvas.drawText(it, f12, bottomTextBaseline, paint13);
                }
            }
        }
        if (this.bitmap != null) {
            Bitmap bitmap = this.bitmap;
            Intrinsics.checkNotNull((Object)bitmap);
            int n = this.getWidth();
            Bitmap bitmap2 = this.bitmap;
            Intrinsics.checkNotNull((Object)bitmap2);
            float f13 = (float)(n - bitmap2.getWidth()) / 2.0f;
            int n2 = this.getHeight();
            Bitmap bitmap3 = this.bitmap;
            Intrinsics.checkNotNull((Object)bitmap3);
            canvas.drawBitmap(bitmap, f13, (float)(n2 - bitmap3.getHeight()) / 2.0f, null);
        }
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putInt(INSTANCE_TEXT_COLOR, this.getTextColor());
        bundle.putFloat(INSTANCE_TEXT_SIZE, this.getTextSize());
        bundle.putFloat(INSTANCE_INNER_BOTTOM_TEXT_SIZE, this.getInnerBottomTextSize());
        bundle.putFloat(INSTANCE_INNER_BOTTOM_TEXT_COLOR, (float)this.getInnerBottomTextColor());
        bundle.putString(INSTANCE_INNER_BOTTOM_TEXT, this.getInnerBottomText());
        bundle.putInt(INSTANCE_INNER_BOTTOM_TEXT_COLOR, this.getInnerBottomTextColor());
        bundle.putInt(INSTANCE_FINISHED_STROKE_COLOR, this.getFinishedStrokeColor());
        bundle.putInt(INSTANCE_UNFINISHED_STROKE_COLOR, this.getUnfinishedStrokeColor());
        bundle.putInt(INSTANCE_MAX, this.getMax());
        bundle.putInt(INSTANCE_STARTING_DEGREE, this.getStartingDegree());
        bundle.putFloat(INSTANCE_PROGRESS, this.getProgress());
        bundle.putString(INSTANCE_SUFFIX, this.getSuffixText());
        bundle.putString(INSTANCE_PREFIX, this.getPrefixText());
        bundle.putString(INSTANCE_TEXT, this.getText());
        bundle.putFloat(INSTANCE_FINISHED_STROKE_WIDTH, this.getFinishedStrokeWidth());
        bundle.putFloat(INSTANCE_UNFINISHED_STROKE_WIDTH, this.getUnfinishedStrokeWidth());
        bundle.putInt(INSTANCE_BACKGROUND_COLOR, this.getInnerBackgroundColor());
        bundle.putInt(INSTANCE_INNER_DRAWABLE, this.getAttributeResourceId());
        return (Parcelable)bundle;
    }

    protected void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state instanceof Bundle) {
            Parcelable bundle = state;
            this.textColor = ((Bundle)bundle).getInt(INSTANCE_TEXT_COLOR);
            this.textSize = ((Bundle)bundle).getFloat(INSTANCE_TEXT_SIZE);
            this.innerBottomTextSize = ((Bundle)bundle).getFloat(INSTANCE_INNER_BOTTOM_TEXT_SIZE);
            this.innerBottomText = ((Bundle)bundle).getString(INSTANCE_INNER_BOTTOM_TEXT);
            this.innerBottomTextColor = ((Bundle)bundle).getInt(INSTANCE_INNER_BOTTOM_TEXT_COLOR);
            this.finishedStrokeColor = ((Bundle)bundle).getInt(INSTANCE_FINISHED_STROKE_COLOR);
            this.unfinishedStrokeColor = ((Bundle)bundle).getInt(INSTANCE_UNFINISHED_STROKE_COLOR);
            this.finishedStrokeWidth = ((Bundle)bundle).getFloat(INSTANCE_FINISHED_STROKE_WIDTH);
            this.unfinishedStrokeWidth = ((Bundle)bundle).getFloat(INSTANCE_UNFINISHED_STROKE_WIDTH);
            this.innerBackgroundColor = ((Bundle)bundle).getInt(INSTANCE_BACKGROUND_COLOR);
            this.attributeResourceId = ((Bundle)bundle).getInt(INSTANCE_INNER_DRAWABLE);
            DonutProgress.initInnerBitmap$default(this, null, 1, null);
            this.initPainters();
            this.setMax(((Bundle)bundle).getInt(INSTANCE_MAX));
            this.setStartingDegree(((Bundle)bundle).getInt(INSTANCE_STARTING_DEGREE));
            this.setProgress(((Bundle)bundle).getFloat(INSTANCE_PROGRESS));
            this.prefixText = String.valueOf(((Bundle)bundle).getString(INSTANCE_PREFIX));
            this.suffixText = String.valueOf(((Bundle)bundle).getString(INSTANCE_SUFFIX));
            this.text = ((Bundle)bundle).getString(INSTANCE_TEXT);
            super.onRestoreInstanceState(((Bundle)bundle).getParcelable(INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public final void setDonut_progress(@NotNull String percent) {
        Intrinsics.checkNotNullParameter((Object)percent, (String)"percent");
        if (!TextUtils.isEmpty((CharSequence)percent)) {
            String string = percent;
            boolean bl = false;
            this.setProgress(Integer.parseInt(string));
        }
    }

    @JvmOverloads
    public DonutProgress(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.finishedOuterRect = new RectF();
        this.unfinishedOuterRect = new RectF();
        this.prefixText = "";
        this.suffixText = "%";
        this.default_finished_color = Color.rgb((int)66, (int)145, (int)241);
        this.default_unfinished_color = Color.rgb((int)204, (int)204, (int)204);
        this.default_text_color = Color.rgb((int)66, (int)145, (int)241);
        this.default_inner_bottom_text_color = Color.rgb((int)66, (int)145, (int)241);
        this.default_max = 100;
        Resources resources = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        this.default_text_size = Utils.INSTANCE.sp2px(resources, 18.0f);
        Resources resources2 = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"resources");
        this.min_size = (int)Utils.INSTANCE.dp2px(resources2, 100.0f);
        Resources resources3 = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources3, (String)"resources");
        this.default_stroke_width = Utils.INSTANCE.dp2px(resources3, 10.0f);
        Resources resources4 = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources4, (String)"resources");
        this.default_inner_bottom_text_size = Utils.INSTANCE.sp2px(resources4, 18.0f);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DonutProgress, defStyleAttr, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme\n          \u2026rogress, defStyleAttr, 0)");
        TypedArray attributes = typedArray;
        this.initByAttributes(attributes);
        attributes.recycle();
        this.initInnerBitmap(context);
        this.initPainters();
    }

    public /* synthetic */ DonutProgress(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public DonutProgress(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public DonutProgress(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/lzyzsd/circleprogresskt/DonutProgress$Companion;", "", "()V", "INSTANCE_BACKGROUND_COLOR", "", "INSTANCE_FINISHED_STROKE_COLOR", "INSTANCE_FINISHED_STROKE_WIDTH", "INSTANCE_INNER_BOTTOM_TEXT", "INSTANCE_INNER_BOTTOM_TEXT_COLOR", "INSTANCE_INNER_BOTTOM_TEXT_SIZE", "INSTANCE_INNER_DRAWABLE", "INSTANCE_MAX", "INSTANCE_PREFIX", "INSTANCE_PROGRESS", "INSTANCE_STARTING_DEGREE", "INSTANCE_STATE", "INSTANCE_SUFFIX", "INSTANCE_TEXT", "INSTANCE_TEXT_COLOR", "INSTANCE_TEXT_SIZE", "INSTANCE_UNFINISHED_STROKE_COLOR", "INSTANCE_UNFINISHED_STROKE_WIDTH", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

