/*
 * Decompiled with CFR 0.152.
 */
package com.github.lzyzsd.circleprogresskt;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.github.lzyzsd.circleprogresskt.R;
import com.github.lzyzsd.circleprogresskt.Utils;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 L2\u00020\u0001:\u0001LB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010)\u001a\u00020\u0007J\u0006\u0010*\u001a\u00020\u0010J\u0006\u0010+\u001a\u00020\u0007J\u0006\u0010,\u001a\u00020\u0010J\b\u0010-\u001a\u00020\u0007H\u0014J\b\u0010.\u001a\u00020\u0007H\u0014J\u0006\u0010/\u001a\u00020\u0010J\u0006\u00100\u001a\u00020\u0007J\u0006\u00101\u001a\u00020\rJ\u0006\u00102\u001a\u00020\u0007J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0004J\b\u00107\u001a\u000204H\u0004J\b\u00108\u001a\u000204H\u0016J\u0010\u00109\u001a\u0002042\u0006\u0010:\u001a\u00020;H\u0014J\u0018\u0010<\u001a\u0002042\u0006\u0010=\u001a\u00020\u00072\u0006\u0010>\u001a\u00020\u0007H\u0014J\u0010\u0010?\u001a\u0002042\u0006\u0010@\u001a\u00020AH\u0014J\b\u0010B\u001a\u00020AH\u0014J\u0006\u0010C\u001a\u000204J\u000e\u0010D\u001a\u0002042\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010E\u001a\u0002042\u0006\u0010\u001c\u001a\u00020\u0010J\u000e\u0010F\u001a\u0002042\u0006\u0010\u001d\u001a\u00020\u0007J\u000e\u0010G\u001a\u0002042\u0006\u0010#\u001a\u00020\u0010J\u0010\u0010H\u001a\u0002042\b\u0010$\u001a\u0004\u0018\u00010\u0010J\u000e\u0010I\u001a\u0002042\u0006\u0010%\u001a\u00020\u0007J\u000e\u0010J\u001a\u0002042\u0006\u0010'\u001a\u00020\rJ\u000e\u0010K\u001a\u0002042\u0006\u0010(\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/github/lzyzsd/circleprogresskt/CircleProgress;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "default_finished_color", "default_max", "default_text_color", "default_text_size", "", "default_unfinished_color", "drawText", "", "getDrawText", "()Ljava/lang/String;", "finishedColor", "max", "getMax", "()I", "setMax", "(I)V", "min_size", "paint", "Landroid/graphics/Paint;", "prefixText", "progress", "progressPercentage", "getProgressPercentage", "()F", "rectF", "Landroid/graphics/RectF;", "suffixText", "text", "textColor", "textPaint", "textSize", "unfinishedColor", "getFinishedColor", "getPrefixText", "getProgress", "getSuffixText", "getSuggestedMinimumHeight", "getSuggestedMinimumWidth", "getText", "getTextColor", "getTextSize", "getUnfinishedColor", "initByAttributes", "", "attributes", "Landroid/content/res/TypedArray;", "initPainters", "invalidate", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "setDefaultText", "setFinishedColor", "setPrefixText", "setProgress", "setSuffixText", "setText", "setTextColor", "setTextSize", "setUnfinishedColor", "Companion", "library_release"})
public final class CircleProgress
extends View {
    private Paint textPaint;
    private final RectF rectF;
    private float textSize;
    private int textColor;
    private int progress;
    private String text;
    private int max;
    private int finishedColor;
    private int unfinishedColor;
    private String prefixText;
    private String suffixText;
    private final int default_finished_color;
    private final int default_unfinished_color;
    private final int default_text_color;
    private final int default_max;
    private final float default_text_size;
    private final int min_size;
    private final Paint paint;
    private static final String INSTANCE_STATE = "saved_instance";
    private static final String INSTANCE_TEXT_COLOR = "text_color";
    private static final String INSTANCE_TEXT_SIZE = "text_size";
    private static final String INSTANCE_FINISHED_STROKE_COLOR = "finished_stroke_color";
    private static final String INSTANCE_UNFINISHED_STROKE_COLOR = "unfinished_stroke_color";
    private static final String INSTANCE_MAX = "max";
    private static final String INSTANCE_PROGRESS = "progress";
    private static final String INSTANCE_SUFFIX = "suffix";
    private static final String INSTANCE_PREFIX = "prefix";
    public static final Companion Companion = new Companion(null);

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int max) {
        if (max > 0) {
            this.max = max;
            this.invalidate();
        }
    }

    protected final void initByAttributes(@NotNull TypedArray attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.finishedColor = attributes.getColor(R.styleable.CircleProgress_circle_finished_color, this.default_finished_color);
        this.unfinishedColor = attributes.getColor(R.styleable.CircleProgress_circle_unfinished_color, this.default_unfinished_color);
        this.textColor = attributes.getColor(R.styleable.CircleProgress_circle_text_color, this.default_text_color);
        this.textSize = attributes.getDimension(R.styleable.CircleProgress_circle_text_size, this.default_text_size);
        this.setMax(attributes.getInt(R.styleable.CircleProgress_circle_max, this.default_max));
        this.setProgress(attributes.getInt(R.styleable.CircleProgress_circle_progress, 0));
        if (attributes.getString(R.styleable.CircleProgress_circle_prefix_text) != null) {
            String string = attributes.getString(R.styleable.CircleProgress_circle_prefix_text);
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attributes.getString(R.s\u2026ess_circle_prefix_text)!!");
            this.setPrefixText(string);
        }
        if (attributes.getString(R.styleable.CircleProgress_circle_suffix_text) != null) {
            String string = attributes.getString(R.styleable.CircleProgress_circle_suffix_text);
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attributes.getString(R.s\u2026ess_circle_suffix_text)!!");
            this.setSuffixText(string);
        }
    }

    protected final void initPainters() {
        Paint paint = this.textPaint = (Paint)new TextPaint();
        if (paint != null) {
            ((TextPaint)paint).setColor(this.textColor);
        }
        Paint paint2 = this.textPaint;
        if (paint2 != null) {
            ((TextPaint)paint2).setTextSize(this.textSize);
        }
        Paint paint3 = this.textPaint;
        if (paint3 != null) {
            ((TextPaint)paint3).setAntiAlias(true);
        }
        this.paint.setAntiAlias(true);
    }

    public void invalidate() {
        this.initPainters();
        super.invalidate();
    }

    public final int getProgress() {
        return this.progress;
    }

    public final void setProgress(int progress) {
        this.progress = progress;
        if (this.progress > this.max) {
            this.progress %= this.max;
        }
        this.invalidate();
    }

    public final void setDefaultText() {
        this.text = null;
        this.invalidate();
    }

    public final void setText(@Nullable String text) {
        this.text = text;
        this.invalidate();
    }

    @NotNull
    public final String getText() {
        String string = this.text;
        if (string == null) {
            string = String.valueOf(this.progress);
        }
        return string;
    }

    public final float getTextSize() {
        return this.textSize;
    }

    public final void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public final int getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(int textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    public final int getFinishedColor() {
        return this.finishedColor;
    }

    public final void setFinishedColor(int finishedColor) {
        this.finishedColor = finishedColor;
        this.invalidate();
    }

    public final int getUnfinishedColor() {
        return this.unfinishedColor;
    }

    public final void setUnfinishedColor(int unfinishedColor) {
        this.unfinishedColor = unfinishedColor;
        this.invalidate();
    }

    @NotNull
    public final String getPrefixText() {
        return this.prefixText;
    }

    public final void setPrefixText(@NotNull String prefixText) {
        Intrinsics.checkNotNullParameter((Object)prefixText, (String)"prefixText");
        this.prefixText = prefixText;
        this.invalidate();
    }

    @NotNull
    public final String getSuffixText() {
        return this.suffixText;
    }

    public final void setSuffixText(@NotNull String suffixText) {
        Intrinsics.checkNotNullParameter((Object)suffixText, (String)"suffixText");
        this.suffixText = suffixText;
        this.invalidate();
    }

    @NotNull
    public final String getDrawText() {
        return this.getPrefixText() + this.getText() + this.getSuffixText();
    }

    protected int getSuggestedMinimumHeight() {
        return this.min_size;
    }

    protected int getSuggestedMinimumWidth() {
        return this.min_size;
    }

    public final float getProgressPercentage() {
        return (float)this.getProgress() / (float)this.max;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.rectF.set(0.0f, 0.0f, (float)View.MeasureSpec.getSize((int)widthMeasureSpec), (float)View.MeasureSpec.getSize((int)heightMeasureSpec));
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        float yHeight = (float)this.getProgress() / (float)this.max * (float)this.getHeight();
        float radius = (float)this.getWidth() / 2.0f;
        float angle = (float)(Math.acos((radius - yHeight) / radius) * (double)180 / Math.PI);
        float startAngle = (float)90 + angle;
        float sweepAngle = (float)360 - angle * (float)2;
        this.paint.setColor(this.getUnfinishedColor());
        canvas.drawArc(this.rectF, startAngle, sweepAngle, false, this.paint);
        canvas.save();
        canvas.rotate(180.0f, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        this.paint.setColor(this.getFinishedColor());
        canvas.drawArc(this.rectF, (float)270 - angle, angle * (float)2, false, this.paint);
        canvas.restore();
        String text = this.getDrawText();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            Paint paint = this.textPaint;
            Intrinsics.checkNotNull((Object)paint);
            float f = paint.descent();
            Paint paint2 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint2);
            float textHeight = f + paint2.ascent();
            float f2 = this.getWidth();
            Paint paint3 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint3);
            float f3 = (f2 - paint3.measureText(text)) / 2.0f;
            float f4 = ((float)this.getWidth() - textHeight) / 2.0f;
            Paint paint4 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint4);
            canvas.drawText(text, f3, f4, paint4);
        }
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putInt(INSTANCE_TEXT_COLOR, this.getTextColor());
        bundle.putFloat(INSTANCE_TEXT_SIZE, this.getTextSize());
        bundle.putInt(INSTANCE_FINISHED_STROKE_COLOR, this.getFinishedColor());
        bundle.putInt(INSTANCE_UNFINISHED_STROKE_COLOR, this.getUnfinishedColor());
        bundle.putInt(INSTANCE_MAX, this.max);
        bundle.putInt(INSTANCE_PROGRESS, this.getProgress());
        bundle.putString(INSTANCE_SUFFIX, this.getSuffixText());
        bundle.putString(INSTANCE_PREFIX, this.getPrefixText());
        return (Parcelable)bundle;
    }

    protected void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state instanceof Bundle) {
            Parcelable bundle = state;
            this.textColor = ((Bundle)bundle).getInt(INSTANCE_TEXT_COLOR);
            this.textSize = ((Bundle)bundle).getFloat(INSTANCE_TEXT_SIZE);
            this.finishedColor = ((Bundle)bundle).getInt(INSTANCE_FINISHED_STROKE_COLOR);
            this.unfinishedColor = ((Bundle)bundle).getInt(INSTANCE_UNFINISHED_STROKE_COLOR);
            this.initPainters();
            this.setMax(((Bundle)bundle).getInt(INSTANCE_MAX));
            this.setProgress(((Bundle)bundle).getInt(INSTANCE_PROGRESS));
            this.prefixText = String.valueOf(((Bundle)bundle).getString(INSTANCE_PREFIX));
            this.suffixText = String.valueOf(((Bundle)bundle).getString(INSTANCE_SUFFIX));
            super.onRestoreInstanceState(((Bundle)bundle).getParcelable(INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    @JvmOverloads
    public CircleProgress(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.rectF = new RectF();
        this.prefixText = "";
        this.suffixText = "%";
        this.default_finished_color = Color.rgb((int)66, (int)145, (int)241);
        this.default_unfinished_color = Color.rgb((int)204, (int)204, (int)204);
        this.default_text_color = -1;
        this.default_max = 100;
        this.paint = new Paint();
        Resources resources = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        this.default_text_size = Utils.INSTANCE.sp2px(resources, 18.0f);
        Resources resources2 = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"resources");
        this.min_size = (int)Utils.INSTANCE.dp2px(resources2, 100.0f);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CircleProgress, defStyleAttr, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026rogress, defStyleAttr, 0)");
        TypedArray attributes = typedArray;
        this.initByAttributes(attributes);
        attributes.recycle();
        this.initPainters();
    }

    public /* synthetic */ CircleProgress(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CircleProgress(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CircleProgress(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/lzyzsd/circleprogresskt/CircleProgress$Companion;", "", "()V", "INSTANCE_FINISHED_STROKE_COLOR", "", "INSTANCE_MAX", "INSTANCE_PREFIX", "INSTANCE_PROGRESS", "INSTANCE_STATE", "INSTANCE_SUFFIX", "INSTANCE_TEXT_COLOR", "INSTANCE_TEXT_SIZE", "INSTANCE_UNFINISHED_STROKE_COLOR", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

