/*
 * Decompiled with CFR 0.152.
 */
package com.github.lzyzsd.circleprogresskt;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.content.res.ResourcesCompat;
import com.github.lzyzsd.circleprogresskt.R;
import com.github.lzyzsd.circleprogresskt.Utils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 e2\u00020\u0001:\u0001eB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u00107\u001a\u00020\nJ\b\u00108\u001a\u0004\u0018\u00010\rJ\u0006\u00109\u001a\u00020\nJ\u0006\u0010:\u001a\u00020\u0007J\u0006\u0010;\u001a\u00020\nJ\u0006\u0010<\u001a\u00020\nJ\u0006\u0010=\u001a\u00020\rJ\u0006\u0010>\u001a\u00020\nJ\u0006\u0010?\u001a\u00020\nJ\b\u0010@\u001a\u00020\u0007H\u0014J\b\u0010A\u001a\u00020\u0007H\u0014J\b\u0010B\u001a\u0004\u0018\u00010\rJ\u0006\u0010C\u001a\u00020\u0007J\u0006\u0010D\u001a\u00020\nJ\u0006\u0010E\u001a\u00020\u0007J\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0004J\b\u0010J\u001a\u00020GH\u0004J\u0010\u0010K\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0002J\b\u0010L\u001a\u00020GH\u0016J\u0010\u0010M\u001a\u00020G2\u0006\u0010N\u001a\u00020OH\u0014J\u0018\u0010P\u001a\u00020G2\u0006\u0010Q\u001a\u00020\u00072\u0006\u0010R\u001a\u00020\u0007H\u0014J\u0010\u0010S\u001a\u00020G2\u0006\u0010T\u001a\u00020UH\u0014J\b\u0010V\u001a\u00020UH\u0014J\u000e\u0010W\u001a\u00020G2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010X\u001a\u00020G2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010Y\u001a\u00020G2\u0006\u0010\u000e\u001a\u00020\nJ\u0006\u0010Z\u001a\u00020GJ\u000e\u0010[\u001a\u00020G2\u0006\u0010\u001b\u001a\u00020\u0007J\u000e\u0010\\\u001a\u00020G2\u0006\u0010%\u001a\u00020\nJ\u000e\u0010]\u001a\u00020G2\u0006\u0010(\u001a\u00020\nJ\u000e\u0010^\u001a\u00020G2\u0006\u0010)\u001a\u00020\rJ\u000e\u0010_\u001a\u00020G2\u0006\u0010*\u001a\u00020\nJ\u000e\u0010`\u001a\u00020G2\u0006\u0010+\u001a\u00020\nJ\u0010\u0010a\u001a\u00020G2\b\u0010,\u001a\u0004\u0018\u00010\rJ\u000e\u0010b\u001a\u00020G2\u0006\u0010-\u001a\u00020\u0007J\u000e\u0010c\u001a\u00020G2\u0006\u00103\u001a\u00020\nJ\u000e\u0010d\u001a\u00020G2\u0006\u00106\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010.\u001a\u0004\u0018\u00010$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u00103\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lcom/github/lzyzsd/circleprogresskt/ArcProgress;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "arcAngle", "", "arcBottomHeight", "bottomText", "", "bottomTextSize", "currentProgress", "default_arc_angle", "default_bottom_text_size", "default_finished_color", "default_max", "default_stroke_width", "default_suffix_padding", "default_suffix_text", "default_suffix_text_size", "default_text_color", "default_text_size", "default_unfinished_color", "finishedStrokeColor", "fontResourceId", "max", "getMax", "()I", "setMax", "(I)V", "min_size", "paint", "Landroid/graphics/Paint;", "progress", "rectF", "Landroid/graphics/RectF;", "strokeWidth", "suffixText", "suffixTextPadding", "suffixTextSize", "text", "textColor", "textPaint", "getTextPaint", "()Landroid/graphics/Paint;", "setTextPaint", "(Landroid/graphics/Paint;)V", "textSize", "typeFace", "Landroid/graphics/Typeface;", "unfinishedStrokeColor", "getArcAngle", "getBottomText", "getBottomTextSize", "getFinishedStrokeColor", "getProgress", "getStrokeWidth", "getSuffixText", "getSuffixTextPadding", "getSuffixTextSize", "getSuggestedMinimumHeight", "getSuggestedMinimumWidth", "getText", "getTextColor", "getTextSize", "getUnfinishedStrokeColor", "initByAttributes", "", "attributes", "Landroid/content/res/TypedArray;", "initPainters", "initTypeFace", "invalidate", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "setArcAngle", "setBottomText", "setBottomTextSize", "setDefaultText", "setFinishedStrokeColor", "setProgress", "setStrokeWidth", "setSuffixText", "setSuffixTextPadding", "setSuffixTextSize", "setText", "setTextColor", "setTextSize", "setUnfinishedStrokeColor", "Companion", "library_release"})
public final class ArcProgress
extends View {
    private Paint paint;
    @Nullable
    private Paint textPaint;
    private final RectF rectF;
    private float strokeWidth;
    private float suffixTextSize;
    private float bottomTextSize;
    private String bottomText;
    private String text;
    private float textSize;
    private int textColor;
    private int currentProgress;
    private float progress;
    private int max;
    private int finishedStrokeColor;
    private int unfinishedStrokeColor;
    private float arcAngle;
    private String suffixText;
    private float suffixTextPadding;
    private Typeface typeFace;
    private final int fontResourceId;
    private float arcBottomHeight;
    private final int default_finished_color;
    private final int default_unfinished_color;
    private final int default_text_color;
    private final float default_suffix_text_size;
    private final float default_suffix_padding;
    private final float default_bottom_text_size;
    private final float default_stroke_width;
    private final String default_suffix_text;
    private final int default_max;
    private final float default_arc_angle;
    private float default_text_size;
    private final int min_size;
    private static final String INSTANCE_STATE = "saved_instance";
    private static final String INSTANCE_STROKE_WIDTH = "stroke_width";
    private static final String INSTANCE_SUFFIX_TEXT_SIZE = "suffix_text_size";
    private static final String INSTANCE_SUFFIX_TEXT_PADDING = "suffix_text_padding";
    private static final String INSTANCE_BOTTOM_TEXT_SIZE = "bottom_text_size";
    private static final String INSTANCE_BOTTOM_TEXT = "bottom_text";
    private static final String INSTANCE_TEXT_SIZE = "text_size";
    private static final String INSTANCE_TEXT_COLOR = "text_color";
    private static final String INSTANCE_PROGRESS = "progress";
    private static final String INSTANCE_MAX = "max";
    private static final String INSTANCE_FINISHED_STROKE_COLOR = "finished_stroke_color";
    private static final String INSTANCE_UNFINISHED_STROKE_COLOR = "unfinished_stroke_color";
    private static final String INSTANCE_ARC_ANGLE = "arc_angle";
    private static final String INSTANCE_SUFFIX = "suffix";
    public static final Companion Companion = new Companion(null);

    @Nullable
    protected final Paint getTextPaint() {
        return this.textPaint;
    }

    protected final void setTextPaint(@Nullable Paint paint) {
        this.textPaint = paint;
    }

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int max) {
        if (max > 0) {
            this.max = max;
            this.invalidate();
        }
    }

    protected final void initByAttributes(@NotNull TypedArray attributes) {
        String string;
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.finishedStrokeColor = attributes.getColor(R.styleable.ArcProgress_arc_finished_color, this.default_finished_color);
        this.unfinishedStrokeColor = attributes.getColor(R.styleable.ArcProgress_arc_unfinished_color, this.default_unfinished_color);
        this.textColor = attributes.getColor(R.styleable.ArcProgress_arc_text_color, this.default_text_color);
        this.textSize = attributes.getDimension(R.styleable.ArcProgress_arc_text_size, this.default_text_size);
        this.arcAngle = attributes.getFloat(R.styleable.ArcProgress_arc_angle, this.default_arc_angle);
        this.setMax(attributes.getInt(R.styleable.ArcProgress_arc_max, this.default_max));
        this.setProgress(attributes.getFloat(R.styleable.ArcProgress_arc_progress, 0.0f));
        this.strokeWidth = attributes.getDimension(R.styleable.ArcProgress_arc_stroke_width, this.default_stroke_width);
        this.suffixTextSize = attributes.getDimension(R.styleable.ArcProgress_arc_suffix_text_size, this.default_suffix_text_size);
        if (TextUtils.isEmpty((CharSequence)attributes.getString(R.styleable.ArcProgress_arc_suffix_text))) {
            string = this.default_suffix_text;
        } else {
            String string2 = attributes.getString(R.styleable.ArcProgress_arc_suffix_text);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attributes.getString(\n  \u2026ffix_text\n            )!!");
        }
        this.suffixText = string;
        this.suffixTextPadding = attributes.getDimension(R.styleable.ArcProgress_arc_suffix_text_padding, this.default_suffix_padding);
        this.bottomTextSize = attributes.getDimension(R.styleable.ArcProgress_arc_bottom_text_size, this.default_bottom_text_size);
        this.bottomText = attributes.getString(R.styleable.ArcProgress_arc_bottom_text);
        this.initTypeFace(attributes);
    }

    private final void initTypeFace(TypedArray attributes) {
        if (Build.VERSION.SDK_INT < 26) {
            int fontId = attributes.getResourceId(R.styleable.ArcProgress_arc_suffix_text_font, 0);
            if (fontId != 0) {
                try {
                    this.typeFace = ResourcesCompat.getFont((Context)this.getContext(), (int)fontId);
                }
                catch (Exception e) {
                }
            }
        } else {
            this.typeFace = attributes.getFont(R.styleable.ArcProgress_arc_suffix_text_font);
        }
    }

    protected final void initPainters() {
        Paint paint = this.textPaint = (Paint)new TextPaint();
        if (paint != null) {
            ((TextPaint)paint).setColor(this.textColor);
        }
        Paint paint2 = this.textPaint;
        if (paint2 != null) {
            ((TextPaint)paint2).setTextSize(this.textSize);
        }
        Paint paint3 = this.textPaint;
        if (paint3 != null) {
            ((TextPaint)paint3).setAntiAlias(true);
        }
        Paint paint4 = this.paint = new Paint();
        Intrinsics.checkNotNull((Object)paint4);
        paint4.setColor(this.default_unfinished_color);
        Paint paint5 = this.paint;
        Intrinsics.checkNotNull((Object)paint5);
        paint5.setAntiAlias(true);
        Paint paint6 = this.paint;
        Intrinsics.checkNotNull((Object)paint6);
        paint6.setStrokeWidth(this.strokeWidth);
        Paint paint7 = this.paint;
        Intrinsics.checkNotNull((Object)paint7);
        paint7.setStyle(Paint.Style.STROKE);
        Paint paint8 = this.paint;
        Intrinsics.checkNotNull((Object)paint8);
        paint8.setStrokeCap(Paint.Cap.ROUND);
    }

    public void invalidate() {
        this.initPainters();
        super.invalidate();
    }

    public final float getStrokeWidth() {
        return this.strokeWidth;
    }

    public final void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.invalidate();
    }

    public final float getSuffixTextSize() {
        return this.suffixTextSize;
    }

    public final void setSuffixTextSize(float suffixTextSize) {
        this.suffixTextSize = suffixTextSize;
        this.invalidate();
    }

    @Nullable
    public final String getBottomText() {
        return this.bottomText;
    }

    public final void setBottomText(@Nullable String bottomText) {
        this.bottomText = bottomText;
        this.invalidate();
    }

    public final float getProgress() {
        return this.progress;
    }

    public final void setProgress(float progress) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        String string = new DecimalFormat("#.##", dfs).format(progress);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DecimalFormat(\"#.##\", df\u2026rmat(progress.toDouble())");
        String string2 = string;
        boolean bl = false;
        this.progress = Float.parseFloat(string2);
        if (this.progress > (float)this.max) {
            this.progress %= (float)this.max;
        }
        this.currentProgress = 0;
        this.invalidate();
    }

    public final float getBottomTextSize() {
        return this.bottomTextSize;
    }

    public final void setBottomTextSize(float bottomTextSize) {
        this.bottomTextSize = bottomTextSize;
        this.invalidate();
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String text) {
        this.text = text;
        this.invalidate();
    }

    public final void setDefaultText() {
        this.text = String.valueOf(this.getProgress());
        this.invalidate();
    }

    public final float getTextSize() {
        return this.textSize;
    }

    public final void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public final int getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(int textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    public final int getFinishedStrokeColor() {
        return this.finishedStrokeColor;
    }

    public final void setFinishedStrokeColor(int finishedStrokeColor) {
        this.finishedStrokeColor = finishedStrokeColor;
        this.invalidate();
    }

    public final int getUnfinishedStrokeColor() {
        return this.unfinishedStrokeColor;
    }

    public final void setUnfinishedStrokeColor(int unfinishedStrokeColor) {
        this.unfinishedStrokeColor = unfinishedStrokeColor;
        this.invalidate();
    }

    public final float getArcAngle() {
        return this.arcAngle;
    }

    public final void setArcAngle(float arcAngle) {
        this.arcAngle = arcAngle;
        this.invalidate();
    }

    @NotNull
    public final String getSuffixText() {
        return this.suffixText;
    }

    public final void setSuffixText(@NotNull String suffixText) {
        Intrinsics.checkNotNullParameter((Object)suffixText, (String)"suffixText");
        this.suffixText = suffixText;
        this.invalidate();
    }

    public final float getSuffixTextPadding() {
        return this.suffixTextPadding;
    }

    public final void setSuffixTextPadding(float suffixTextPadding) {
        this.suffixTextPadding = suffixTextPadding;
        this.invalidate();
    }

    protected int getSuggestedMinimumHeight() {
        return this.min_size;
    }

    protected int getSuggestedMinimumWidth() {
        return this.min_size;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.rectF.set(this.strokeWidth / 2.0f, this.strokeWidth / 2.0f, (float)width - this.strokeWidth / 2.0f, (float)View.MeasureSpec.getSize((int)heightMeasureSpec) - this.strokeWidth / 2.0f);
        float radius = (float)width / 2.0f;
        float angle = ((float)360 - this.arcAngle) / 2.0f;
        this.arcBottomHeight = radius * (float)(1.0 - Math.cos((double)(angle / (float)180) * Math.PI));
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        float startAngle = (float)270 - this.arcAngle / 2.0f;
        float finishedSweepAngle = (float)this.currentProgress / (float)this.max * this.arcAngle;
        float finishedStartAngle = startAngle;
        if (this.progress == 0.0f) {
            finishedStartAngle = 0.01f;
        }
        Paint paint = this.paint;
        Intrinsics.checkNotNull((Object)paint);
        paint.setColor(this.unfinishedStrokeColor);
        Paint paint2 = this.paint;
        Intrinsics.checkNotNull((Object)paint2);
        canvas.drawArc(this.rectF, startAngle, this.arcAngle, false, paint2);
        Paint paint3 = this.paint;
        Intrinsics.checkNotNull((Object)paint3);
        paint3.setColor(this.finishedStrokeColor);
        Paint paint4 = this.paint;
        Intrinsics.checkNotNull((Object)paint4);
        canvas.drawArc(this.rectF, finishedStartAngle, finishedSweepAngle, false, paint4);
        String text = String.valueOf(this.currentProgress);
        if (this.typeFace != null) {
            Paint paint5 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint5);
            paint5.setTypeface(this.typeFace);
        }
        if (!TextUtils.isEmpty((CharSequence)text)) {
            Paint paint6 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint6);
            paint6.setColor(this.textColor);
            Paint paint7 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint7);
            paint7.setTextSize(this.textSize);
            Paint paint8 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint8);
            float f = paint8.descent();
            Paint paint9 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint9);
            float textHeight = f + paint9.ascent();
            float textBaseline = ((float)this.getHeight() - textHeight) / 2.0f;
            float f2 = this.getWidth();
            Paint paint10 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint10);
            float f3 = (f2 - paint10.measureText(text)) / 2.0f;
            Paint paint11 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint11);
            canvas.drawText(text, f3, textBaseline, paint11);
            Paint paint12 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint12);
            paint12.setTextSize(this.suffixTextSize);
            Paint paint13 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint13);
            float f4 = paint13.descent();
            Paint paint14 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint14);
            float suffixHeight = f4 + paint14.ascent();
            float f5 = (float)this.getWidth() / 2.0f;
            Paint paint15 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint15);
            float f6 = f5 + paint15.measureText(text) + this.suffixTextPadding;
            Paint paint16 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint16);
            canvas.drawText(this.suffixText, f6, textBaseline + textHeight - suffixHeight, paint16);
        }
        if (this.arcBottomHeight == 0.0f) {
            float radius = (float)this.getWidth() / 2.0f;
            float angle = ((float)360 - this.arcAngle) / 2.0f;
            this.arcBottomHeight = radius * (float)(1.0 - Math.cos((double)(angle / (float)180) * Math.PI));
        }
        if (!TextUtils.isEmpty((CharSequence)this.getBottomText())) {
            Paint paint17 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint17);
            paint17.setTextSize(this.bottomTextSize);
            float f = (float)this.getHeight() - this.arcBottomHeight;
            Paint paint18 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint18);
            float f7 = paint18.descent();
            Paint paint19 = this.textPaint;
            Intrinsics.checkNotNull((Object)paint19);
            float bottomTextBaseline = f - (f7 + paint19.ascent()) / (float)2;
            String string = this.getBottomText();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String $this$apply = string2;
                boolean bl3 = false;
                String string3 = this.getBottomText();
                Intrinsics.checkNotNull((Object)string3);
                float f8 = this.getWidth();
                Paint paint20 = this.textPaint;
                Intrinsics.checkNotNull((Object)paint20);
                float f9 = (f8 - paint20.measureText(this.getBottomText())) / 2.0f;
                Paint paint21 = this.textPaint;
                Intrinsics.checkNotNull((Object)paint21);
                canvas.drawText(string3, f9, bottomTextBaseline, paint21);
            }
        }
        if ((float)this.currentProgress < this.progress) {
            int n = this.currentProgress;
            this.currentProgress = n + 1;
            this.invalidate();
        }
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putFloat(INSTANCE_STROKE_WIDTH, this.getStrokeWidth());
        bundle.putFloat(INSTANCE_SUFFIX_TEXT_SIZE, this.getSuffixTextSize());
        bundle.putFloat(INSTANCE_SUFFIX_TEXT_PADDING, this.getSuffixTextPadding());
        bundle.putFloat(INSTANCE_BOTTOM_TEXT_SIZE, this.getBottomTextSize());
        bundle.putString(INSTANCE_BOTTOM_TEXT, this.getBottomText());
        bundle.putFloat(INSTANCE_TEXT_SIZE, this.getTextSize());
        bundle.putInt(INSTANCE_TEXT_COLOR, this.getTextColor());
        bundle.putFloat(INSTANCE_PROGRESS, this.getProgress());
        bundle.putInt(INSTANCE_MAX, this.max);
        bundle.putInt(INSTANCE_FINISHED_STROKE_COLOR, this.getFinishedStrokeColor());
        bundle.putInt(INSTANCE_UNFINISHED_STROKE_COLOR, this.getUnfinishedStrokeColor());
        bundle.putFloat(INSTANCE_ARC_ANGLE, this.getArcAngle());
        bundle.putString(INSTANCE_SUFFIX, this.getSuffixText());
        return (Parcelable)bundle;
    }

    protected void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state instanceof Bundle) {
            Parcelable bundle = state;
            this.strokeWidth = ((Bundle)bundle).getFloat(INSTANCE_STROKE_WIDTH);
            this.suffixTextSize = ((Bundle)bundle).getFloat(INSTANCE_SUFFIX_TEXT_SIZE);
            this.suffixTextPadding = ((Bundle)bundle).getFloat(INSTANCE_SUFFIX_TEXT_PADDING);
            this.bottomTextSize = ((Bundle)bundle).getFloat(INSTANCE_BOTTOM_TEXT_SIZE);
            this.bottomText = ((Bundle)bundle).getString(INSTANCE_BOTTOM_TEXT);
            this.textSize = ((Bundle)bundle).getFloat(INSTANCE_TEXT_SIZE);
            this.textColor = ((Bundle)bundle).getInt(INSTANCE_TEXT_COLOR);
            this.setMax(((Bundle)bundle).getInt(INSTANCE_MAX));
            this.setProgress(((Bundle)bundle).getFloat(INSTANCE_PROGRESS));
            this.finishedStrokeColor = ((Bundle)bundle).getInt(INSTANCE_FINISHED_STROKE_COLOR);
            this.unfinishedStrokeColor = ((Bundle)bundle).getInt(INSTANCE_UNFINISHED_STROKE_COLOR);
            this.suffixText = String.valueOf(((Bundle)bundle).getString(INSTANCE_SUFFIX));
            this.initPainters();
            super.onRestoreInstanceState(((Bundle)bundle).getParcelable(INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    @JvmOverloads
    public ArcProgress(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.rectF = new RectF();
        this.suffixText = "%";
        this.default_finished_color = -1;
        this.default_unfinished_color = Color.rgb((int)72, (int)106, (int)176);
        this.default_text_color = Color.rgb((int)66, (int)145, (int)241);
        this.default_max = 100;
        this.default_arc_angle = 288.0f;
        Resources resources = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        this.default_text_size = Utils.INSTANCE.sp2px(resources, 18.0f);
        Resources resources2 = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"resources");
        this.min_size = (int)Utils.INSTANCE.dp2px(resources2, 100.0f);
        Resources resources3 = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources3, (String)"resources");
        this.default_text_size = Utils.INSTANCE.sp2px(resources3, 40.0f);
        Resources resources4 = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources4, (String)"resources");
        this.default_suffix_text_size = Utils.INSTANCE.sp2px(resources4, 15.0f);
        Resources resources5 = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources5, (String)"resources");
        this.default_suffix_padding = Utils.INSTANCE.dp2px(resources5, 4.0f);
        this.default_suffix_text = "%";
        Resources resources6 = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources6, (String)"resources");
        this.default_bottom_text_size = Utils.INSTANCE.sp2px(resources6, 10.0f);
        Resources resources7 = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources7, (String)"resources");
        this.default_stroke_width = Utils.INSTANCE.dp2px(resources7, 4.0f);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ArcProgress, defStyleAttr, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026rogress, defStyleAttr, 0)");
        TypedArray attributes = typedArray;
        this.initByAttributes(attributes);
        attributes.recycle();
        this.initPainters();
    }

    public /* synthetic */ ArcProgress(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ArcProgress(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ArcProgress(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/github/lzyzsd/circleprogresskt/ArcProgress$Companion;", "", "()V", "INSTANCE_ARC_ANGLE", "", "INSTANCE_BOTTOM_TEXT", "INSTANCE_BOTTOM_TEXT_SIZE", "INSTANCE_FINISHED_STROKE_COLOR", "INSTANCE_MAX", "INSTANCE_PROGRESS", "INSTANCE_STATE", "INSTANCE_STROKE_WIDTH", "INSTANCE_SUFFIX", "INSTANCE_SUFFIX_TEXT_PADDING", "INSTANCE_SUFFIX_TEXT_SIZE", "INSTANCE_TEXT_COLOR", "INSTANCE_TEXT_SIZE", "INSTANCE_UNFINISHED_STROKE_COLOR", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

