/*
 * Decompiled with CFR 0.152.
 */
package com.android.tony.defenselib.hook;

import android.os.Looper;
import com.android.tony.defenselib.handler.ExceptionDispatcher;
import com.android.tony.defenselib.hook.IHook;
import com.android.tony.defenselib.hook.SafeMode;

public class HookThreadLoop
implements IHook {
    private volatile boolean isHooked;
    private ExceptionDispatcher mExceptionDispatcher;
    private Thread.UncaughtExceptionHandler mOriginHandler;

    public HookThreadLoop(ExceptionDispatcher exceptionDispatcher) {
        this.mExceptionDispatcher = exceptionDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hook() {
        if (this.isHooked()) {
            return;
        }
        this.mOriginHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            if (t == Looper.getMainLooper().getThread()) {
                SafeMode.setIsSafeMode(true);
            }
            if (this.mExceptionDispatcher != null && !ExceptionDispatcher.hasExemptException(e)) {
                try {
                    this.mExceptionDispatcher.uncaughtExceptionHappened(t, e);
                }
                catch (Exception ex) {
                    this.mOriginHandler.uncaughtException(t, e);
                }
            }
            if (t == Looper.getMainLooper().getThread() && !ExceptionDispatcher.hasExemptException(e)) {
                this.enterSafeModeKeepLoop(this.mExceptionDispatcher);
            }
            if (ExceptionDispatcher.hasExemptException(e)) {
                this.mOriginHandler.uncaughtException(t, e);
            }
        });
        HookThreadLoop hookThreadLoop = this;
        synchronized (hookThreadLoop) {
            this.isHooked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unHook() {
        if (!this.isHooked()) {
            return;
        }
        Thread.setDefaultUncaughtExceptionHandler(this.mOriginHandler);
        HookThreadLoop hookThreadLoop = this;
        synchronized (hookThreadLoop) {
            this.isHooked = false;
        }
    }

    public void enterSafeModeKeepLoop(ExceptionDispatcher dispatcher) {
        if (!SafeMode.isIsSafeMode()) {
            SafeMode.setIsSafeMode(true);
        }
        do {
            try {
                Looper.loop();
            }
            catch (Throwable e) {
                if (dispatcher == null) continue;
                if (!ExceptionDispatcher.hasExemptException(e)) {
                    try {
                        dispatcher.uncaughtExceptionHappened(Looper.getMainLooper().getThread(), e);
                    }
                    catch (Exception ex) {
                        this.mOriginHandler.uncaughtException(Looper.getMainLooper().getThread(), e);
                    }
                    continue;
                }
                this.mOriginHandler.uncaughtException(Looper.getMainLooper().getThread(), e);
                break;
            }
        } while (this.isHooked());
    }

    @Override
    public boolean isHooked() {
        return this.isHooked;
    }
}

