/*
 * Decompiled with CFR 0.152.
 */
package com.android.tony.defenselib.hook;

import android.app.Instrumentation;
import android.content.Context;
import android.os.Looper;
import com.android.cglib.proxy.Enhancer;
import com.android.cglib.proxy.MethodInterceptor;
import com.android.cglib.proxy.MethodProxy;
import com.android.tony.defenselib.handler.ExceptionDispatcher;
import java.lang.reflect.InvocationTargetException;

public class InstrumentationProxy
implements MethodInterceptor {
    private Context mContext;
    private Instrumentation mInstrumentation;
    private ExceptionDispatcher mExceptionDispatcher;

    public InstrumentationProxy(Context context, Instrumentation instrumentation, ExceptionDispatcher exceptionDispatcher) {
        this.mContext = context;
        this.mInstrumentation = instrumentation;
        this.mExceptionDispatcher = exceptionDispatcher;
    }

    public Instrumentation getProxy(Class<? extends Instrumentation> clz) {
        Enhancer enhancer = new Enhancer(this.mContext);
        enhancer.setSuperclass(clz);
        enhancer.setInterceptor((MethodInterceptor)this);
        return (Instrumentation)enhancer.create();
    }

    public Object intercept(Object object, Object[] args, MethodProxy methodProxy) throws Exception {
        if ("onException".equals(methodProxy.getMethodName()) && !ExceptionDispatcher.hasExemptException((Throwable)args[1])) {
            this.mExceptionDispatcher.uncaughtExceptionHappened(Looper.getMainLooper().getThread(), (Throwable)args[1]);
            return true;
        }
        try {
            return methodProxy.invokeSuper((Object)this.mInstrumentation, args);
        }
        catch (Throwable e) {
            Throwable temp;
            if (e instanceof InvocationTargetException && (temp = ((InvocationTargetException)e).getTargetException()) != null) {
                e = temp;
            }
            if (!ExceptionDispatcher.hasExemptException(e)) {
                this.mExceptionDispatcher.uncaughtExceptionHappened(Looper.getMainLooper().getThread(), e);
            }
            return null;
        }
    }
}

