/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.mvvmquick.binding.adapter;

import android.databinding.BindingAdapter;
import android.os.Message;
import android.support.v4.widget.SwipeRefreshLayout;
import com.xujiaji.mvvmquick.base.MQViewModel;
import java.lang.ref.WeakReference;

public class SwipeRefreshLayoutBindingAdapter {
    private static final int CODE = 1001;

    @BindingAdapter(value={"android:onRefresh"})
    public static <T extends MQViewModel> void setSwipeRefreshLayoutOnRefreshListener(SwipeRefreshLayout view, final T viewModel) {
        final Handler handler = new Handler(view);
        view.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                handler.removeMessages(1001);
                viewModel.onListRefresh();
                handler.sendEmptyMessageDelayed(1001, viewModel.timeout() * 1000);
            }
        });
    }

    private static class Handler
    extends android.os.Handler {
        private WeakReference<SwipeRefreshLayout> wr;

        private Handler(SwipeRefreshLayout srl) {
            this.wr = new WeakReference<SwipeRefreshLayout>(srl);
        }

        public void handleMessage(Message msg) {
            if (this.wr.get() == null) {
                return;
            }
            if (msg.what == 1001 && ((SwipeRefreshLayout)this.wr.get()).isRefreshing()) {
                ((SwipeRefreshLayout)this.wr.get()).setRefreshing(false);
            }
        }
    }
}

