/*
 * Decompiled with CFR 0.152.
 */
package com.github.xujiaji.mk.security.admin.service;

import cn.hutool.core.util.StrUtil;
import com.github.xujiaji.mk.common.payload.PageCondition;
import com.github.xujiaji.mk.common.service.IUserInfoService;
import com.github.xujiaji.mk.common.util.RedisUtil;
import com.github.xujiaji.mk.common.vo.PageVO;
import com.github.xujiaji.mk.security.admin.vo.OnlineUser;
import com.github.xujiaji.mk.security.mapper.MkSecUserMapper;
import com.github.xujiaji.mk.security.util.SecurityUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonitorService {
    private static final Logger log = LoggerFactory.getLogger(MonitorService.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MkSecUserMapper mkSecUserMapper;
    @Autowired
    private IUserInfoService userInfoService;

    public PageVO<OnlineUser> onlineUser(PageCondition pageCondition) {
        PageVO keys = this.redisUtil.findKeysForPage("security:jwt:*", pageCondition.getPage().longValue(), pageCondition.getSize().longValue());
        List rows = keys.getList();
        Long total = keys.getTotal();
        List usernameList = rows.stream().map(s -> StrUtil.subAfter((CharSequence)s, (CharSequence)"security:jwt:", (boolean)true)).collect(Collectors.toList());
        List userList = this.mkSecUserMapper.selectBatchIds(usernameList);
        ArrayList onlineUserList = Lists.newArrayList();
        userList.forEach(user -> onlineUserList.add(OnlineUser.create(user, this.userInfoService.getUserWithPhoneEmailPassword(user.getUserId()))));
        return PageVO.create((List)onlineUserList, (Long)pageCondition.getPage(), (Long)pageCondition.getSize(), (Long)keys.getTotal());
    }

    public void kickout(List<String> names) {
        List redisKeys = names.parallelStream().map(s -> "security:jwt:" + s).collect(Collectors.toList());
        this.redisUtil.delete(redisKeys);
        String currentUsername = SecurityUtil.getCurrentUsername();
        names.parallelStream().forEach(name -> log.debug("\u7528\u6237\u3010{}\u3011\u88ab\u7528\u6237\u3010{}\u3011\u624b\u52a8\u4e0b\u7ebf\uff01", name, (Object)currentUsername));
    }
}

