/*
 * Decompiled with CFR 0.152.
 */
package com.github.xujiaji.mk.security.admin.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.github.xujiaji.mk.common.base.ApiResponse;
import com.github.xujiaji.mk.common.base.BaseController;
import com.github.xujiaji.mk.common.exception.RequestActionException;
import com.github.xujiaji.mk.security.admin.payload.PermissionAddCondition;
import com.github.xujiaji.mk.security.admin.payload.PermissionEditCondition;
import com.github.xujiaji.mk.security.entity.MkSecPermission;
import com.github.xujiaji.mk.security.service.impl.MkSecPermissionServiceImpl;
import com.github.xujiaji.mk.security.util.SecurityUtil;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/sec/permission"})
public class MkSecAdminPermissionController
extends BaseController {
    @Autowired
    MkSecPermissionServiceImpl permissionService;

    @GetMapping(value={"/tree"})
    public ApiResponse<List<Map<String, Object>>> tree() {
        List permissions = ((QueryChainWrapper)this.permissionService.query().orderByAsc((Object)"sort")).list();
        return this.success(this.treeIdAndParentId(permissions));
    }

    @GetMapping(value={"/user/tree"})
    public ApiResponse<List<Map<String, Object>>> userTree() {
        Long currentSecUserId = SecurityUtil.getCurrentSecUserId();
        List permissions = this.permissionService.userPermissions(currentSecUserId);
        return this.success(this.treeIdAndParentId(permissions));
    }

    private void checkTypeMethod(Integer type, String method) {
        if (type.equals(2) && StrUtil.isEmpty((CharSequence)method)) {
            throw new RequestActionException("\u5982\u679c\u662f\u6309\u94ae\u7c7b\u578b\u7684\u63a5\u53e3\u8bf7\u6c42\u65b9\u5f0f\uff08type = 2\uff09\uff0c\u90a3\u4e48\u5fc5\u987b\u4f20\u5165\u8bf7\u6c42\u65b9\u5f0f\u5982\uff1aGET POST PUT \u7b49");
        }
    }

    @PostMapping(value={"/add"})
    public ApiResponse<?> permissionAdd(@RequestBody @Valid PermissionAddCondition request) {
        this.checkTypeMethod(request.getType(), request.getMethod());
        this.permissionService.add(this.request2Entity(request, MkSecPermission.class));
        return this.successAdd();
    }

    @PutMapping(value={"/edit"})
    public ApiResponse<?> permissionEdit(@RequestBody @Valid PermissionEditCondition request) {
        this.checkTypeMethod(request.getType(), request.getMethod());
        this.permissionService.editById(this.request2Entity(request, MkSecPermission.class));
        return this.successUpdate();
    }

    @DeleteMapping(value={"/del"})
    public ApiResponse<?> permissionDelete(Long id) {
        this.permissionService.deletePermission(id);
        return this.successDelete();
    }
}

