/*
 * Decompiled with CFR 0.152.
 */
package com.github.xujiaji.mk.security.admin.controller;

import cn.hutool.core.collection.CollUtil;
import com.github.xujiaji.mk.common.base.ApiResponse;
import com.github.xujiaji.mk.common.base.Status;
import com.github.xujiaji.mk.common.payload.PageCondition;
import com.github.xujiaji.mk.common.vo.PageVO;
import com.github.xujiaji.mk.security.admin.service.MonitorService;
import com.github.xujiaji.mk.security.admin.vo.OnlineUser;
import com.github.xujiaji.mk.security.exception.SecurityException;
import com.github.xujiaji.mk.security.util.SecurityUtil;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/monitor"})
public class MonitorController {
    private static final Logger log = LoggerFactory.getLogger(MonitorController.class);
    @Autowired
    private MonitorService monitorService;

    @GetMapping(value={"/online/user"})
    public ApiResponse<PageVO<OnlineUser>> onlineUser(@Valid PageCondition pageCondition) {
        return ApiResponse.ofSuccess(this.monitorService.onlineUser(pageCondition));
    }

    @DeleteMapping(value={"/online/user/kickout"})
    public ApiResponse<?> kickoutOnlineUser(@RequestBody List<String> names) {
        if (CollUtil.isEmpty(names)) {
            throw new SecurityException(Status.PARAM_NOT_NULL);
        }
        if (names.contains(SecurityUtil.getCurrentUsername())) {
            throw new SecurityException(Status.KICKOUT_SELF);
        }
        this.monitorService.kickout(names);
        return ApiResponse.ofSuccess();
    }
}

