/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.happybubble;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import com.xujiaji.happybubble.R;
import com.xujiaji.happybubble.Util;

public class BubbleLayout
extends FrameLayout {
    private Paint mPaint;
    private Path mPath;
    private Look mLook;
    private int mBubblePadding;
    private int mWidth;
    private int mHeight;
    private int mLeft;
    private int mTop;
    private int mRight;
    private int mBottom;
    private int mLookPosition;
    private int mLookWidth;
    private int mLookLength;
    private int mShadowColor;
    private int mShadowRadius;
    private int mShadowX;
    private int mShadowY;
    private int mBubbleRadius;
    private int mBubbleColor;

    public BubbleLayout(Context context) {
        this(context, null);
    }

    public BubbleLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BubbleLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayerType(1, null);
        this.setWillNotDraw(false);
        this.initAttr(context.obtainStyledAttributes(attrs, R.styleable.BubbleLayout, defStyleAttr, 0));
        this.mPaint = new Paint(5);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPath = new Path();
        this.initPadding();
    }

    public void initPadding() {
        int p = this.mBubblePadding * 2;
        switch (this.mLook) {
            case BOTTOM: {
                this.setPadding(p, p, p, this.mLookLength + p);
                break;
            }
            case TOP: {
                this.setPadding(p, p + this.mLookLength, p, p);
                break;
            }
            case LEFT: {
                this.setPadding(p + this.mLookLength, p, p, p);
                break;
            }
            case RIGHT: {
                this.setPadding(p, p, p + this.mLookLength, p);
            }
        }
    }

    private void initAttr(TypedArray a) {
        this.mLook = Look.getType(a.getInt(R.styleable.BubbleLayout_lookAt, Look.BOTTOM.value));
        this.mLookPosition = a.getDimensionPixelOffset(R.styleable.BubbleLayout_lookPosition, 0);
        this.mLookWidth = a.getDimensionPixelOffset(R.styleable.BubbleLayout_lookWidth, 50);
        this.mLookLength = a.getDimensionPixelOffset(R.styleable.BubbleLayout_lookLength, 50);
        this.mShadowRadius = a.getDimensionPixelOffset(R.styleable.BubbleLayout_shadowRadius, 10);
        this.mShadowX = a.getDimensionPixelOffset(R.styleable.BubbleLayout_shadowX, 3);
        this.mShadowY = a.getDimensionPixelOffset(R.styleable.BubbleLayout_shadowY, 3);
        this.mBubbleRadius = a.getDimensionPixelOffset(R.styleable.BubbleLayout_bubbleRadius, 20);
        this.mBubblePadding = a.getDimensionPixelOffset(R.styleable.BubbleLayout_bubblePadding, Util.dpToPx(this.getContext(), 8.0f));
        this.mShadowColor = a.getColor(R.styleable.BubbleLayout_shadowColor, -7829368);
        this.mBubbleColor = a.getColor(R.styleable.BubbleLayout_bubbleColor, -1);
        a.recycle();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        this.initData();
    }

    public void invalidate() {
        this.initData();
        super.invalidate();
    }

    public void postInvalidate() {
        this.initData();
        super.postInvalidate();
    }

    private void initData() {
        this.mPaint.setPathEffect((PathEffect)new CornerPathEffect((float)this.mBubbleRadius));
        this.mPaint.setShadowLayer((float)this.mShadowRadius, (float)this.mShadowX, (float)this.mShadowY, this.mShadowColor);
        this.mLeft = this.mBubblePadding + (this.mLook == Look.LEFT ? this.mLookLength : 0);
        this.mTop = this.mBubblePadding + (this.mLook == Look.TOP ? this.mLookLength : 0);
        this.mRight = this.mWidth - this.mBubblePadding - (this.mLook == Look.RIGHT ? this.mLookLength : 0);
        this.mBottom = this.mHeight - this.mBubblePadding - (this.mLook == Look.BOTTOM ? this.mLookLength : 0);
        this.mPaint.setColor(this.mBubbleColor);
        this.mPath.reset();
        int topOffset = this.mLookPosition;
        topOffset = topOffset + this.mLookLength > this.mBottom ? this.mBottom - this.mLookWidth : topOffset;
        topOffset = topOffset > this.mBubblePadding ? topOffset : this.mBubblePadding;
        int leftOffset = this.mLookPosition;
        leftOffset = leftOffset + this.mLookLength > this.mRight ? this.mRight - this.mLookWidth : leftOffset;
        leftOffset = leftOffset > this.mBubblePadding ? leftOffset : this.mBubblePadding;
        switch (this.mLook) {
            case LEFT: {
                this.mPath.moveTo((float)this.mLeft, (float)topOffset);
                this.mPath.rLineTo((float)(-this.mLookLength), (float)(this.mLookWidth / 2));
                this.mPath.rLineTo((float)this.mLookLength, (float)(this.mLookWidth / 2));
                this.mPath.lineTo((float)this.mLeft, (float)this.mBottom);
                this.mPath.lineTo((float)this.mRight, (float)this.mBottom);
                this.mPath.lineTo((float)this.mRight, (float)this.mTop);
                this.mPath.lineTo((float)this.mLeft, (float)this.mTop);
                break;
            }
            case TOP: {
                this.mPath.moveTo((float)leftOffset, (float)this.mTop);
                this.mPath.rLineTo((float)(this.mLookWidth / 2), (float)(-this.mLookLength));
                this.mPath.rLineTo((float)(this.mLookWidth / 2), (float)this.mLookLength);
                this.mPath.lineTo((float)this.mRight, (float)this.mTop);
                this.mPath.lineTo((float)this.mRight, (float)this.mBottom);
                this.mPath.lineTo((float)this.mLeft, (float)this.mBottom);
                this.mPath.lineTo((float)this.mLeft, (float)this.mTop);
                break;
            }
            case RIGHT: {
                this.mPath.moveTo((float)this.mRight, (float)topOffset);
                this.mPath.rLineTo((float)this.mLookLength, (float)(this.mLookWidth / 2));
                this.mPath.rLineTo((float)(-this.mLookLength), (float)(this.mLookWidth / 2));
                this.mPath.lineTo((float)this.mRight, (float)this.mBottom);
                this.mPath.lineTo((float)this.mLeft, (float)this.mBottom);
                this.mPath.lineTo((float)this.mLeft, (float)this.mTop);
                this.mPath.lineTo((float)this.mRight, (float)this.mTop);
                break;
            }
            case BOTTOM: {
                this.mPath.moveTo((float)leftOffset, (float)this.mBottom);
                this.mPath.rLineTo((float)(this.mLookWidth / 2), (float)this.mLookLength);
                this.mPath.rLineTo((float)(this.mLookWidth / 2), (float)(-this.mLookLength));
                this.mPath.lineTo((float)this.mRight, (float)this.mBottom);
                this.mPath.lineTo((float)this.mRight, (float)this.mTop);
                this.mPath.lineTo((float)this.mLeft, (float)this.mTop);
                this.mPath.lineTo((float)this.mLeft, (float)this.mBottom);
            }
        }
        this.mPath.close();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public Path getPath() {
        return this.mPath;
    }

    public Look getLook() {
        return this.mLook;
    }

    public int getLookPosition() {
        return this.mLookPosition;
    }

    public int getLookWidth() {
        return this.mLookWidth;
    }

    public int getLookLength() {
        return this.mLookLength;
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public int getShadowRadius() {
        return this.mShadowRadius;
    }

    public int getShadowX() {
        return this.mShadowX;
    }

    public int getShadowY() {
        return this.mShadowY;
    }

    public int getBubbleRadius() {
        return this.mBubbleRadius;
    }

    public int getBubbleColor() {
        return this.mBubbleColor;
    }

    public void setBubbleColor(int mBubbleColor) {
        this.mBubbleColor = mBubbleColor;
    }

    public void setLook(Look mLook) {
        this.mLook = mLook;
    }

    public void setLookPosition(int mLookPosition) {
        this.mLookPosition = mLookPosition;
    }

    public void setLookWidth(int mLookWidth) {
        this.mLookWidth = mLookWidth;
    }

    public void setLookLength(int mLookLength) {
        this.mLookLength = mLookLength;
    }

    public void setShadowColor(int mShadowColor) {
        this.mShadowColor = mShadowColor;
    }

    public void setShadowRadius(int mShadowRadius) {
        this.mShadowRadius = mShadowRadius;
    }

    public void setShadowX(int mShadowX) {
        this.mShadowX = mShadowX;
    }

    public void setShadowY(int mShadowY) {
        this.mShadowY = mShadowY;
    }

    public void setBubbleRadius(int mBubbleRadius) {
        this.mBubbleRadius = mBubbleRadius;
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putInt("mLookPosition", this.mLookPosition);
        bundle.putInt("mLookWidth", this.mLookWidth);
        bundle.putInt("mLookLength", this.mLookLength);
        bundle.putInt("mShadowColor", this.mShadowColor);
        bundle.putInt("mShadowRadius", this.mShadowRadius);
        bundle.putInt("mShadowX", this.mShadowX);
        bundle.putInt("mShadowY", this.mShadowY);
        bundle.putInt("mBubbleRadius", this.mBubbleRadius);
        bundle.putInt("mWidth", this.mWidth);
        bundle.putInt("mHeight", this.mHeight);
        bundle.putInt("mLeft", this.mLeft);
        bundle.putInt("mTop", this.mTop);
        bundle.putInt("mRight", this.mRight);
        bundle.putInt("mBottom", this.mBottom);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mLookPosition = bundle.getInt("mLookPosition");
            this.mLookWidth = bundle.getInt("mLookWidth");
            this.mLookLength = bundle.getInt("mLookLength");
            this.mShadowColor = bundle.getInt("mShadowColor");
            this.mShadowRadius = bundle.getInt("mShadowRadius");
            this.mShadowX = bundle.getInt("mShadowX");
            this.mShadowY = bundle.getInt("mShadowY");
            this.mBubbleRadius = bundle.getInt("mBubbleRadius");
            this.mWidth = bundle.getInt("mWidth");
            this.mHeight = bundle.getInt("mHeight");
            this.mLeft = bundle.getInt("mLeft");
            this.mTop = bundle.getInt("mTop");
            this.mRight = bundle.getInt("mRight");
            this.mBottom = bundle.getInt("mBottom");
            super.onRestoreInstanceState(bundle.getParcelable("instanceState"));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public static enum Look {
        LEFT(1),
        TOP(2),
        RIGHT(3),
        BOTTOM(4);

        int value;

        private Look(int v) {
            this.value = v;
        }

        public static Look getType(int value) {
            Look type = BOTTOM;
            switch (value) {
                case 1: {
                    type = LEFT;
                    break;
                }
                case 2: {
                    type = TOP;
                    break;
                }
                case 3: {
                    type = RIGHT;
                    break;
                }
                case 4: {
                    type = BOTTOM;
                }
            }
            return type;
        }
    }
}

