/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.happybubble;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.xujiaji.happybubble.BubbleLayout;
import com.xujiaji.happybubble.R;
import com.xujiaji.happybubble.Util;

public class BubbleDialog
extends Dialog {
    private BubbleLayout mBubbleLayout;
    private View mAddView;
    private View mClickedView;
    private boolean mCalBar;
    private int mOffsetX;
    private int mOffsetY;
    private boolean mSoftShowUp;
    private Position mPosition = Position.TOP;

    public BubbleDialog(Context context) {
        super(context, R.style.bubble_dialog);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.mBubbleLayout == null) {
            this.mBubbleLayout = new BubbleLayout(this.getContext());
        }
        if (this.mAddView != null) {
            this.mBubbleLayout.addView(this.mAddView);
        }
        this.setContentView((View)this.mBubbleLayout);
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        if (this.mSoftShowUp) {
            window.setSoftInputMode(18);
        }
        window.setLayout(-2, -2);
        this.setLook();
        this.mBubbleLayout.post(new Runnable(){

            @Override
            public void run() {
                BubbleDialog.this.dialogPosition();
            }
        });
    }

    private void setLook() {
        switch (this.mPosition) {
            case LEFT: {
                this.mBubbleLayout.setLook(BubbleLayout.Look.RIGHT);
                break;
            }
            case TOP: {
                this.mBubbleLayout.setLook(BubbleLayout.Look.BOTTOM);
                break;
            }
            case RIGHT: {
                this.mBubbleLayout.setLook(BubbleLayout.Look.LEFT);
                break;
            }
            case BOTTOM: {
                this.mBubbleLayout.setLook(BubbleLayout.Look.TOP);
            }
        }
        this.mBubbleLayout.initPadding();
    }

    public void dismiss() {
        if (this.mSoftShowUp) {
            Util.hide(this);
        }
        super.dismiss();
    }

    private void dialogPosition() {
        if (this.mClickedView == null) {
            throw new RuntimeException("Please add the clicked view.");
        }
        int[] clickedViewLocation = new int[2];
        this.mClickedView.getLocationOnScreen(clickedViewLocation);
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        window.setGravity(51);
        WindowManager.LayoutParams params = window.getAttributes();
        switch (this.mPosition) {
            case TOP: 
            case BOTTOM: {
                params.x = clickedViewLocation[0] + this.mClickedView.getWidth() / 2 - this.mBubbleLayout.getWidth() / 2 + this.mOffsetX;
                if (params.x <= 0) {
                    this.mBubbleLayout.setLookPosition(clickedViewLocation[0] + this.mClickedView.getWidth() / 2 - this.mBubbleLayout.getLookWidth() / 2);
                } else if (params.x + this.mBubbleLayout.getWidth() > Util.getScreenWH(this.getContext())[0]) {
                    this.mBubbleLayout.setLookPosition(clickedViewLocation[0] - (Util.getScreenWH(this.getContext())[0] - this.mBubbleLayout.getWidth()) + this.mClickedView.getWidth() / 2 - this.mBubbleLayout.getLookWidth() / 2);
                } else {
                    this.mBubbleLayout.setLookPosition(clickedViewLocation[0] - params.x + this.mClickedView.getWidth() / 2 - this.mBubbleLayout.getLookWidth() / 2);
                }
                if (this.mPosition == Position.BOTTOM) {
                    params.y = clickedViewLocation[1] - (this.mCalBar ? Util.getStatusHeight(this.getContext()) : 0) + this.mClickedView.getHeight() + this.mOffsetY;
                    break;
                }
                params.y = clickedViewLocation[1] - (this.mCalBar ? Util.getStatusHeight(this.getContext()) : 0) - this.mBubbleLayout.getHeight() + this.mOffsetY;
                break;
            }
            case LEFT: 
            case RIGHT: {
                params.y = clickedViewLocation[1] - (this.mCalBar ? Util.getStatusHeight(this.getContext()) : 0) + this.mOffsetY + this.mClickedView.getHeight() / 2 - this.mBubbleLayout.getHeight() / 2;
                if (params.y <= 0) {
                    this.mBubbleLayout.setLookPosition(clickedViewLocation[1] + this.mClickedView.getHeight() / 2 - this.mBubbleLayout.getLookWidth() / 2);
                } else if (params.y + this.mBubbleLayout.getHeight() > Util.getScreenWH(this.getContext())[1]) {
                    this.mBubbleLayout.setLookPosition(clickedViewLocation[1] - (Util.getScreenWH(this.getContext())[1] - this.mBubbleLayout.getHeight() + this.mClickedView.getHeight() / 2 - this.mBubbleLayout.getLookWidth() / 2));
                } else {
                    this.mBubbleLayout.setLookPosition(clickedViewLocation[1] - params.y + this.mClickedView.getHeight() / 2 - this.mBubbleLayout.getLookWidth() / 2 - (this.mCalBar ? Util.getStatusHeight(this.getContext()) : 0));
                }
                params.x = this.mPosition == Position.RIGHT ? clickedViewLocation[0] + this.mClickedView.getWidth() + this.mOffsetX : clickedViewLocation[0] - this.mBubbleLayout.getWidth() + this.mOffsetX;
            }
        }
        this.mBubbleLayout.invalidate();
        window.setAttributes(params);
    }

    public <T extends BubbleDialog> T calBar(boolean cal) {
        this.mCalBar = cal;
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setClickedView(View view) {
        this.mClickedView = view;
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T softShowUp() {
        this.mSoftShowUp = true;
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T addContentView(View view) {
        this.mAddView = view;
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setPosition(Position position) {
        this.mPosition = position;
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setOffsetX(int offsetX) {
        this.mOffsetX = Util.dpToPx(this.getContext(), offsetX);
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setOffsetY(int offsetY) {
        this.mOffsetY = Util.dpToPx(this.getContext(), offsetY);
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setBubbleLayout(BubbleLayout bl) {
        this.mBubbleLayout = bl;
        return (T)((Object)this);
    }

    public <T extends BubbleDialog> T setTransParentBackground() {
        Window window = this.getWindow();
        if (window == null) {
            return (T)((Object)this);
        }
        window.setDimAmount(0.0f);
        return (T)((Object)this);
    }

    public static enum Position {
        LEFT,
        TOP,
        RIGHT,
        BOTTOM;

    }
}

