/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.dmlib2.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import com.xujiaji.dmlib2.DM;
import com.xujiaji.dmlib2.Direction;
import com.xujiaji.dmlib2.R;
import com.xujiaji.dmlib2.SurfaceProxy;
import com.xujiaji.dmlib2.Util;
import com.xujiaji.dmlib2.widget.Controller;

public class DMTextureView
extends TextureView
implements TextureView.SurfaceTextureListener,
DM {
    private Surface mSurface;
    private Controller mController;

    public DMTextureView(Context context) {
        this(context, null);
    }

    public DMTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DMTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setSurfaceTextureListener(this);
        this.mController = new Controller();
        this.setOpaque(false);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DMTextureView, defStyleAttr, 0);
        Direction direction = Direction.getType(a.getInt(R.styleable.DMTextureView_dm_direction, Direction.RIGHT_LEFT.value));
        int span = a.getDimensionPixelOffset(R.styleable.DMTextureView_dm_span, Util.dp2px(context, 2.0f));
        int sleep = a.getInteger(R.styleable.DMTextureView_dm_sleep, 0);
        int vSpace = a.getDimensionPixelOffset(R.styleable.DMTextureView_dm_v_space, Util.dp2px(context, 10.0f));
        int hSpace = a.getDimensionPixelOffset(R.styleable.DMTextureView_dm_h_space, Util.dp2px(context, 10.0f));
        a.recycle();
        this.mController.setDirection(direction);
        this.mController.sethSpace(hSpace);
        this.mController.setvSpace(vSpace);
        this.mController.setSpan(span);
        this.mController.setSleep(sleep);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mSurface = new Surface(surface);
        this.mController.init(width, height, new SurfaceProxy(this.mSurface));
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        if (this.mSurface != null) {
            this.mSurface.release();
        }
        this.mSurface = null;
        this.mController.destroy();
        return true;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (this.mSurface == null) {
            return;
        }
        if (hasWindowFocus) {
            this.mController.prepare();
        } else {
            this.mController.pause();
            this.mController.draw(0, true);
        }
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    @Override
    public Controller getController() {
        return this.mController;
    }
}

