/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.dmlib2.entity;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.View;
import com.xujiaji.dmlib2.Direction;
import com.xujiaji.dmlib2.Util;

public class BaseDmEntity
implements Comparable<BaseDmEntity> {
    public final Bitmap bitmap;
    public final Rect rect = new Rect();
    public final int priority;

    public BaseDmEntity(View itemView) {
        this(itemView, 0);
    }

    public BaseDmEntity(View itemView, int priority) {
        this.bitmap = Util.convertViewToBitmap(itemView);
        this.priority = priority;
        this.rect.set(0, 0, this.bitmap.getWidth(), this.bitmap.getHeight());
    }

    public boolean isNeedDraw(Direction direction, int displayDis) {
        switch (direction) {
            case RIGHT_LEFT: 
            case LEFT_RIGHT: {
                return this.rect.left < displayDis;
            }
            case DOWN_UP: 
            case UP_DOWN: {
                return this.rect.top < displayDis;
            }
        }
        throw new RuntimeException("not direction " + direction.name() + " in 'isNeedDraw()'");
    }

    @Override
    public int compareTo(BaseDmEntity o) {
        if (this.priority > o.priority) {
            return 1;
        }
        if (this.priority < o.priority) {
            return -1;
        }
        return 0;
    }
}

