/*
 * Decompiled with CFR 0.152.
 */
package com.xujiaji.dmlib2.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import com.xujiaji.dmlib2.DM;
import com.xujiaji.dmlib2.Direction;
import com.xujiaji.dmlib2.R;
import com.xujiaji.dmlib2.SurfaceProxy;
import com.xujiaji.dmlib2.widget.Controller;

public class DMTextureView
extends TextureView
implements TextureView.SurfaceTextureListener,
DM {
    private Surface mSurface;
    private Controller mController;
    private Direction mDirection;
    private int mDuration = 3000;

    public DMTextureView(Context context) {
        this(context, null);
    }

    public DMTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DMTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setSurfaceTextureListener(this);
        this.mController = new Controller();
        this.setOpaque(false);
        this.initAttr(context.obtainStyledAttributes(attrs, R.styleable.DMTextureView, defStyleAttr, 0));
    }

    private void initAttr(TypedArray a) {
        this.mDirection = Direction.getType(a.getInt(R.styleable.DMTextureView_direction, Direction.RIGHT_LEFT.value));
        this.mDuration = a.getInt(R.styleable.DMTextureView_duration, 3000);
        a.recycle();
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mSurface = new Surface(surface);
        this.mController.init(width, height, this.mDuration, this.mDirection, new SurfaceProxy(this.mSurface));
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.mSurface = null;
        this.mController.destroy();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    @Override
    public Controller getController() {
        return this.mController;
    }
}

