/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.system.wifi;

import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import com.xuexiang.xutil.common.StringUtils;
import com.xuexiang.xutil.common.logger.Logger;
import com.xuexiang.xutil.net.NetworkUtils;
import com.xuexiang.xutil.system.ThreadPoolManager;
import java.util.ArrayList;
import java.util.List;

public final class WifiHelper {
    private static final int DEFAULT_CONNECT_TIME_OUT = 25;
    private static volatile WifiHelper sInstance;
    private WifiManager mWifiManager = NetworkUtils.getWifiManager();
    private WifiInfo mWifiInfo = this.mWifiManager.getConnectionInfo();
    private int mTimeOut = 25;
    private OnWifiConnectStateListener mOnWifiConnectStateListener;
    private List<ScanResult> mWifiList;
    private List<WifiConfiguration> mWifiConfiguration;
    private WifiManager.WifiLock mWifiLock;

    public WifiHelper setOnConnectWifiStateListener(OnWifiConnectStateListener listener) {
        this.mOnWifiConnectStateListener = listener;
        return this;
    }

    public WifiHelper setConnectTimeOut(int timeOut) {
        this.mTimeOut = timeOut;
        return this;
    }

    private WifiHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WifiHelper get() {
        if (sInstance != null) return sInstance;
        Class<WifiHelper> clazz = WifiHelper.class;
        synchronized (WifiHelper.class) {
            if (sInstance != null) return sInstance;
            sInstance = new WifiHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void connectWifi(String wifiSsid, String wifiPassword) {
        ThreadPoolManager.get().addTask(new WifiConnectRunnable(wifiSsid, wifiPassword));
    }

    private void checkWifiEnable() {
        int timeCount = 0;
        while (!this.checkState()) {
            if (timeCount >= this.mTimeOut) {
                this.onCheckWifiStateFinished(false);
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.onCheckWifiStateFinished(false);
                return;
            }
            ++timeCount;
        }
    }

    private void checkConnectWifi(String wifiSsid) {
        int timeCount = 0;
        while (!this.isConnectSuccess(wifiSsid)) {
            if (timeCount >= this.mTimeOut) {
                this.onCheckWifiStateFinished(false);
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.onCheckWifiStateFinished(false);
                return;
            }
            ++timeCount;
        }
        Logger.d((String)("\u8fde\u63a5\u8def\u7531\u82b1\u8d39\u65f6\u95f4\uff1a" + timeCount + "\u79d2"));
        this.onCheckWifiStateFinished(true);
    }

    private void onCheckWifiStateFinished(boolean isConnectSuccess) {
        if (this.mOnWifiConnectStateListener != null) {
            if (isConnectSuccess) {
                this.mOnWifiConnectStateListener.onWifiConnectSuccess();
            } else {
                this.mOnWifiConnectStateListener.onWifiConnectFailed();
            }
        }
    }

    public void release() {
        if (this.mWifiList != null && this.mWifiList.size() > 0) {
            this.mWifiList.clear();
        }
        if (this.mWifiConfiguration != null && this.mWifiConfiguration.size() > 0) {
            this.mWifiConfiguration.clear();
        }
        this.mOnWifiConnectStateListener = null;
    }

    private WifiConfiguration createWifiInfo(String SSID, String Password, int Type2) {
        WifiConfiguration config = new WifiConfiguration();
        config.allowedAuthAlgorithms.clear();
        config.allowedGroupCiphers.clear();
        config.allowedKeyManagement.clear();
        config.allowedPairwiseCiphers.clear();
        config.allowedProtocols.clear();
        config.SSID = "\"" + SSID + "\"";
        if (Type2 == 1) {
            config.allowedKeyManagement.set(0);
        } else if (Type2 == 2) {
            config.hiddenSSID = true;
            config.wepKeys[0] = "\"" + Password + "\"";
            config.allowedAuthAlgorithms.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedGroupCiphers.set(2);
            config.allowedGroupCiphers.set(0);
            config.allowedGroupCiphers.set(1);
            config.allowedKeyManagement.set(0);
            config.wepTxKeyIndex = 0;
        } else if (Type2 == 3) {
            config.preSharedKey = "\"" + Password + "\"";
            config.hiddenSSID = true;
            config.allowedAuthAlgorithms.set(0);
            config.allowedGroupCiphers.set(2);
            config.allowedKeyManagement.set(1);
            config.allowedPairwiseCiphers.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedPairwiseCiphers.set(2);
            config.status = 2;
        }
        return config;
    }

    public void connectConfiguration(int index) {
        if (index > this.mWifiConfiguration.size()) {
            return;
        }
        this.mWifiManager.enableNetwork(this.mWifiConfiguration.get((int)index).networkId, true);
    }

    public boolean addNetwork(WifiConfiguration wcg) {
        int wcgID = this.mWifiManager.addNetwork(wcg);
        boolean result = this.mWifiManager.enableNetwork(wcgID, true);
        return result;
    }

    public boolean connectConfigurationWifi(WifiConfiguration wcg) {
        return this.mWifiManager.enableNetwork(wcg.networkId, true);
    }

    public void disconnectWifi(int netId) {
        this.mWifiManager.disableNetwork(netId);
        this.mWifiManager.disconnect();
    }

    public void openWifi() {
        if (!this.mWifiManager.isWifiEnabled()) {
            this.mWifiManager.setWifiEnabled(true);
        }
    }

    public void closeWifi() {
        if (this.mWifiManager.isWifiEnabled()) {
            this.mWifiManager.setWifiEnabled(false);
        }
    }

    public boolean checkState() {
        return this.mWifiManager.isWifiEnabled();
    }

    public void acquireWifiLock(String tag) {
        if (this.mWifiLock == null) {
            this.mWifiLock = this.mWifiManager.createWifiLock(tag);
        }
        this.mWifiLock.acquire();
    }

    public void releaseWifiLock() {
        if (this.mWifiLock != null && this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
        }
    }

    public WifiConfiguration isExistSSID(List<WifiConfiguration> wifiConfigurations, String SSID) {
        for (WifiConfiguration existingConfig : wifiConfigurations) {
            if (!existingConfig.SSID.equals("\"" + SSID + "\"") && !existingConfig.SSID.equals(SSID)) continue;
            return existingConfig;
        }
        return null;
    }

    public boolean checkSSIDState(String ssid) {
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        return this.mWifiInfo != null && this.getSSID() != null && (this.getSSID().equals("\"" + ssid + "\"") || this.getSSID().equals(ssid));
    }

    public boolean isConnectSuccess(String wifiSsid) {
        return this.checkState() && this.checkSSIDState(wifiSsid) && NetworkUtils.isHaveInternet();
    }

    public List<WifiConfiguration> startScan() {
        this.mWifiManager.startScan();
        this.mWifiList = this.mWifiManager.getScanResults();
        return this.mWifiManager.getConfiguredNetworks();
    }

    public List<ScanResult> getWifiList() {
        return this.mWifiList;
    }

    public StringBuilder lookUpScan() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.mWifiList.size(); ++i) {
            stringBuilder.append("Index_" + new Integer(i + 1).toString() + ":");
            stringBuilder.append(this.mWifiList.get((int)i).SSID.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder;
    }

    public List<String> getScanResultList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.mWifiList != null && this.mWifiList.size() > 0) {
            for (int i = 0; i < this.mWifiList.size(); ++i) {
                list.add(i + "\u53f7--  " + this.mWifiList.get((int)i).SSID);
            }
        }
        return list;
    }

    public List<String> getConfigWifiList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.mWifiConfiguration != null && this.mWifiConfiguration.size() > 0) {
            for (int i = 0; i < this.mWifiConfiguration.size(); ++i) {
                list.add(i + "\u53f7--  " + this.mWifiConfiguration.get((int)i).SSID);
            }
        }
        return list;
    }

    public boolean checkScanResult(String SSID) {
        if (this.mWifiList != null && this.mWifiList.size() > 0) {
            for (int i = 0; i < this.mWifiList.size(); ++i) {
                if (!this.mWifiList.get((int)i).SSID.equals(SSID) && !this.mWifiList.get((int)i).SSID.equals("\"" + SSID + "\"")) continue;
                return true;
            }
        }
        return false;
    }

    private String getMacAddress() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.getMacAddress();
    }

    private String getBSSID() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.getBSSID();
    }

    private int getIpAddress() {
        return this.mWifiInfo == null ? 0 : this.mWifiInfo.getIpAddress();
    }

    private int getNetworkId() {
        return this.mWifiInfo == null ? 0 : this.mWifiInfo.getNetworkId();
    }

    private String getWifiInfo() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.toString();
    }

    private String getSSID() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.getSSID();
    }

    public List<WifiConfiguration> getConfiguration() {
        return this.mWifiConfiguration;
    }

    public static interface OnWifiConnectStateListener {
        public void onWifiConnectSuccess();

        public void onWifiConnectFailed();
    }

    private class WifiConnectRunnable
    implements Runnable {
        private String mWifiSsid;
        private String mWifiPassword;

        public WifiConnectRunnable(String wifiSsid, String wifiPassword) {
            this.mWifiSsid = wifiSsid;
            this.mWifiPassword = wifiPassword;
        }

        @Override
        public void run() {
            if (!WifiHelper.this.checkState()) {
                WifiHelper.this.openWifi();
                WifiHelper.this.checkWifiEnable();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    WifiHelper.this.onCheckWifiStateFinished(false);
                    return;
                }
            }
            if (WifiHelper.this.checkSSIDState(this.mWifiSsid)) {
                WifiHelper.this.checkConnectWifi(this.mWifiSsid);
            } else {
                WifiHelper.this.mWifiConfiguration = WifiHelper.this.startScan();
                WifiConfiguration wcg = WifiHelper.this.isExistSSID(WifiHelper.this.mWifiConfiguration, this.mWifiSsid);
                if (wcg != null) {
                    WifiHelper.this.connectConfigurationWifi(wcg);
                } else {
                    int encryptionType = 1;
                    if (!StringUtils.isEmpty((CharSequence)this.mWifiPassword)) {
                        encryptionType = 3;
                    }
                    WifiHelper.this.addNetwork(WifiHelper.this.createWifiInfo(this.mWifiSsid, this.mWifiPassword, encryptionType));
                }
                WifiHelper.this.checkConnectWifi(this.mWifiSsid);
            }
        }
    }
}

