/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.system.wifi;

import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.Build;
import com.xuexiang.xutil.net.NetworkUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class WifiAPUtils {
    public static int WIFI_AP_STATE_DISABLING = 0;
    public static int WIFI_AP_STATE_DISABLED = 1;
    public static int WIFI_AP_STATE_ENABLING = 2;
    public static int WIFI_AP_STATE_ENABLED = 3;
    public static int WIFI_AP_STATE_FAILED = 4;

    private WifiAPUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void startWifiAp(String wifiAPSsid, String wifiAPPassword) {
        WifiManager wifiManager = NetworkUtils.getWifiManager();
        try {
            Method method = wifiManager.getClass().getMethod("setWifiApEnabled", WifiConfiguration.class, Boolean.TYPE);
            WifiConfiguration netConfig = WifiAPUtils.getWifiApConfig(wifiAPSsid, wifiAPPassword);
            method.invoke((Object)wifiManager, netConfig, true);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void stopWifiAp(String wifiAPSsid, String wifiAPPassword) {
        WifiManager wifiManager = NetworkUtils.getWifiManager();
        try {
            Method method = wifiManager.getClass().getMethod("setWifiApEnabled", WifiConfiguration.class, Boolean.TYPE);
            WifiConfiguration netConfig = WifiAPUtils.getWifiApConfig(wifiAPSsid, wifiAPPassword);
            method.invoke((Object)wifiManager, netConfig, false);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static WifiConfiguration getWifiApConfig(String wifiApSsid, String wifiApPassword) {
        WifiConfiguration netConfig = new WifiConfiguration();
        int securityType = WifiAPUtils.getSecurityType();
        netConfig.SSID = wifiApSsid;
        netConfig.preSharedKey = wifiApPassword;
        netConfig.allowedAuthAlgorithms.set(0);
        netConfig.allowedProtocols.set(1);
        netConfig.allowedProtocols.set(0);
        netConfig.allowedKeyManagement.set(securityType);
        netConfig.allowedPairwiseCiphers.set(2);
        netConfig.allowedPairwiseCiphers.set(1);
        netConfig.allowedGroupCiphers.set(3);
        netConfig.allowedGroupCiphers.set(2);
        return netConfig;
    }

    public static int getWifiApState() {
        WifiManager wifiManager = NetworkUtils.getWifiManager();
        try {
            Method method = wifiManager.getClass().getMethod("getWifiApState", new Class[0]);
            int state = (Integer)method.invoke((Object)wifiManager, new Object[0]);
            return state;
        }
        catch (Exception e) {
            return WIFI_AP_STATE_FAILED;
        }
    }

    public static boolean isWifiApEnable() {
        return WifiAPUtils.getWifiApState() == WIFI_AP_STATE_ENABLED;
    }

    public static int getAndroidSDKVersion() {
        int version = 0;
        try {
            version = Integer.valueOf(Build.VERSION.SDK);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version;
    }

    public static int getSecurityType() {
        int securityType = 0;
        try {
            securityType = (Integer)WifiConfiguration.KeyMgmt.class.getField("WPA2_PSK").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return securityType;
    }

    static {
        int versionID = WifiAPUtils.getAndroidSDKVersion();
        if (versionID <= 10) {
            WIFI_AP_STATE_DISABLING = 0;
            WIFI_AP_STATE_DISABLED = 1;
            WIFI_AP_STATE_ENABLING = 2;
            WIFI_AP_STATE_ENABLED = 3;
            WIFI_AP_STATE_FAILED = 4;
        } else {
            WIFI_AP_STATE_DISABLING = 10;
            WIFI_AP_STATE_DISABLED = 11;
            WIFI_AP_STATE_ENABLING = 12;
            WIFI_AP_STATE_ENABLED = 13;
            WIFI_AP_STATE_FAILED = 14;
        }
    }
}

