/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.system.wifi;

import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Looper;
import com.xuexiang.xutil.common.StringUtils;
import com.xuexiang.xutil.net.NetworkUtils;
import com.xuexiang.xutil.system.ThreadPoolManager;
import com.xuexiang.xutil.system.wifi.WifiAPUtils;
import com.xuexiang.xutil.tip.ToastUtils;
import com.xuexiang.xutil_sub.R;

public class WifiAPHelper {
    private static volatile WifiAPHelper sInstance;
    private String mWifiAPSsid;
    private String mWifiAPPassword;
    private Handler mWifiHandler;
    private WifiManager mWifiManager = NetworkUtils.getWifiManager();
    private CloseWifiRunnable mCloseWifiRunnable;
    private StartWifiApRunnable mStartWifiApRunnable;
    private CloseWifiApRunnable mCloseWifiApRunnable;
    private OnWifiAPStatusChangedListener mListener;

    public WifiAPHelper() {
        this.mWifiHandler = new Handler(Looper.getMainLooper());
    }

    public WifiAPHelper setWifiAPConfig(String wifiAPSsid, String wifiAPPassword) {
        this.mWifiAPSsid = wifiAPSsid;
        this.mWifiAPPassword = wifiAPPassword;
        return this;
    }

    public WifiAPHelper setWifiAPSsid(String wifiAPSsid) {
        this.mWifiAPSsid = wifiAPSsid;
        return this;
    }

    public WifiAPHelper setWifiAPPassword(String wifiAPPassword) {
        this.mWifiAPPassword = wifiAPPassword;
        return this;
    }

    public WifiAPHelper setOnWifiAPStatusChangedListener(OnWifiAPStatusChangedListener listener) {
        this.mListener = listener;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WifiAPHelper get() {
        if (sInstance != null) return sInstance;
        Class<WifiAPHelper> clazz = WifiAPHelper.class;
        synchronized (WifiAPHelper.class) {
            if (sInstance != null) return sInstance;
            sInstance = new WifiAPHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void startWifiAp() {
        if (this.mWifiManager.isWifiEnabled()) {
            this.closeWifiTh();
        } else {
            this.startWifiApTh();
        }
    }

    public void closeWifiAp() {
        this.stopWifiApTh();
    }

    private void closeWifiTh() {
        this.mCloseWifiRunnable = new CloseWifiRunnable();
        ThreadPoolManager.get().addTask(this.mCloseWifiRunnable);
    }

    private void startWifiApTh() {
        if (!WifiAPUtils.isWifiApEnable()) {
            WifiAPUtils.startWifiAp(this.mWifiAPSsid, this.mWifiAPPassword);
        }
        this.mStartWifiApRunnable = new StartWifiApRunnable();
        ThreadPoolManager.get().addTask(this.mStartWifiApRunnable);
    }

    private void stopWifiApTh() {
        this.mCloseWifiApRunnable = new CloseWifiApRunnable();
        ThreadPoolManager.get().addTask(this.mCloseWifiApRunnable);
    }

    public void release() {
        this.mWifiHandler.removeCallbacksAndMessages(null);
        this.mListener = null;
    }

    public boolean isWifiConnectSuccess(String ssid) {
        return this.mWifiManager.isWifiEnabled() && this.checkSSIDState(ssid) && NetworkUtils.isHaveInternet();
    }

    private boolean checkSSIDState(String ssid) {
        String SSID;
        WifiInfo wifiInfo = this.mWifiManager.getConnectionInfo();
        return wifiInfo != null && !StringUtils.isEmpty((CharSequence)(SSID = this.getSSID(wifiInfo))) && (SSID.equals("\"" + ssid + "\"") || SSID.equals(ssid));
    }

    public String getSSID(WifiInfo wifiInfo) {
        return wifiInfo == null ? "" : wifiInfo.getSSID();
    }

    public static interface OnWifiAPStatusChangedListener {
        public void onWifiAPStatusChanged(boolean var1);
    }

    private class CloseWifiApRunnable
    implements Runnable {
        private CloseWifiApRunnable() {
        }

        @Override
        public void run() {
            int state = WifiAPUtils.getWifiApState();
            if (state == WifiAPUtils.WIFI_AP_STATE_ENABLED) {
                WifiAPUtils.stopWifiAp(WifiAPHelper.this.mWifiAPSsid, WifiAPHelper.this.mWifiAPPassword);
                WifiAPHelper.this.mWifiHandler.postDelayed((Runnable)WifiAPHelper.this.mCloseWifiApRunnable, 100L);
            } else if (state == WifiAPUtils.WIFI_AP_STATE_DISABLING || state == WifiAPUtils.WIFI_AP_STATE_FAILED) {
                WifiAPHelper.this.mWifiHandler.postDelayed((Runnable)WifiAPHelper.this.mCloseWifiApRunnable, 100L);
            } else if (state == WifiAPUtils.WIFI_AP_STATE_DISABLED) {
                WifiAPHelper.this.mWifiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ToastUtils.toast((int)R.string.xutil_tip_close_wifiap_success);
                        if (WifiAPHelper.this.mListener != null) {
                            WifiAPHelper.this.mListener.onWifiAPStatusChanged(false);
                        }
                    }
                });
            }
        }
    }

    private class StartWifiApRunnable
    implements Runnable {
        private StartWifiApRunnable() {
        }

        @Override
        public void run() {
            int state = WifiAPUtils.getWifiApState();
            if (state == WifiAPUtils.WIFI_AP_STATE_FAILED) {
                WifiAPHelper.this.mWifiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ToastUtils.toast((int)R.string.xutil_tip_open_wifiap_failed);
                        if (WifiAPHelper.this.mListener != null) {
                            WifiAPHelper.this.mListener.onWifiAPStatusChanged(false);
                        }
                    }
                });
            } else if (state == WifiAPUtils.WIFI_AP_STATE_DISABLED) {
                WifiAPHelper.this.mWifiHandler.postDelayed((Runnable)WifiAPHelper.this.mStartWifiApRunnable, 100L);
            } else if (state == WifiAPUtils.WIFI_AP_STATE_ENABLING) {
                WifiAPHelper.this.mWifiHandler.postDelayed((Runnable)WifiAPHelper.this.mStartWifiApRunnable, 100L);
            } else if (state == WifiAPUtils.WIFI_AP_STATE_ENABLED) {
                WifiAPHelper.this.mWifiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ToastUtils.toast((int)R.string.xutil_tip_open_wifiap_success);
                        if (WifiAPHelper.this.mListener != null) {
                            WifiAPHelper.this.mListener.onWifiAPStatusChanged(true);
                        }
                    }
                });
            }
        }
    }

    private class CloseWifiRunnable
    implements Runnable {
        private CloseWifiRunnable() {
        }

        @Override
        public void run() {
            int state = WifiAPHelper.this.mWifiManager.getWifiState();
            if (state == 3) {
                WifiAPHelper.this.mWifiManager.setWifiEnabled(false);
                WifiAPHelper.this.mWifiHandler.postDelayed((Runnable)WifiAPHelper.this.mCloseWifiRunnable, 100L);
            } else if (state == 0) {
                WifiAPHelper.this.mWifiHandler.postDelayed((Runnable)WifiAPHelper.this.mCloseWifiRunnable, 100L);
            } else if (state == 1) {
                WifiAPHelper.this.mWifiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        WifiAPHelper.this.startWifiApTh();
                        ToastUtils.toast((int)R.string.xutil_tip_close_wifi_success);
                    }
                });
            }
        }
    }
}

