/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.system;

import com.xuexiang.xutil.system.ThreadPoolUtils;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ThreadPoolManager {
    private static ThreadPoolManager sInstance;
    private ThreadPoolUtils mThreadPoolUtils;

    private ThreadPoolManager() {
        int num = Runtime.getRuntime().availableProcessors();
        this.mThreadPoolUtils = new ThreadPoolUtils(0, num * 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolManager get() {
        if (sInstance != null) return sInstance;
        Class<ThreadPoolManager> clazz = ThreadPoolManager.class;
        synchronized (ThreadPoolManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ThreadPoolManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void updateThreadPool(int type, int corePoolSize) {
        if (!this.mThreadPoolUtils.isShutDown()) {
            this.mThreadPoolUtils.shutDownNow();
        }
        this.mThreadPoolUtils.initThreadPool(type, corePoolSize);
    }

    public void execute(Runnable command) {
        this.mThreadPoolUtils.execute(command);
    }

    public void execute(List<Runnable> commands) {
        for (Runnable command : commands) {
            this.mThreadPoolUtils.execute(command);
        }
    }

    public void shutDown() {
        this.mThreadPoolUtils.getExecutorService().shutdown();
    }

    public List<Runnable> shutDownNow() {
        return this.mThreadPoolUtils.getExecutorService().shutdownNow();
    }

    public boolean isShutDown() {
        return this.mThreadPoolUtils.getExecutorService().isShutdown();
    }

    public boolean isTerminated() {
        return this.mThreadPoolUtils.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.mThreadPoolUtils.awaitTermination(timeout, unit);
    }

    public <T> Future<T> addTask(Callable<T> task) {
        return this.mThreadPoolUtils.addTask(task);
    }

    public <T> Future<T> addTask(Runnable task, T result) {
        return this.mThreadPoolUtils.addTask(task, result);
    }

    public Future<?> addTask(Runnable task) {
        return this.mThreadPoolUtils.addTask(task);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.mThreadPoolUtils.invokeAll(tasks);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.mThreadPoolUtils.invokeAll(tasks, timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.mThreadPoolUtils.invokeAny(tasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.mThreadPoolUtils.invokeAny(tasks, timeout, unit);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.mThreadPoolUtils.schedule(command, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.mThreadPoolUtils.schedule(callable, delay, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.mThreadPoolUtils.getScheduledExecutorService().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.mThreadPoolUtils.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }
}

