/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.system;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Intent;
import android.net.Uri;
import com.xuexiang.xutil.XUtil;

public final class ClipboardUtils {
    private ClipboardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void copyText(CharSequence text) {
        ClipboardManager clipboard = (ClipboardManager)XUtil.getContext().getSystemService("clipboard");
        if (clipboard != null) {
            clipboard.setPrimaryClip(ClipData.newPlainText((CharSequence)"text", (CharSequence)text));
        }
    }

    public static CharSequence getText() {
        ClipData clip;
        ClipboardManager clipboard = (ClipboardManager)XUtil.getContext().getSystemService("clipboard");
        if (clipboard != null && (clip = clipboard.getPrimaryClip()) != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).coerceToText(XUtil.getContext());
        }
        return null;
    }

    public static void copyUri(Uri uri) {
        ClipboardManager clipboard = (ClipboardManager)XUtil.getContext().getSystemService("clipboard");
        if (clipboard != null) {
            clipboard.setPrimaryClip(ClipData.newUri((ContentResolver)XUtil.getContext().getContentResolver(), (CharSequence)"uri", (Uri)uri));
        }
    }

    public static Uri getUri() {
        ClipboardManager clipboard = (ClipboardManager)XUtil.getContext().getSystemService("clipboard");
        ClipData clip = clipboard.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).getUri();
        }
        return null;
    }

    public static void copyIntent(Intent intent) {
        ClipboardManager clipboard = (ClipboardManager)XUtil.getContext().getSystemService("clipboard");
        if (clipboard != null) {
            clipboard.setPrimaryClip(ClipData.newIntent((CharSequence)"intent", (Intent)intent));
        }
    }

    public static Intent getIntent() {
        ClipData clip;
        ClipboardManager clipboard = (ClipboardManager)XUtil.getContext().getSystemService("clipboard");
        if (clipboard != null && (clip = clipboard.getPrimaryClip()) != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).getIntent();
        }
        return null;
    }
}

