/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xutil.system;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import com.xuexiang.xutil.app.PathUtils;
import com.xuexiang.xutil.file.FileUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class CameraUtils {
    private static final String DEFAULT_PIC_PREFIX = "XUtil_Picture";
    public static final String PIC_POSTFIX = ".JPEG";
    public static final String VIDEO_POSTFIX = ".mp4";
    public static final int REQUEST_CAMERA = 1212;
    public static final int TYPE_IMAGE = 1;
    public static final int TYPE_VIDEO = 2;
    private static String sPicPrefix = "XUtil_Picture";

    private CameraUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void setPicPrefix(String sPicPrefix) {
        CameraUtils.sPicPrefix = sPicPrefix;
    }

    public static void startOpenCamera(Fragment fragment, OnOpenCameraListener listener) {
        CameraUtils.startOpenCamera(fragment, FileUtils.getDiskCacheDir((String)"CameraImage"), listener);
    }

    public static void startOpenCamera(Fragment fragment, String dirPath, OnOpenCameraListener listener) {
        CameraUtils.startOpenCamera(fragment, 1, dirPath, PIC_POSTFIX, 1212, listener);
    }

    public static void startOpenCamera(Fragment fragment, int type, String dirPath, String format, int requestCode, OnOpenCameraListener listener) {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(fragment.getContext().getPackageManager()) != null) {
            File cameraFile = CameraUtils.createCameraFile(type, dirPath, format);
            Uri imageUri = PathUtils.getUriForFile((File)cameraFile);
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            if (listener != null) {
                listener.onOpenCamera(cameraFile);
            }
            fragment.startActivityForResult(cameraIntent, requestCode);
        }
    }

    public static void startOpenCamera(Activity activity, OnOpenCameraListener listener) {
        CameraUtils.startOpenCamera(activity, FileUtils.getDiskCacheDir((String)"CameraImage"), listener);
    }

    public static void startOpenCamera(Activity activity, String dirPath, OnOpenCameraListener listener) {
        CameraUtils.startOpenCamera(activity, 1, dirPath, PIC_POSTFIX, 1212, listener);
    }

    public static void startOpenCamera(Activity activity, int type, String dirPath, String format, int requestCode, OnOpenCameraListener listener) {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraIntent.resolveActivity(activity.getPackageManager()) != null) {
            File cameraFile = CameraUtils.createCameraFile(type, dirPath, format);
            Uri imageUri = PathUtils.getUriForFile((File)cameraFile);
            cameraIntent.putExtra("output", (Parcelable)imageUri);
            if (listener != null) {
                listener.onOpenCamera(cameraFile);
            }
            activity.startActivityForResult(cameraIntent, requestCode);
        }
    }

    public static File createCameraFile(int type, String outputCameraPath, String format) {
        String path = !TextUtils.isEmpty((CharSequence)outputCameraPath) ? outputCameraPath : FileUtils.getDiskCacheDir((String)"CameraImage");
        return CameraUtils.createMediaFile(path, type, format);
    }

    private static File createMediaFile(String parentPath, int type, String format) {
        File folderDir = new File(parentPath);
        if (!folderDir.exists()) {
            folderDir.mkdirs();
        }
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.CHINA).format(new Date());
        String fileName = sPicPrefix + "_" + timeStamp;
        File tmpFile = null;
        switch (type) {
            case 1: {
                String postfixType = TextUtils.isEmpty((CharSequence)format) ? PIC_POSTFIX : format;
                tmpFile = new File(folderDir, fileName + postfixType);
                break;
            }
            case 2: {
                tmpFile = new File(folderDir, fileName + VIDEO_POSTFIX);
            }
        }
        return tmpFile;
    }

    public static interface OnOpenCameraListener {
        public void onOpenCamera(File var1);
    }
}

